/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.stationviewmgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nemgr.f_interface.marinee2e.ASNMarineFiberPortList;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineQueryNEFiberPortReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineQueryNEFiberPortRsp;
import com.huawei.nglct.nemgr.marine.e2e.stationviewmgr.TEMarineCTBPortUpdateHandler;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCTBPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public class TEMarineQueryCTBPortHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();

    public int handleRequest(AsnMarineQueryNEFiberPortReq req, AsnMarineQueryNEFiberPortRsp rsp, TaskMgr tm) {
        normalLogger.info(TEAsn1Util.getAsn1String((Object)req));
        String ctbName = new String(req.neName);
        AsnMarineQueryNEFiberPortRsp cRsp = rsp;
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineStationPO.class);
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            return 2;
        }
        if (null == dbResult) {
            normalLogger.error("The dbResult is null!");
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            return 2;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            ASNMarineFiberPortList portList = cRsp.portList;
            List data = dbResult.getData();
            for (Object obj : data) {
                TEMarineStationPO stationPO = (TEMarineStationPO)obj;
                TEMarineQueryCTBPortHandler.filterCTBPortList(stationPO, ctbName, portList);
            }
            cRsp.result.isSuccess = true;
            cRsp.result.setRetCode(retCode);
        } else {
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(retCode);
        }
        normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    private static void filterCTBPortList(TEMarineStationPO poStation, String ctbName, ASNMarineFiberPortList portList) {
        if (null == ctbName || 0 == ctbName.length()) {
            return;
        }
        Set CTBList = poStation.CTBList;
        for (TEMarineCTBPO ctbPoInfo : CTBList) {
            if (!ctbName.equals(ctbPoInfo.Name)) continue;
            TEMarineQueryCTBPortHandler.getPortList(ctbPoInfo, portList);
        }
    }

    private static void getPortList(TEMarineCTBPO ctbPoInfo, ASNMarineFiberPortList portList) {
        if (null == ctbPoInfo || null == portList) {
            return;
        }
        int portInfo = ctbPoInfo.PortInfo;
        TEMarineCTBPortUpdateHandler.getAsnPortList(ctbPoInfo.Name, portInfo, portList);
    }
}

