/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.stationviewmgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnIntList;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineDeleteEndCableReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineDeleteEndCableRsp;
import com.huawei.nglct.nemgr.marine.e2e.stationviewmgr.TEMarineCTBPortUpdateHandler;
import com.huawei.nglct.nemgr.marine.e2e.stationviewmgr.TEMarineStnViewNoticeMgr;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineEndCablePO;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEMarineDeleteEndCableHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private String ctbName;
    private int ctbPortID;

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm) {
        AsnMarineDeleteEndCableReq request = (AsnMarineDeleteEndCableReq)req;
        AsnMarineDeleteEndCableRsp response = (AsnMarineDeleteEndCableRsp)rsp;
        int stnID = request.stationID.intValue();
        int fiberID = request.fiberID.intValue();
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineEndCablePO.class);
            List dataList = dbResult.getData();
            if (!this.isExsit(dataList, fiberID)) {
                response.result.isSuccess = false;
                response.result.setRetCode(1090615086);
                return 2;
            }
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
            response.result.isSuccess = false;
            response.result.setRetCode(1092743443);
            return 2;
        }
        int retCode = this.deleteEndCable(fiberID);
        if (0 == retCode) {
            response.result.isSuccess = true;
            AsnIntList endCableIDList = new AsnIntList();
            endCableIDList.add(fiberID);
            TEMarineStnViewNoticeMgr.sendEndCableDelNoticeToClient(endCableIDList);
            TEMarineCTBPortUpdateHandler.updateMarineCTBPort(stnID, this.ctbName, this.ctbPortID, false);
        } else {
            response.result.isSuccess = false;
            response.result.setRetCode(retCode);
        }
        normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    private int deleteEndCable(int endCableID) {
        ArrayList<TEDaoNameValuePair> deleteCriterion = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair aPair = new TEDaoNameValuePair("EndCableID", String.valueOf(endCableID));
        deleteCriterion.add(aPair);
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.deleteByID(TEMarineEndCablePO.class, deleteCriterion);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Marine----Delete End Cable in DataBase fail!", (Throwable)e);
            return 1092743443;
        }
        return dbResult.getResult();
    }

    private boolean isExsit(List<Object> dataList, int fiberID) {
        if (null == dataList || 0 == dataList.size()) {
            return false;
        }
        for (Object obj : dataList) {
            TEMarineEndCablePO tmpCable = (TEMarineEndCablePO)obj;
            if (fiberID != tmpCable.EndCableID) continue;
            this.ctbName = 0L == tmpCable.SrcNEID ? tmpCable.SrcNEName : tmpCable.DstNEName;
            this.ctbPortID = 0L == tmpCable.SrcNEID ? tmpCable.SrcPortID : tmpCable.DstPortID;
            return true;
        }
        return false;
    }
}

