/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.stationviewmgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineCreateEndCableReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineCreateEndCableRsp;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineEndCable;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineEndCableList;
import com.huawei.nglct.nemgr.marine.e2e.stationviewmgr.TEMarineCTBPortUpdateHandler;
import com.huawei.nglct.nemgr.marine.e2e.stationviewmgr.TEMarineStnViewNoticeMgr;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineEndCablePO;
import java.math.BigInteger;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEMarineCreateEndCableHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private int fiberID = 0;

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm) {
        AsnMarineCreateEndCableReq cReq = (AsnMarineCreateEndCableReq)req;
        AsnMarineCreateEndCableRsp cRsp = (AsnMarineCreateEndCableRsp)rsp;
        TEMarineEndCablePO endCablePO = this.convertAsnCableToPO(cReq);
        this.fiberID = endCablePO.EndCableID;
        TEDaoOperationResult dbResult = null;
        int tmpRtn = 0;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineEndCablePO.class);
            List dataList = dbResult.getData();
            this.updateCableID(dataList);
            normalLogger.info("The Ending Cable ID is --> " + this.fiberID);
            endCablePO.EndCableID = this.fiberID;
            tmpRtn = this.checkByCableID(dataList, this.fiberID);
            if (0 != tmpRtn) {
                cRsp.result.isSuccess = false;
                cRsp.result.setRetCode(1090615086);
                return 2;
            }
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            return 2;
        }
        try {
            dbResult = TECommonDaoService.create((Object)endCablePO);
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            return 2;
        }
        if (null == dbResult) {
            normalLogger.error("The dbResult is null!");
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            return 2;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            cRsp.result.isSuccess = true;
            cRsp.result.setRetCode(retCode);
            AsnMarineEndCableList endCableList = new AsnMarineEndCableList();
            endCableList.add((Object)cReq.marineEndCable);
            cReq.marineEndCable.fiberID = BigInteger.valueOf(this.fiberID);
            TEMarineStnViewNoticeMgr.sendEndCableCreateNoticeToClient(endCableList);
            String ctbName = 0L == endCablePO.SrcNEID ? endCablePO.SrcNEName : endCablePO.DstNEName;
            int portID = 0L == endCablePO.SrcNEID ? endCablePO.SrcPortID : endCablePO.DstPortID;
            TEMarineCTBPortUpdateHandler.updateMarineCTBPort(endCablePO.StationID, ctbName, portID, true);
        } else {
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(retCode);
        }
        return 0;
    }

    private int checkByCableID(List<Object> dataList, int endCableID) {
        if (null == dataList || 0 == dataList.size()) {
            return 0;
        }
        TEMarineEndCablePO tmpPO = null;
        for (Object obj : dataList) {
            tmpPO = (TEMarineEndCablePO)obj;
            if (tmpPO.EndCableID != endCableID) continue;
            return 1090615086;
        }
        return 0;
    }

    private void updateCableID(List<Object> dataList) {
        if (0 == dataList.size()) {
            return;
        }
        if (0 > this.fiberID) {
            this.fiberID = 0;
        }
        this.getFiberID(dataList);
    }

    private void getFiberID(List<Object> dataList) {
        TEMarineEndCablePO tmpPO = null;
        boolean haveSame = false;
        int len = dataList.size();
        for (int index = 0; index < len; ++index) {
            tmpPO = (TEMarineEndCablePO)dataList.get(index);
            if (this.fiberID != tmpPO.EndCableID) continue;
            haveSame = true;
            ++this.fiberID;
        }
        if (haveSame) {
            this.getFiberID(dataList);
        }
    }

    private TEMarineEndCablePO convertAsnCableToPO(AsnMarineCreateEndCableReq cReq) {
        if (null == cReq) {
            return null;
        }
        TEMarineEndCablePO endCablePO = new TEMarineEndCablePO();
        AsnMarineEndCable marineEndCable = cReq.marineEndCable;
        endCablePO.StationID = marineEndCable.stnID.intValue();
        endCablePO.EndCableID = marineEndCable.fiberID.intValue();
        endCablePO.LinkType = marineEndCable.linkType.intValue();
        endCablePO.EndCableName = new String(marineEndCable.name);
        endCablePO.EndCableMemo = new String(marineEndCable.memo);
        endCablePO.SrcOneID = marineEndCable.srcOneID.intValue();
        endCablePO.SrcNEID = marineEndCable.srcNEID.longValue();
        endCablePO.SrcNEName = new String(marineEndCable.srcNEName);
        endCablePO.SrcBoardID = marineEndCable.srcBoardID.intValue();
        endCablePO.SrcBoardName = new String(marineEndCable.srcBoardName);
        endCablePO.SrcPortID = marineEndCable.srcPortID.intValue();
        endCablePO.SrcPortName = new String(marineEndCable.srcPortName);
        endCablePO.DstOneID = marineEndCable.dstOneID.intValue();
        endCablePO.DstNEID = marineEndCable.dstNEID.longValue();
        endCablePO.DstNEName = new String(marineEndCable.dstNEName);
        endCablePO.DstBoardID = marineEndCable.dstBoardID.intValue();
        endCablePO.DstBoardName = new String(marineEndCable.dstBoardName);
        endCablePO.DstPortID = marineEndCable.dstPortID.intValue();
        endCablePO.DstPortName = new String(marineEndCable.dstPortName);
        endCablePO.Dir = marineEndCable.dir.intValue();
        endCablePO.Length = new String(marineEndCable.length);
        endCablePO.BuildPerson = new String(marineEndCable.buildPerson);
        endCablePO.MaintainPerson = new String(marineEndCable.maintainPerson);
        return endCablePO;
    }
}

