/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.stationviewmgr;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nemgr.f_interface.marinee2e.ASNMarineFiberPortList;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineFiberPort;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCTBPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import java.math.BigInteger;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public class TEMarineCTBPortUpdateHandler {
    private static final int CTB_PORT_COUT = 8;
    private static final int UNUSEABLE = 1;
    private static Logger normalLogger = TELogFactory.getNormalLogger();

    private TEMarineCTBPortUpdateHandler() {
    }

    public static ASNMarineFiberPortList getAsnPortList(String ctbName, int portInfo, ASNMarineFiberPortList asnPortInfoList) {
        ctbName = null == ctbName ? "" : ctbName;
        for (int index = 0; index < 8; ++index) {
            AsnMarineFiberPort asnPortInfo = new AsnMarineFiberPort();
            int portID = index + 1;
            asnPortInfo.oneID = BigInteger.valueOf(0L);
            asnPortInfo.neID = BigInteger.valueOf(0L);
            asnPortInfo.neName = ctbName.getBytes();
            asnPortInfo.bdID = BigInteger.valueOf(0L);
            asnPortInfo.bdName = "".getBytes();
            asnPortInfo.portID = BigInteger.valueOf(portID);
            asnPortInfo.portName = String.valueOf(portID).getBytes();
            asnPortInfo.usable = TEMarineCTBPortUpdateHandler.isPortUsable(portID, portInfo);
            asnPortInfoList.add((Object)asnPortInfo);
        }
        return asnPortInfoList;
    }

    private static boolean isPortUsable(int portID, int portInfo) {
        portInfo >>>= portID - 1;
        return 1 != (portInfo &= 1);
    }

    public static int updateMarineCTBPort(int ctbStnID, String ctbName, int portID, boolean isUsable) {
        if (null == ctbName || 0 == ctbName.length()) {
            return 2;
        }
        TEMarineStationPO stationPO = TEMarineCTBPortUpdateHandler.getStationPO(ctbStnID);
        if (null == stationPO) {
            return 2;
        }
        TEMarineCTBPortUpdateHandler.updateCTBPortInfo(stationPO, ctbName, portID, isUsable);
        return TEMarineCTBPortUpdateHandler.updateStationPO(stationPO);
    }

    private static void updateCTBPortInfo(TEMarineStationPO stationPO, String ctbName, int portID, boolean isUsable) {
        Set CTBList = stationPO.CTBList;
        for (TEMarineCTBPO tmpCTBPO : CTBList) {
            if (!ctbName.equals(tmpCTBPO.Name)) continue;
            TEMarineCTBPortUpdateHandler.updateCTBPortDetail(tmpCTBPO, portID, isUsable);
        }
    }

    private static void updateCTBPortDetail(TEMarineCTBPO ctbPO, int portID, boolean isUsable) {
        int portInfo = ctbPO.getPortInfo();
        portInfo = TEMarineCTBPortUpdateHandler.updatePortUsable(portInfo, portID, isUsable);
        ctbPO.setPortInfo(portInfo);
    }

    private static int updatePortUsable(int portInfo, int portID, boolean isUsable) {
        int indexInt = 1;
        portInfo |= (indexInt <<= portID - 1);
        if (!isUsable) {
            portInfo ^= indexInt;
        }
        return portInfo;
    }

    private static TEMarineStationPO getStationPO(int ctbStnID) {
        TEMarineStationPO stationPO = null;
        TEMarineStationPO tmpPO = null;
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineStationPO.class);
            List data = dbResult.getData();
            for (Object obj : data) {
                tmpPO = (TEMarineStationPO)obj;
                int stnID = tmpPO.StationID;
                if (ctbStnID != stnID) continue;
                stationPO = tmpPO;
                return stationPO;
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEMarineModifyCTBHandler.getStationPO() fail!", (Throwable)e);
        }
        return null;
    }

    private static int updateStationPO(TEMarineStationPO stationPO) {
        if (null == stationPO) {
            return 2;
        }
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.update((Object)stationPO);
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
        }
        if (null == dbResult) {
            normalLogger.error("The dbResult is null!");
            return 2;
        }
        int retCode = dbResult.getResult();
        normalLogger.info("The dbResult is " + retCode);
        return 0;
    }
}

