/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.stationmgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUForTOPO;
import com.huawei.nglct.nemgr.f_interface.marinebumanagement.AsnMarineBUForTOPOList;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineStation;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineStationList;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineUpdateTopoPositionReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineUpdateTopoPositionRsp;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEMarineUpdateMarineTopoPosHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm) {
        normalLogger.info(TEAsn1Util.getAsn1String((Object)req));
        AsnMarineUpdateTopoPositionReq request = (AsnMarineUpdateTopoPositionReq)req;
        AsnMarineUpdateTopoPositionRsp response = (AsnMarineUpdateTopoPositionRsp)rsp;
        List<Object> stnPOList = this.getStationListFromDB();
        if (null == stnPOList) {
            return this.initFailResponse(response);
        }
        this.updateStnPosInfo(request.stationList, stnPOList);
        this.updateStnPosInfoToDB(stnPOList);
        List<Object> buPOList = this.getBUListFromDB();
        if (null == buPOList) {
            return this.initFailResponse(response);
        }
        this.updateBUPosINfo(request.buList, buPOList);
        this.updateBUPosInfoToDB(buPOList);
        response.result.isSuccess = true;
        response.result.setRetCode(0);
        return 0;
    }

    private void updateBUPosInfoToDB(List<Object> buPOList) {
        for (Object obj : buPOList) {
            TEMarineBUPO buPO = (TEMarineBUPO)obj;
            try {
                TECommonDaoService.update((Object)buPO);
            }
            catch (Exception e) {
                normalLogger.error(e.toString());
            }
        }
    }

    private void updateStnPosInfoToDB(List<Object> stnPOList) {
        for (Object obj : stnPOList) {
            TEMarineStationPO stationPO = (TEMarineStationPO)obj;
            try {
                TECommonDaoService.update((Object)stationPO);
            }
            catch (Exception e) {
                normalLogger.error(e.toString());
            }
        }
    }

    private void updateBUPosINfo(AsnMarineBUForTOPOList buList, List<Object> buPOList) {
        if (null == buPOList || 0 == buPOList.size()) {
            return;
        }
        for (Object obj : buPOList) {
            TEMarineBUPO buPO = (TEMarineBUPO)obj;
            this.updateBUPosFromAsn(buList, buPO);
        }
    }

    private void updateBUPosFromAsn(AsnMarineBUForTOPOList buList, TEMarineBUPO buPO) {
        int len = buList.size();
        for (int i = 0; i < len; ++i) {
            AsnMarineBUForTOPO asnBUInfo = (AsnMarineBUForTOPO)buList.get(i);
            String buName = new String(asnBUInfo.buname);
            if (null == buName || 0 == buName.length() || !buName.equals(buPO.getBuName())) continue;
            buPO.setPosX(asnBUInfo.posX.intValue());
            buPO.setPosY(asnBUInfo.posY.intValue());
            break;
        }
    }

    private void updateStnPosInfo(AsnMarineStationList stationList, List<Object> stnPOList) {
        if (null == stationList || 0 == stationList.size()) {
            return;
        }
        for (Object obj : stnPOList) {
            TEMarineStationPO stationPO = (TEMarineStationPO)obj;
            this.updatePosInfoFromAsn(stationList, stationPO);
        }
    }

    private void updatePosInfoFromAsn(AsnMarineStationList stationList, TEMarineStationPO stationPO) {
        int len = stationList.size();
        for (int i = 0; i < len; ++i) {
            AsnMarineStation asnMarineInfo = (AsnMarineStation)stationList.get(i);
            String stnName = new String(asnMarineInfo.name);
            if (null == stnName || 0 == stnName.length() || !stnName.equals(stationPO.Name)) continue;
            stationPO.PosX = asnMarineInfo.posX.intValue();
            stationPO.PosY = asnMarineInfo.posY.intValue();
            break;
        }
    }

    private List<Object> getStationListFromDB() {
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineStationPO.class);
        }
        catch (Exception e) {
            normalLogger.error("", (Throwable)e);
            return null;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            return dbResult.getData();
        }
        return null;
    }

    private List<Object> getBUListFromDB() {
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineBUPO.class);
        }
        catch (Exception e) {
            normalLogger.error("", (Throwable)e);
            return null;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            return dbResult.getData();
        }
        return null;
    }

    private int initFailResponse(AsnMarineUpdateTopoPositionRsp response) {
        response.result.isSuccess = false;
        response.result.setRetCode(1092743443);
        return 2;
    }
}

