/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.stationmgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnSingleReturn;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineSaveSignalstreamNodePosReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineSignalstreamCpNode;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineSignalstreamCtbNode;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineSignalStreamPosNodePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineSignalStreamPosPO;
import java.util.ArrayList;
import java.util.List;

public class TEMarineSaveSignalStreamNodePosHandler {
    private static final int CTB = 0;
    private static final int BD = 1;

    public int handleRequest(AsnMarineSaveSignalstreamNodePosReq req, AsnSingleReturn rsp, TaskMgr tm) {
        TELogFactory.getNormalLogger().info(TEAsn1Util.getAsn1String((Object)req));
        rsp.setRetCode(0);
        rsp.isSuccess = true;
        int stnID = req.stationID.intValue();
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair idcriteria = new TEDaoNameValuePair();
        idcriteria.setName("StnID");
        idcriteria.setValue(String.valueOf(stnID));
        criteria.add(idcriteria);
        try {
            TECommonDaoService.deleteByID(TEMarineSignalStreamPosPO.class, criteria);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("", (Throwable)e);
        }
        List<TEMarineSignalStreamPosNodePO> pos = this.getPo(req);
        this.createStationPos(stnID, pos, rsp);
        TELogFactory.getNormalLogger().info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    private int createStationPos(int stnID, List<TEMarineSignalStreamPosNodePO> pos, AsnSingleReturn rsp) {
        TEMarineSignalStreamPosPO pp = new TEMarineSignalStreamPosPO();
        pp.setStnID(stnID);
        pp.getNodes().addAll(pos);
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.create((Object)pp);
        }
        catch (Exception e) {
            rsp.isSuccess = false;
            rsp.setRetCode(1092743443);
            TELogFactory.getNormalLogger().info("", (Throwable)e);
            return 2;
        }
        if (null == dbResult) {
            rsp.isSuccess = false;
            rsp.setRetCode(1092743443);
            return 2;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            rsp.isSuccess = false;
            rsp.setRetCode(retCode);
        }
        return retCode;
    }

    private List<TEMarineSignalStreamPosNodePO> getPo(AsnMarineSaveSignalstreamNodePosReq req) {
        AsnMarineSignalstreamCpNode n;
        int i;
        int stnID = req.stationID.intValue();
        ArrayList<TEMarineSignalStreamPosNodePO> pos = new ArrayList<TEMarineSignalStreamPosNodePO>();
        int s = req.cpNodeList.size();
        for (i = 0; i < s; ++i) {
            n = (AsnMarineSignalstreamCpNode)req.cpNodeList.get(i);
            pos.add(this.cpAsn2po(stnID, n));
        }
        s = req.ctbNodeList.size();
        for (i = 0; i < s; ++i) {
            n = (AsnMarineSignalstreamCtbNode)req.ctbNodeList.get(i);
            pos.add(this.ctbAsn2po(stnID, (AsnMarineSignalstreamCtbNode)n));
        }
        return pos;
    }

    private TEMarineSignalStreamPosNodePO ctbAsn2po(int stnID, AsnMarineSignalstreamCtbNode n) {
        TEMarineSignalStreamPosNodePO po = new TEMarineSignalStreamPosNodePO();
        po.setStnID(stnID);
        po.setCtbName(new String(n.ctbName));
        po.setX(n.nodeX.intValue());
        po.setY(n.nodeY.intValue());
        po.setType(0);
        return po;
    }

    private TEMarineSignalStreamPosNodePO cpAsn2po(int stnID, AsnMarineSignalstreamCpNode n) {
        TEMarineSignalStreamPosNodePO po = new TEMarineSignalStreamPosNodePO();
        po.setStnID(stnID);
        po.setNeID((long)n.neID.intValue());
        po.setSlotID((long)n.slotID.intValue());
        po.setX(n.nodeX.intValue());
        po.setY(n.nodeY.intValue());
        po.setType(1);
        return po;
    }
}

