/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.stationmgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineCTB;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineCTBList;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarinePSU;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarinePSUList;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineStation;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineStationNE;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineStationNEList;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnModifyMarineStationReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnModifyMarineStationRsp;
import com.huawei.nglct.nemgr.marine.e2e.stationmgr.TEMarineStationNoticeMgr;
import com.huawei.nglct.nemgr.marine.e2e.stnelecable.TEMarineStnEleCblDBOper;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCTBPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarinePowerSupplyUnitPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationNEPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEMarineModifyStationHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private static int TECMDCODE_MODIFY_MARINE_STATION = 2179313;

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm, TETaskInfo info) {
        normalLogger.info(TEAsn1Util.getAsn1String((Object)req));
        AsnModifyMarineStationReq cReq = (AsnModifyMarineStationReq)req;
        AsnModifyMarineStationRsp cRsp = (AsnModifyMarineStationRsp)rsp;
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("stationmgr").append(File.separator).append("stationmgr_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)0, (StringBuffer)filePath);
        ArrayList<TEMarineLogInfo> marineLogInfoList = new ArrayList<TEMarineLogInfo>();
        TEMarineLogInfo marineLogInfo = new TEMarineLogInfo();
        marineLogInfo.setCmdID(TECMDCODE_MODIFY_MARINE_STATION);
        marineLogInfo.setOperateName(res.getString("slm_modify_station1"));
        marineLogInfo.setOperateDesc(this.getDetailStr(cReq, res));
        marineLogInfo.setOperateObject(new String(cReq.station.name));
        String ipAddress = TopoUtility.ipToString((long)info.getMsgHead().senderProcIP);
        int userID = cReq.userID.intValue();
        TEMarineStationPO stationPO = new TEMarineStationPO();
        stationPO.setStationID(cReq.station.stationID.intValue());
        stationPO.setName(new String(cReq.station.name));
        stationPO.setMemo(new String(cReq.station.memo));
        stationPO.setPosX(cReq.station.posX.intValue());
        stationPO.setPosY(cReq.station.posY.intValue());
        AsnMarineStationNEList stationNEList = cReq.station.shelfList;
        AsnMarineStationNE asnNEInfo = null;
        TEMarineStationNEPO neInfo = null;
        int size = stationNEList.size();
        for (int i = 0; i < size; ++i) {
            neInfo = new TEMarineStationNEPO();
            asnNEInfo = (AsnMarineStationNE)stationNEList.get(i);
            neInfo.neID = asnNEInfo.neID.intValue();
            neInfo.PosX = asnNEInfo.posX.intValue();
            neInfo.PosY = asnNEInfo.posY.intValue();
            stationPO.getShelfList().add(neInfo);
        }
        this.modifyNEConnetion(stationPO.getStationID(), stationPO.getShelfList());
        AsnMarineCTBList ctbInfoList = cReq.station.ctbList;
        AsnMarineCTB asnCTBInfo = null;
        TEMarineCTBPO ctbInfo = null;
        int size2 = ctbInfoList.size();
        for (int i = 0; i < size2; ++i) {
            ctbInfo = new TEMarineCTBPO();
            asnCTBInfo = (AsnMarineCTB)ctbInfoList.get(i);
            ctbInfo.Name = new String(asnCTBInfo.name);
            ctbInfo.Memo = new String(asnCTBInfo.memo);
            ctbInfo.StationID = asnCTBInfo.stnID.intValue();
            ctbInfo.PosX = asnCTBInfo.posX.intValue();
            ctbInfo.PosY = asnCTBInfo.posY.intValue();
            stationPO.getCTBList().add(ctbInfo);
        }
        AsnMarinePSUList psuInfoList = cReq.station.psuList;
        AsnMarinePSU asnPSUInfo = null;
        TEMarinePowerSupplyUnitPO psuInfo = null;
        int size3 = psuInfoList.size();
        for (int i = 0; i < size3; ++i) {
            psuInfo = new TEMarinePowerSupplyUnitPO();
            asnPSUInfo = (AsnMarinePSU)psuInfoList.get(i);
            psuInfo.Name = new String(asnPSUInfo.name);
            psuInfo.Voltage = asnPSUInfo.voltage.intValue();
            psuInfo.Current = asnPSUInfo.current.intValue();
            psuInfo.Memo = new String(asnPSUInfo.memo);
            psuInfo.StationID = asnPSUInfo.stnID.intValue();
            psuInfo.PosX = asnPSUInfo.posX.intValue();
            psuInfo.PosY = asnPSUInfo.posY.intValue();
            stationPO.getPSUList().add(psuInfo);
        }
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.update((Object)stationPO);
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        if (null == dbResult) {
            normalLogger.error("The dbResult is null!");
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            TEMarineStationNoticeMgr.sendModifyStationNtfToC(cReq.station);
            cRsp.result.isSuccess = true;
            cRsp.result.setRetCode(retCode);
            marineLogInfo.setErrCode(0);
            marineLogInfo.setResult(0);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
        } else {
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(retCode);
            marineLogInfo.setErrCode(retCode);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
        }
        normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    public String getDetailStr(AsnModifyMarineStationReq req, TEResourceUtil res) {
        StringBuffer bf = new StringBuffer("");
        AsnMarineStation station = req.station;
        bf.append(res.getString("station_name_str")).append(':');
        bf.append(new String(station.name)).append(',');
        bf.append(res.getString("station_memo_str")).append(':');
        bf.append(new String(station.memo)).append(';');
        AsnMarineStationNEList neList = station.shelfList;
        AsnMarineCTBList ctbList = station.ctbList;
        AsnMarineStationNE stationNe = null;
        int len = neList.size();
        for (int i = 0; i < len; ++i) {
            stationNe = (AsnMarineStationNE)neList.get(i);
            TENE ne = TENEListMgr.getInstance().getNE(stationNe.neID.intValue());
            if (null == ne) continue;
            bf.append(res.getString("ne_name_str")).append(':');
            bf.append(ne.getNEName()).append(';');
        }
        AsnMarineCTB ctb = null;
        int len2 = ctbList.size();
        for (int i = 0; i < len2; ++i) {
            ctb = (AsnMarineCTB)ctbList.get(i);
            bf.append(res.getString("ctb_name_str")).append(':');
            bf.append(new String(ctb.name)).append(';');
        }
        return bf.toString();
    }

    private void modifyNEConnetion(int stationID, Set<TEMarineStationNEPO> shelfSet) {
        Set<TEMarineStationNEPO> oldShelfSet = this.getOldShelfSet(stationID);
        Set<Integer> delPFESet = this.getDelPFESet(oldShelfSet, shelfSet);
        if (null != delPFESet && !delPFESet.isEmpty()) {
            TEMarineStnEleCblDBOper.getInstance().delECableByPFENEIDSet(delPFESet, true, stationID);
        }
    }

    private Set<TEMarineStationNEPO> getOldShelfSet(int stnID) {
        TEDaoOperationResult dbResult = null;
        try {
            ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
            TEDaoNameValuePair nvp = new TEDaoNameValuePair("StationID", String.valueOf(stnID));
            criteria.add(nvp);
            dbResult = TECommonDaoService.findByID(TEMarineStationPO.class, criteria);
        }
        catch (Exception e) {
            normalLogger.error("get old station info fail!", (Throwable)e);
        }
        if (null != dbResult && 0 == dbResult.getResult() && !dbResult.getData().isEmpty()) {
            TEMarineStationPO oldStation = (TEMarineStationPO)dbResult.getData().get(0);
            return oldStation.ShelfList;
        }
        return null;
    }

    private Set<Integer> getDelPFESet(Set<TEMarineStationNEPO> oldStnNESet, Set<TEMarineStationNEPO> newStnNESet) {
        if (null == oldStnNESet || oldStnNESet.isEmpty()) {
            return null;
        }
        HashSet<Integer> delPFEIDSet = new HashSet<Integer>();
        for (TEMarineStationNEPO stnNE : oldStnNESet) {
            if (null != newStnNESet && newStnNESet.contains(stnNE)) continue;
            int stnNEID = (int)stnNE.getNeID();
            TENE ne = TENEListMgr.getInstance().getNE(stnNEID);
            if (null == ne || 72 != ne.getNEType()) continue;
            delPFEIDSet.add(stnNEID);
        }
        return delPFEIDSet;
    }
}

