/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.stationmgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnGetMarineStationReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnGetMarineStationRsp;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineCTB;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarinePSU;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineStation;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineStationList;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineStationNE;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCTBPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarinePowerSupplyUnitPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationNEPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;

public class TEMarineGetStationHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();

    public int handleRequest(AsnGetMarineStationReq req, AsnGetMarineStationRsp rsp, TaskMgr tm) {
        normalLogger.info(TEAsn1Util.getAsn1String((Object)req));
        AsnGetMarineStationRsp cRsp = rsp;
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineStationPO.class);
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            return 2;
        }
        if (null == dbResult) {
            normalLogger.error("The dbResult is null!");
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            return 2;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            AsnMarineStationList asnStationList = cRsp.stationList;
            AsnMarineStation asnStation = null;
            TEMarineStationPO stationPO = null;
            List data = dbResult.getData();
            for (Object obj : data) {
                stationPO = (TEMarineStationPO)obj;
                asnStation = TEMarineGetStationHandler.poStation2AsnStation(stationPO);
                asnStationList.add((Object)asnStation);
            }
            cRsp.result.isSuccess = true;
            cRsp.result.setRetCode(retCode);
        } else {
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(retCode);
        }
        normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    public static AsnMarineStation poStation2AsnStation(TEMarineStationPO poStation) {
        AsnMarineStation asnStation = new AsnMarineStation();
        asnStation.stationID = BigInteger.valueOf(poStation.StationID);
        asnStation.name = poStation.Name.getBytes();
        asnStation.memo = poStation.Memo.getBytes();
        asnStation.posX = BigInteger.valueOf(poStation.PosX);
        asnStation.posY = BigInteger.valueOf(poStation.PosY);
        HashSet shelfListSet = (HashSet)poStation.ShelfList;
        Object[] shelfArray = shelfListSet.toArray();
        TEMarineStationNEPO shelf = null;
        AsnMarineStationNE stationNE = null;
        int size = shelfArray.length;
        for (int i = 0; i < size; ++i) {
            shelf = (TEMarineStationNEPO)shelfArray[i];
            stationNE = new AsnMarineStationNE();
            stationNE.neID = BigInteger.valueOf(shelf.neID);
            stationNE.posX = BigInteger.valueOf(shelf.PosX);
            stationNE.posY = BigInteger.valueOf(shelf.PosY);
            asnStation.shelfList.add((Object)stationNE);
        }
        HashSet ctbListSet = (HashSet)poStation.CTBList;
        Object[] ctbArray = ctbListSet.toArray();
        TEMarineCTBPO ctbInfo = null;
        AsnMarineCTB ctbAsnData = null;
        int size2 = ctbArray.length;
        for (int i = 0; i < size2; ++i) {
            ctbAsnData = new AsnMarineCTB();
            ctbInfo = (TEMarineCTBPO)ctbArray[i];
            ctbAsnData.name = ctbInfo.Name.getBytes();
            ctbAsnData.memo = ctbInfo.Memo.getBytes();
            ctbAsnData.stnID = BigInteger.valueOf(ctbInfo.StationID);
            ctbAsnData.posX = BigInteger.valueOf(ctbInfo.PosX);
            ctbAsnData.posY = BigInteger.valueOf(ctbInfo.PosY);
            asnStation.ctbList.add((Object)ctbAsnData);
        }
        HashSet psuListSet = (HashSet)poStation.PSUList;
        Object[] psuArray = psuListSet.toArray();
        TEMarinePowerSupplyUnitPO psuInfo = null;
        AsnMarinePSU psuAsnData = null;
        int size3 = psuArray.length;
        for (int i = 0; i < size3; ++i) {
            psuAsnData = new AsnMarinePSU();
            psuInfo = (TEMarinePowerSupplyUnitPO)psuArray[i];
            psuAsnData.name = psuInfo.Name.getBytes();
            psuAsnData.voltage = BigInteger.valueOf(psuInfo.Voltage);
            psuAsnData.current = BigInteger.valueOf(psuInfo.Current);
            psuAsnData.memo = psuInfo.Memo.getBytes();
            psuAsnData.stnID = BigInteger.valueOf(psuInfo.StationID);
            psuAsnData.posX = BigInteger.valueOf(psuInfo.PosX);
            psuAsnData.posY = BigInteger.valueOf(psuInfo.PosY);
            asnStation.psuList.add((Object)psuAsnData);
        }
        return asnStation;
    }
}

