/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.stationmgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnDelMarineStationReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnDelMarineStationRsp;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineStation;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineStationList;
import com.huawei.nglct.nemgr.marine.e2e.stationmgr.TEMarineStationNoticeMgr;
import com.huawei.nglct.nemgr.marine.e2e.stnelecable.TEMarineStnEleCblDBOper;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCTBPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineEndCablePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarinePowerSupplyUnitPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineSignalStreamPosPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStnEleCablePO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEMarineDelStationHandler {
    private static final String STATION_ID = "StationID";
    private static int TECMDCODE_DEL_MARINE_STATION = 2179314;
    private List<TEMarineStationPO> stationList = new ArrayList<TEMarineStationPO>();
    private static Logger normalLogger = TELogFactory.getNormalLogger();

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm, TETaskInfo info) {
        normalLogger.info(TEAsn1Util.getAsn1String((Object)req));
        AsnDelMarineStationReq cReq = (AsnDelMarineStationReq)req;
        AsnDelMarineStationRsp cRsp = (AsnDelMarineStationRsp)rsp;
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("stationmgr").append(File.separator).append("stationmgr_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)0, (StringBuffer)filePath);
        ArrayList<TEMarineLogInfo> marineLogInfoList = new ArrayList<TEMarineLogInfo>();
        TEMarineLogInfo marineLogInfo = new TEMarineLogInfo();
        marineLogInfo.setCmdID(TECMDCODE_DEL_MARINE_STATION);
        marineLogInfo.setOperateName(res.getString("slm_delete_station1"));
        marineLogInfo.setOperateDesc(this.getDetailStr(cReq, res));
        marineLogInfo.setOperateObject(res.getString("slm_delete_station1"));
        String ipAddress = TopoUtility.ipToString((long)info.getMsgHead().senderProcIP);
        int userID = cReq.userID.intValue();
        AsnMarineStationList asnStationList = new AsnMarineStationList();
        try {
            TEDaoOperationResult dbResult = TECommonDaoService.findAll(TEMarineStationPO.class);
            if (null != dbResult) {
                int retCode = dbResult.getResult();
                if (0 != retCode) {
                    marineLogInfo.setErrCode(retCode);
                    marineLogInfo.setResult(2);
                    marineLogInfoList.add(marineLogInfo);
                    TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
                    return 2;
                }
                for (Object obj : dbResult.getData()) {
                    TEMarineStationPO sPO = (TEMarineStationPO)obj;
                    if (!cReq.stationIDList.contains(sPO.getStationID())) continue;
                    this.stationList.add(sPO);
                }
                marineLogInfo.setOperateDesc(this.getDetailStr(cReq, res));
                marineLogInfo.setOperateObject(this.getObjectStr(cReq, res));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("", (Throwable)e);
        }
        TEMarineStationPO stationPO = new TEMarineStationPO();
        int stationID = -1;
        int len = cReq.stationIDList.size();
        for (int i = 0; i < len; ++i) {
            stationID = cReq.stationIDList.get(i);
            stationPO.setStationID(stationID);
            TEDaoOperationResult dbResult = null;
            try {
                dbResult = TECommonDaoService.delete((Object)stationPO);
            }
            catch (Exception e) {
                normalLogger.error("", (Throwable)e);
                cRsp.result.isSuccess = false;
                cRsp.result.setRetCode(1092743443);
                marineLogInfo.setErrCode(1092743443);
                marineLogInfo.setResult(2);
                marineLogInfoList.add(marineLogInfo);
                TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
                TEMarineStationNoticeMgr.sendDelStationNtfToC(asnStationList);
                return 2;
            }
            if (null == dbResult) {
                normalLogger.error("The dbResult is null!");
                cRsp.result.isSuccess = false;
                cRsp.result.setRetCode(1092743443);
                marineLogInfo.setErrCode(1092743443);
                marineLogInfo.setResult(2);
                marineLogInfoList.add(marineLogInfo);
                TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
                TEMarineStationNoticeMgr.sendDelStationNtfToC(asnStationList);
                return 2;
            }
            int retCode = dbResult.getResult();
            if (0 != retCode) {
                cRsp.result.isSuccess = false;
                cRsp.result.setRetCode(retCode);
                marineLogInfo.setErrCode(retCode);
                marineLogInfo.setResult(2);
                marineLogInfoList.add(marineLogInfo);
                TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
                TEMarineStationNoticeMgr.sendDelStationNtfToC(asnStationList);
                return 2;
            }
            AsnMarineStation asnStation = new AsnMarineStation();
            asnStation.stationID = BigInteger.valueOf(stationID);
            asnStation.name = "".getBytes();
            asnStation.memo = "".getBytes();
            asnStation.posX = BigInteger.valueOf(-1L);
            asnStation.posY = BigInteger.valueOf(-1L);
            asnStationList.add((Object)asnStation);
            this.deleteEndCableInStation(stationID);
            this.deleteStnECableInStation(stationID);
            this.deleteStationSignalStreamNodePos(stationID);
        }
        cRsp.result.isSuccess = true;
        cRsp.result.setRetCode(0);
        TEMarineStationNoticeMgr.sendDelStationNtfToC(asnStationList);
        normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        marineLogInfo.setErrCode(0);
        marineLogInfo.setResult(0);
        marineLogInfoList.add(marineLogInfo);
        TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
        return 0;
    }

    private void deleteStationSignalStreamNodePos(int stationID) {
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair idcriteria = new TEDaoNameValuePair();
        idcriteria.setName("StnID");
        idcriteria.setValue(String.valueOf(stationID));
        criteria.add(idcriteria);
        try {
            TECommonDaoService.deleteByID(TEMarineSignalStreamPosPO.class, criteria);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("", (Throwable)e);
        }
    }

    private void deleteEndCableInStation(int stationID) {
        ArrayList<TEDaoNameValuePair> criterion = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair pair = new TEDaoNameValuePair(STATION_ID, String.valueOf(stationID));
        criterion.add(pair);
        try {
            TECommonDaoService.deleteByID(TEMarineEndCablePO.class, criterion);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("", (Throwable)e);
        }
    }

    private void deleteStnECableInStation(int stationID) {
        ArrayList<TEMarineStnEleCablePO> stnEleCableList = new ArrayList<TEMarineStnEleCablePO>();
        int retCode = TEMarineStnEleCblDBOper.getInstance().getStnEleCblsByStnID(stationID, stnEleCableList);
        if (0 == retCode && !stnEleCableList.isEmpty()) {
            HashSet<Integer> delECableIDSet = new HashSet<Integer>();
            for (TEMarineStnEleCablePO eCable : stnEleCableList) {
                delECableIDSet.add(eCable.getEleCableID());
            }
            TEMarineStnEleCblDBOper.getInstance().delStnECables(delECableIDSet);
        }
    }

    public String getDetailStr(AsnDelMarineStationReq req, TEResourceUtil res) {
        StringBuffer bf = new StringBuffer("");
        TEMarineStationPO station = null;
        int len = this.stationList.size();
        for (int i = 0; i < len; ++i) {
            Iterator iterator;
            station = this.stationList.get(i);
            bf.append(res.getString("station_name_str")).append(':');
            bf.append(station.getName()).append(';');
            if (!station.getCTBList().isEmpty()) {
                bf.append(res.getString("deleted_ctb")).append(':');
                iterator = station.getCTBList().iterator();
                while (iterator.hasNext()) {
                    TEMarineCTBPO ctb = (TEMarineCTBPO)iterator.next();
                    bf.append(ctb.getName());
                    if (!iterator.hasNext()) continue;
                    bf.append(',');
                }
                bf.append(';');
            }
            if (!station.getPSUList().isEmpty()) {
                bf.append(res.getString("deleted_psu")).append(':');
                iterator = station.getPSUList().iterator();
                while (iterator.hasNext()) {
                    TEMarinePowerSupplyUnitPO psu = (TEMarinePowerSupplyUnitPO)iterator.next();
                    bf.append(psu.getName());
                    if (!iterator.hasNext()) continue;
                    bf.append(',');
                }
                bf.append(';');
            }
            bf.append(' ');
        }
        return bf.toString();
    }

    public String getObjectStr(AsnDelMarineStationReq req, TEResourceUtil res) {
        StringBuffer bf = new StringBuffer("");
        TEMarineStationPO station = null;
        if (this.stationList.size() > 0) {
            station = this.stationList.get(0);
            bf.append(station.getName());
        }
        int len = this.stationList.size();
        for (int i = 1; i < len; ++i) {
            station = this.stationList.get(i);
            bf.append(';');
            bf.append(station.getName());
        }
        return bf.toString();
    }
}

