/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.stationmgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnCreateMarineStationReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnCreateMarineStationRsp;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineCTB;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineCTBList;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineStation;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineStationNE;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineStationNEList;
import com.huawei.nglct.nemgr.marine.e2e.stationmgr.TEMarineGenerateNextStnID;
import com.huawei.nglct.nemgr.marine.e2e.stationmgr.TEMarineStationNoticeMgr;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationNEPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import org.slf4j.Logger;

public class TEMarineCreateStationHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private static int TECMDCODE_CREATE_MARINE_STATION = 2179311;

    public int handleRequest(AsnCreateMarineStationReq req, AsnCreateMarineStationRsp rsp, TaskMgr tm, TETaskInfo info) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("stationmgr").append(File.separator).append("stationmgr_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)0, (StringBuffer)filePath);
        ArrayList<TEMarineLogInfo> marineLogInfoList = new ArrayList<TEMarineLogInfo>();
        TEMarineLogInfo marineLogInfo = new TEMarineLogInfo();
        marineLogInfo.setCmdID(TECMDCODE_CREATE_MARINE_STATION);
        marineLogInfo.setOperateName(res.getString("slm_create_station1"));
        marineLogInfo.setOperateDesc(this.getDetailStr(req, res));
        marineLogInfo.setOperateObject(new String(req.station.name));
        String ipAddress = TopoUtility.ipToString((long)info.getMsgHead().senderProcIP);
        int userID = req.userID.intValue();
        normalLogger.info(TEAsn1Util.getAsn1String((Object)req));
        AsnCreateMarineStationReq cReq = req;
        AsnCreateMarineStationRsp cRsp = rsp;
        TEMarineStationPO stationPO = new TEMarineStationPO();
        TEMarineGenerateNextStnID nextStationIDObj = TEMarineGenerateNextStnID.getNextCableID(cReq, cRsp);
        int result = nextStationIDObj.getResult();
        if (0 != result) {
            marineLogInfo.setErrCode(result);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return result;
        }
        int stationID = nextStationIDObj.getStationID();
        String stationName = new String(cReq.station.name);
        String stationMemo = new String(cReq.station.memo);
        int posX = cReq.station.posX.intValue();
        int posY = cReq.station.posY.intValue();
        stationPO.setStationID(stationID);
        stationPO.setName(stationName);
        stationPO.setMemo(stationMemo);
        stationPO.setPosX(posX);
        stationPO.setPosY(posY);
        AsnMarineStationNEList neIDList = cReq.station.shelfList;
        TEMarineStationNEPO neInfo = null;
        AsnMarineStationNE stationNE = null;
        int size = neIDList.size();
        for (int i = 0; i < size; ++i) {
            neInfo = new TEMarineStationNEPO();
            stationNE = (AsnMarineStationNE)neIDList.get(i);
            neInfo.neID = stationNE.neID.longValue();
            neInfo.PosX = stationNE.posX.intValue();
            neInfo.PosY = stationNE.posY.intValue();
            stationPO.getShelfList().add(neInfo);
        }
        TEDaoOperationResult dboResult = null;
        try {
            dboResult = TECommonDaoService.create((Object)stationPO);
        }
        catch (Exception e) {
            normalLogger.error("", (Throwable)e);
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        if (null == dboResult) {
            normalLogger.error("The dbResult is null!");
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        int retCode = dboResult.getResult();
        if (0 == retCode) {
            cRsp.result.isSuccess = true;
            cRsp.result.setRetCode(retCode);
            marineLogInfo.setErrCode(0);
            marineLogInfo.setResult(0);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            cReq.station.stationID = BigInteger.valueOf(stationID);
            TEMarineStationNoticeMgr.sendCreateStationNtfToC(cReq.station);
        } else {
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(retCode);
            marineLogInfo.setErrCode(retCode);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
        }
        normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    public String getDetailStr(AsnCreateMarineStationReq req, TEResourceUtil res) {
        StringBuffer bf = new StringBuffer("");
        AsnMarineStation station = req.station;
        bf.append(res.getString("station_name_str")).append(':');
        bf.append(new String(station.name)).append(',');
        bf.append(res.getString("station_memo_str")).append(':');
        bf.append(new String(station.memo)).append(';');
        AsnMarineStationNEList neList = station.shelfList;
        AsnMarineCTBList ctbList = station.ctbList;
        AsnMarineStationNE stationNe = null;
        int len = neList.size();
        for (int i = 0; i < len; ++i) {
            stationNe = (AsnMarineStationNE)neList.get(i);
            TENE ne = TENEListMgr.getInstance().getNE(stationNe.neID.intValue());
            if (null == ne) continue;
            bf.append(res.getString("ne_name_str")).append(':');
            bf.append(ne.getNEName()).append(';');
        }
        AsnMarineCTB ctb = null;
        int len2 = ctbList.size();
        for (int i = 0; i < len2; ++i) {
            ctb = (AsnMarineCTB)ctbList.get(i);
            bf.append(res.getString("ctb_name_str")).append(':');
            bf.append(new String(ctb.name)).append(';');
        }
        return bf.toString();
    }
}

