/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.script;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptHandler;
import com.huawei.nglct.cbb.script.TEScriptOperationMgr;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineStation;
import com.huawei.nglct.nemgr.marine.e2e.script.TEMarineScriptUtil;
import com.huawei.nglct.nemgr.marine.e2e.script.TEMarineStationNEWithName;
import com.huawei.nglct.nemgr.marine.e2e.stationmgr.TEMarineGenerateNextStnID;
import com.huawei.nglct.nemgr.marine.e2e.stationmgr.TEMarineGetStationHandler;
import com.huawei.nglct.nemgr.marine.e2e.stationmgr.TEMarineStationNoticeMgr;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCTBPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarinePowerSupplyUnitPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationNEPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public class TEMarineStationScriptHandler
implements TEScriptHandler {
    private static final String STATION_NAME = "stationName";
    private static final String STATION_MEMO = "stationMemo";
    private static final String STATION_POSX = "stationPosX";
    private static final String STATION_POSY = "stationPosY";
    private static final String STATION_SHELFLIST_SIZE = "stationShelfListSize";
    private static final String STATION_CTBLIST_SIZE = "stationCTBListSize";
    private static final String STATION_PSULIST_SIZE = "stationPSUListSize";
    private static final String SHELF_ID_PREFEX = "logicNEID";
    private static final String CTBID_PREFEX = "ctbID";
    private static final String PSUID_PREFEX = "psuID";
    private static final Logger normalLogger = TELogFactory.getNormalLogger();

    public int doExport(int neID, int item) {
        if (!TENEListMgr.getInstance().isAddedNE(neID)) {
            return 0;
        }
        TENE ne = TEConfigurationDataMgr.getInstance().getNE(neID);
        int nePhyType = ne.getNEType();
        if (!TEMarineScriptUtil.isMarineDevice(nePhyType)) {
            return 1090613252;
        }
        normalLogger.info("Marine export station to script begin.");
        int result = 0;
        ArrayList<TEMarineStationPO> stnPOList = new ArrayList<TEMarineStationPO>();
        result = this.getExportDataFromDataBase(stnPOList);
        if (0 == result) {
            result = this.writeExportDataToScript(stnPOList, neID, item);
        }
        normalLogger.info("Marine export station to script. result->" + result);
        return result;
    }

    public int doImport(int neID, int item, List<TEScriptCmd> contents) {
        int result = 0;
        if (null == contents || contents.isEmpty()) {
            return result;
        }
        TEMarineStationPO stnPO = null;
        HashSet<TEMarineStationNEWithName> shelfList = null;
        for (TEScriptCmd cmd : contents) {
            stnPO = this.parsePOFromCmd(cmd, shelfList = new HashSet<TEMarineStationNEWithName>());
            if (null != stnPO) {
                result = this.doCreateOperation(stnPO, shelfList);
                continue;
            }
            result = 1092743443;
        }
        return result;
    }

    private int getExportDataFromDataBase(List<TEMarineStationPO> stnPOList) {
        return TEMarineScriptUtil.getPOFromDateBase(stnPOList);
    }

    private int writeExportDataToScript(List<TEMarineStationPO> stnPOList, int neID, int item) {
        int result = 0;
        TEScriptCmd cmd = null;
        for (TEMarineStationPO stnPO : stnPOList) {
            cmd = new TEScriptCmd();
            cmd.setCmdCode(item);
            this.constractScriptCmd(cmd, stnPO);
            result = TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd);
            if (0 == result) continue;
            break;
        }
        return result;
    }

    private void constractScriptCmd(TEScriptCmd cmd, TEMarineStationPO stnPO) {
        String stnName = stnPO.getName();
        String stnMemo = stnPO.getMemo();
        int posX = stnPO.getPosX();
        int posY = stnPO.getPosY();
        Set shelfList = stnPO.getShelfList();
        Set ctbList = stnPO.getCTBList();
        Set psuList = stnPO.getPSUList();
        cmd.addPara(STATION_NAME, stnName, true, true);
        cmd.addPara(STATION_MEMO, stnMemo, true, true);
        cmd.addPara(STATION_POSX, posX, false, true);
        cmd.addPara(STATION_POSY, posY, false, true);
        cmd.addPara(STATION_SHELFLIST_SIZE, shelfList.size(), false, true);
        cmd.addPara(STATION_CTBLIST_SIZE, ctbList.size(), false, true);
        cmd.addPara(STATION_PSULIST_SIZE, psuList.size(), false, true);
        StringBuffer sb = null;
        String shelfIDStr = null;
        TENE tene = null;
        int phyDevType = -1;
        int phyNEID = -1;
        String neName = null;
        int nePosX = -1;
        int nePosY = -1;
        int index = 0;
        for (TEMarineStationNEPO nePO : shelfList) {
            shelfIDStr = SHELF_ID_PREFEX + index;
            long logicNEID = nePO.getNeID();
            tene = TEConfigurationDataMgr.getInstance().getNE((int)logicNEID);
            phyDevType = tene.getNEType();
            phyNEID = TEConfigurationDataMgr.getInstance().getNEID((int)logicNEID);
            neName = tene.getNEName();
            nePosX = nePO.getPosX();
            nePosY = nePO.getPosY();
            sb = new StringBuffer();
            sb.append("\"");
            sb.append(phyDevType);
            sb.append("&");
            sb.append(phyNEID);
            sb.append("&");
            sb.append(neName);
            sb.append("&");
            sb.append(nePosX);
            sb.append("&");
            sb.append(nePosY);
            sb.append("\"");
            cmd.addPara(shelfIDStr, sb.toString(), false, true);
            ++index;
        }
        String ctbIDStr = null;
        String ctbName = null;
        String ctbMemo = null;
        int ctbPosX = -1;
        int ctbPosY = -1;
        int ctbStnID = -1;
        int ctbPortInfo = -1;
        index = 0;
        for (TEMarineCTBPO ctbPO : ctbList) {
            ctbIDStr = CTBID_PREFEX + index;
            ctbName = ctbPO.getName();
            ctbMemo = ctbPO.getMemo();
            ctbPosX = ctbPO.getPosX();
            ctbPosY = ctbPO.getPosY();
            ctbStnID = ctbPO.getStationID();
            ctbPortInfo = ctbPO.getPortInfo();
            sb = new StringBuffer();
            sb.append("\"");
            sb.append(ctbName);
            sb.append("&");
            sb.append(ctbMemo);
            sb.append("&");
            sb.append(ctbPosX);
            sb.append("&");
            sb.append(ctbPosY);
            sb.append("&");
            sb.append(ctbStnID);
            sb.append("&");
            sb.append(ctbPortInfo);
            sb.append("\"");
            cmd.addPara(ctbIDStr, sb.toString(), false, true);
            ++index;
        }
        String psuIDStr = null;
        String psuName = null;
        int psuVoltage = -1;
        int psuCurrent = -1;
        String psuMemo = null;
        int psuPosX = -1;
        int psuPosY = -1;
        int psuStnID = -1;
        int psuPortInfo = -1;
        index = 0;
        for (TEMarinePowerSupplyUnitPO psuPO : psuList) {
            psuIDStr = PSUID_PREFEX + index;
            psuName = psuPO.getName();
            psuVoltage = psuPO.getVoltage();
            psuCurrent = psuPO.getCurrent();
            psuMemo = psuPO.getMemo();
            psuPosX = psuPO.getPosX();
            psuPosY = psuPO.getPosY();
            psuStnID = psuPO.getStationID();
            psuPortInfo = psuPO.getPortInfo();
            sb = new StringBuffer();
            sb.append("\"");
            sb.append(psuName);
            sb.append("&");
            sb.append(psuVoltage);
            sb.append("&");
            sb.append(psuCurrent);
            sb.append("&");
            sb.append(psuMemo);
            sb.append("&");
            sb.append(psuPosX);
            sb.append("&");
            sb.append(psuPosY);
            sb.append("&");
            sb.append(psuStnID);
            sb.append("&");
            sb.append(psuPortInfo);
            sb.append("\"");
            cmd.addPara(psuIDStr, sb.toString(), false, true);
            ++index;
        }
    }

    private TEMarineStationPO parsePOFromCmd(TEScriptCmd cmd, Set<TEMarineStationNEWithName> shelfList) {
        int i;
        TEMarineStationPO stnPO = null;
        ArrayList paraValueList = new ArrayList();
        TEMarineGenerateNextStnID nextStnID = TEMarineGenerateNextStnID.getNextCableID();
        if (0 != nextStnID.getResult()) {
            return null;
        }
        int stationID = nextStnID.getStationID();
        String stnName = null;
        String stnMemo = null;
        int stnPosX = -1;
        int stnPosY = -1;
        int shelfListSize = 0;
        int ctbListSize = 0;
        HashSet<TEMarineCTBPO> ctbList = null;
        int psuListSize = 0;
        HashSet<TEMarinePowerSupplyUnitPO> psuList = null;
        String shelfIDStr = null;
        String ctbIDStr = null;
        String psuIDStr = null;
        String shelfInfoStr = null;
        String ctbInfoStr = null;
        String psuInfoStr = null;
        TEMarineStationNEWithName stnNEWithName = null;
        TEMarineCTBPO ctbPO = null;
        TEMarinePowerSupplyUnitPO psuPO = null;
        paraValueList.clear();
        cmd.getPara(STATION_NAME, paraValueList, false);
        stnName = (String)paraValueList.get(0);
        paraValueList.clear();
        cmd.getPara(STATION_MEMO, paraValueList, false);
        stnMemo = (String)paraValueList.get(0);
        paraValueList.clear();
        cmd.getPara(STATION_POSX, paraValueList, false);
        stnPosX = Integer.parseInt((String)paraValueList.get(0));
        paraValueList.clear();
        cmd.getPara(STATION_POSY, paraValueList, false);
        stnPosY = Integer.parseInt((String)paraValueList.get(0));
        paraValueList.clear();
        cmd.getPara(STATION_SHELFLIST_SIZE, paraValueList, false);
        shelfListSize = Integer.parseInt((String)paraValueList.get(0));
        paraValueList.clear();
        cmd.getPara(STATION_CTBLIST_SIZE, paraValueList, false);
        ctbListSize = Integer.parseInt((String)paraValueList.get(0));
        paraValueList.clear();
        cmd.getPara(STATION_PSULIST_SIZE, paraValueList, false);
        psuListSize = Integer.parseInt((String)paraValueList.get(0));
        for (i = 0; i < shelfListSize; ++i) {
            shelfIDStr = SHELF_ID_PREFEX + i;
            paraValueList.clear();
            cmd.getPara(shelfIDStr, paraValueList, false);
            shelfInfoStr = (String)paraValueList.get(0);
            stnNEWithName = this.createStationNEPOFromArray(shelfInfoStr);
            shelfList.add(stnNEWithName);
        }
        ctbList = new HashSet<TEMarineCTBPO>();
        for (i = 0; i < ctbListSize; ++i) {
            ctbIDStr = CTBID_PREFEX + i;
            paraValueList.clear();
            cmd.getPara(ctbIDStr, paraValueList, false);
            ctbInfoStr = (String)paraValueList.get(0);
            ctbPO = this.createCTBPOFromArray(ctbInfoStr);
            ctbList.add(ctbPO);
        }
        psuList = new HashSet<TEMarinePowerSupplyUnitPO>();
        for (i = 0; i < psuListSize; ++i) {
            psuIDStr = PSUID_PREFEX + i;
            paraValueList.clear();
            cmd.getPara(psuIDStr, paraValueList, false);
            psuInfoStr = (String)paraValueList.get(0);
            psuPO = this.createPSUPOFromArray(psuInfoStr);
            psuList.add(psuPO);
        }
        stnPO = new TEMarineStationPO();
        stnPO.setStationID(stationID);
        stnPO.setName(stnName);
        stnPO.setMemo(stnMemo);
        stnPO.setPosX(stnPosX);
        stnPO.setPosY(stnPosY);
        stnPO.setCTBList(ctbList);
        stnPO.setPSUList(psuList);
        return stnPO;
    }

    private TEMarineStationNEWithName createStationNEPOFromArray(String shelfInfoStr) {
        TEMarineStationNEWithName neWithName = new TEMarineStationNEWithName();
        TEMarineStationNEPO stnNEPO = new TEMarineStationNEPO();
        String[] shelfInfoArr = shelfInfoStr.split("&");
        int nePhyType = Integer.parseInt(shelfInfoArr[0]);
        int phyNEID = Integer.parseInt(shelfInfoArr[1]);
        String neName = shelfInfoArr[2];
        stnNEPO.setNeID(TEMarineScriptUtil.getLogicNEID(nePhyType, phyNEID, neName));
        stnNEPO.setPosX(Integer.parseInt(shelfInfoArr[3]));
        stnNEPO.setPosY(Integer.parseInt(shelfInfoArr[4]));
        neWithName.setNepo(stnNEPO);
        neWithName.setNePhyType(nePhyType);
        neWithName.setNePhyID(phyNEID);
        neWithName.setNeName(neName);
        return neWithName;
    }

    private TEMarineCTBPO createCTBPOFromArray(String ctbInfoStr) {
        TEMarineCTBPO ctbPO = new TEMarineCTBPO();
        String[] ctbInfoArr = ctbInfoStr.split("&");
        ctbPO.setName(ctbInfoArr[0]);
        ctbPO.setMemo(ctbInfoArr[1]);
        ctbPO.setPosX(Integer.parseInt(ctbInfoArr[2]));
        ctbPO.setPosY(Integer.parseInt(ctbInfoArr[3]));
        ctbPO.setStationID(Integer.parseInt(ctbInfoArr[4]));
        ctbPO.setPortInfo(Integer.parseInt(ctbInfoArr[5]));
        return ctbPO;
    }

    private TEMarinePowerSupplyUnitPO createPSUPOFromArray(String psuInfoStr) {
        TEMarinePowerSupplyUnitPO psuPO = new TEMarinePowerSupplyUnitPO();
        String[] psuInfoArr = psuInfoStr.split("&");
        psuPO.setName(psuInfoArr[0]);
        psuPO.setVoltage(Integer.parseInt(psuInfoArr[1]));
        psuPO.setCurrent(Integer.parseInt(psuInfoArr[2]));
        psuPO.setMemo(psuInfoArr[3]);
        psuPO.setPosX(Integer.parseInt(psuInfoArr[4]));
        psuPO.setPosY(Integer.parseInt(psuInfoArr[5]));
        psuPO.setStationID(Integer.parseInt(psuInfoArr[6]));
        psuPO.setPortInfo(Integer.parseInt(psuInfoArr[7]));
        return psuPO;
    }

    private int doCreateOperation(TEMarineStationPO stationPO, Set<TEMarineStationNEWithName> shelfList) {
        int returnCode = 0;
        if (TEMarineScriptUtil.isPOExistInDB(stationPO)) {
            returnCode = 1090615094;
        } else {
            ArrayList<TEMarineCTBPO> removedCtbList = new ArrayList<TEMarineCTBPO>();
            ArrayList<TEMarinePowerSupplyUnitPO> removedPSUList = new ArrayList<TEMarinePowerSupplyUnitPO>();
            ArrayList<TEMarineStationNEPO> removedNEList = new ArrayList<TEMarineStationNEPO>();
            returnCode = this.filterExistCTB(stationPO, removedCtbList);
            returnCode = this.filterExistPSU(stationPO, removedPSUList);
            returnCode = this.filterAbnormalNE(stationPO, shelfList, removedNEList);
            returnCode = this.doSendCreateCmd(stationPO);
        }
        return returnCode;
    }

    private int filterExistCTB(TEMarineStationPO stationPO, List<TEMarineCTBPO> removedCtbList) {
        int returnCode = 0;
        Set ctbPOSet = stationPO.getCTBList();
        Iterator iterator = ctbPOSet.iterator();
        TEMarineCTBPO ctbPO = null;
        while (iterator.hasNext()) {
            ctbPO = (TEMarineCTBPO)iterator.next();
            if (!TEMarineScriptUtil.isCTBExistInDB(ctbPO.getName())) continue;
            if (1090615095 != returnCode) {
                returnCode = 1090615095;
            }
            removedCtbList.add(ctbPO);
            ctbPOSet.remove(ctbPO);
        }
        return returnCode;
    }

    private int filterExistPSU(TEMarineStationPO stationPO, List<TEMarinePowerSupplyUnitPO> removedPSUList) {
        int returnCode = 0;
        Set psuPOSet = stationPO.getPSUList();
        Iterator iterator = psuPOSet.iterator();
        TEMarinePowerSupplyUnitPO psuPO = null;
        while (iterator.hasNext()) {
            psuPO = (TEMarinePowerSupplyUnitPO)iterator.next();
            if (!TEMarineScriptUtil.isPSUExistInDB(psuPO.getName())) continue;
            if (1090615224 != returnCode) {
                returnCode = 1090615224;
            }
            removedPSUList.add(psuPO);
            psuPOSet.remove(psuPO);
        }
        return returnCode;
    }

    private int filterAbnormalNE(TEMarineStationPO stationPO, Set<TEMarineStationNEWithName> shelfList, List<TEMarineStationNEPO> removedNEList) {
        int returnCode = 0;
        TEMarineStationNEWithName stnNEWithName = null;
        Iterator<TEMarineStationNEWithName> iterator = shelfList.iterator();
        TENE ne = null;
        String neName = null;
        while (iterator.hasNext()) {
            stnNEWithName = iterator.next();
            long logicNEID = stnNEWithName.getNepo().getNeID();
            if (-1L == logicNEID) {
                returnCode = 1090615100;
                continue;
            }
            ne = TEConfigurationDataMgr.getInstance().getNE((int)logicNEID);
            if (null == ne) {
                returnCode = 1090615100;
            } else {
                neName = ne.getNEName();
                if (!neName.equals(stnNEWithName.getNeName())) {
                    returnCode = 1090615097;
                }
            }
            if (!TEMarineScriptUtil.isMarineDevice(stnNEWithName.getNePhyType())) {
                returnCode = 1090615097;
            }
            if (0 == returnCode) continue;
            shelfList.remove(stnNEWithName);
        }
        for (TEMarineStationNEWithName neWithName : shelfList) {
            stationPO.getShelfList().add(neWithName.getNepo());
        }
        return returnCode;
    }

    private int doSendCreateCmd(TEMarineStationPO stationPO) {
        int returnCode = 0;
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.create((Object)stationPO);
        }
        catch (Exception e) {
            normalLogger.error("", (Throwable)e);
            returnCode = 1092743443;
            return returnCode;
        }
        if (null == dbResult) {
            normalLogger.error("The dbResult is null!");
            returnCode = 1092743443;
            return returnCode;
        }
        returnCode = dbResult.getResult();
        if (0 == returnCode) {
            AsnMarineStation asnStn = TEMarineGetStationHandler.poStation2AsnStation(stationPO);
            TEMarineStationNoticeMgr.sendCreateStationNtfToC(asnStn);
        }
        return returnCode;
    }
}

