/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.script;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataBaseOperService;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCTBPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarinePowerSupplyUnitPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public final class TEMarineScriptUtil {
    public static final int TE_ERR_MARINE_SAME_NAME_CABLE_EXIST = 1090615093;
    public static final int TE_ERR_MARINE_SAME_NAME_STATION_EXIST = 1090615094;
    public static final int TE_ERR_MARINE_SAME_NAME_CTB_EXIST = 1090615095;
    public static final int TE_ERR_MARINE_SAME_NAME_RPT_EXIST = 1090615096;
    public static final int TE_ERR_MARINE_CABLE_SRC_NOT_EXIST = 1090615098;
    public static final int TE_ERR_MARINE_CABLE_SINK_NOT_EXIST = 1090615099;
    public static final int TE_ERR_MARINE_STATION_NE_NOT_EXIST = 1090615100;
    public static final int TE_ERR_MARINE_STATION_NE_ABNORMAL = 1090615097;
    public static final int NSERR_MARINE_PSU_IS_EXIST = 1090615224;
    public static final int NODE_TYPE_STATION = 0;
    public static final int NODE_TYPE_BU = 1;
    public static final Logger normalLogger = TELogFactory.getNormalLogger();
    private static final int NETYPE_BWS1600ST16 = 96;

    private TEMarineScriptUtil() {
    }

    public static boolean isMarineDevice(int nePhyType) {
        boolean isMarineDevice = false;
        isMarineDevice = 61 == nePhyType || 56 == nePhyType || 72 == nePhyType || 96 == nePhyType;
        return isMarineDevice;
    }

    public static long getLogicNEID(int phyDevType, int phyNEID, String neName) {
        if (TEMarineScriptUtil.isNAMarineDev(phyDevType)) {
            return TETL1NECommMgr.getInstance().getLogicNEID(neName);
        }
        return TENECommMgr.getInstance().getLogicNEID(phyNEID);
    }

    private static boolean isNAMarineDev(int phyDevType) {
        boolean isNADiv = false;
        isNADiv = 72 == phyDevType;
        return isNADiv;
    }

    public static boolean isCTBExistInDB(String ctbName) {
        boolean isExist = false;
        ArrayList<TEMarineStationPO> stnPOList = new ArrayList<TEMarineStationPO>();
        TEMarineScriptUtil.getPOFromDateBase(stnPOList);
        HashSet<TEMarineCTBPO> allCtbPOList = new HashSet<TEMarineCTBPO>();
        for (TEMarineStationPO dbStnPO : stnPOList) {
            allCtbPOList.addAll(dbStnPO.getCTBList());
        }
        isExist = TEMarineScriptUtil.isCTBExit(allCtbPOList, ctbName);
        return isExist;
    }

    public static boolean isPSUExistInDB(String psuName) {
        boolean isExist = false;
        ArrayList<TEMarineStationPO> stnPOList = new ArrayList<TEMarineStationPO>();
        TEMarineScriptUtil.getPOFromDateBase(stnPOList);
        HashSet<TEMarinePowerSupplyUnitPO> allPSUPOList = new HashSet<TEMarinePowerSupplyUnitPO>();
        for (TEMarineStationPO dbStnPO : stnPOList) {
            allPSUPOList.addAll(dbStnPO.getPSUList());
        }
        isExist = TEMarineScriptUtil.isPSUExit(allPSUPOList, psuName);
        return isExist;
    }

    public static boolean isStationExistInDB(String stationName, String ctbName) {
        boolean isExist = false;
        TEMarineStationPO stationPO = new TEMarineStationPO();
        stationPO.setName(stationName);
        isExist = TEMarineScriptUtil.isPOExistInDB(stationPO, ctbName);
        return isExist;
    }

    private static boolean isPOExistInDB(TEMarineStationPO stnPO, String ctbName) {
        boolean isExist = false;
        ArrayList<TEMarineStationPO> stnPOList = new ArrayList<TEMarineStationPO>();
        TEMarineScriptUtil.getPOFromDateBase(stnPOList);
        Set ctbList = null;
        for (TEMarineStationPO dbStnPO : stnPOList) {
            if (!TEMarineScriptUtil.isSameStn(stnPO, dbStnPO)) continue;
            ctbList = dbStnPO.getCTBList();
            isExist = TEMarineScriptUtil.isCTBExit(ctbList, ctbName);
            break;
        }
        return isExist;
    }

    private static boolean isCTBExit(Set<TEMarineCTBPO> ctbList, String ctbName) {
        boolean isExist = false;
        if (null != ctbList && null != ctbName) {
            TEMarineCTBPO ctbPO2 = null;
            for (TEMarineCTBPO ctbPO2 : ctbList) {
                if (!TEMarineScriptUtil.isSameCTB(ctbPO2, ctbName)) continue;
                isExist = true;
                break;
            }
        }
        return isExist;
    }

    private static boolean isPSUExit(Set<TEMarinePowerSupplyUnitPO> psuList, String psuName) {
        boolean isExist = false;
        if (null != psuList && null != psuName) {
            TEMarinePowerSupplyUnitPO psuPO2 = null;
            for (TEMarinePowerSupplyUnitPO psuPO2 : psuList) {
                if (!TEMarineScriptUtil.isSamePSU(psuPO2, psuName)) continue;
                isExist = true;
                break;
            }
        }
        return isExist;
    }

    private static boolean isSameCTB(TEMarineCTBPO ctbPO, String ctbName) {
        boolean isSame = false;
        isSame = ctbPO.getName().equals(ctbName);
        return isSame;
    }

    private static boolean isSamePSU(TEMarinePowerSupplyUnitPO psuPO, String psuName) {
        boolean isSame = false;
        isSame = psuPO.getName().equals(psuName);
        return isSame;
    }

    public static boolean isPOExistInDB(TEMarineStationPO stnPO) {
        boolean isExist = false;
        ArrayList<TEMarineStationPO> stnPOList = new ArrayList<TEMarineStationPO>();
        TEMarineScriptUtil.getPOFromDateBase(stnPOList);
        for (TEMarineStationPO dbPO : stnPOList) {
            if (!TEMarineScriptUtil.isSameStn(stnPO, dbPO)) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    private static boolean isSameStn(TEMarineStationPO stnPO, TEMarineStationPO dbPO) {
        boolean isSame = false;
        isSame = stnPO.getName().equals(dbPO.getName());
        return isSame;
    }

    public static int getPOFromDateBase(List<TEMarineStationPO> stnPOList) {
        int returnCode = 0;
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineStationPO.class);
        }
        catch (Exception e) {
            normalLogger.error("Marine find all data error!", (Throwable)e);
            returnCode = 1092743443;
            return returnCode;
        }
        if (0 == returnCode && null == dbResult) {
            normalLogger.error("The dbResult is null!");
            returnCode = 1092743443;
            return returnCode;
        }
        returnCode = dbResult.getResult();
        if (0 == returnCode) {
            TEMarineStationPO stationPO = null;
            List data = dbResult.getData();
            for (Object obj : data) {
                stationPO = (TEMarineStationPO)obj;
                stnPOList.add(stationPO);
            }
        }
        return returnCode;
    }

    public static boolean isBUExistInDB(String buName) {
        boolean isExist = false;
        TEMarineBUPO buPO = new TEMarineBUPO();
        buPO.setBuName(buName);
        isExist = TEMarineScriptUtil.isPOExistInDB(buPO);
        return isExist;
    }

    public static boolean isPOExistInDB(TEMarineBUPO buPO) {
        boolean isExist = false;
        ArrayList<TEMarineBUPO> buPOList = new ArrayList<TEMarineBUPO>();
        TEBUDataBaseOperService buDataOperService = new TEBUDataBaseOperService();
        buDataOperService.queryAllBUInfo(buPOList);
        isExist = TEMarineScriptUtil.isPOExistInDB(buPOList, buPO);
        return isExist;
    }

    private static boolean isPOExistInDB(List<TEMarineBUPO> buPOList, TEMarineBUPO buPO) {
        boolean isExist = false;
        if (null != buPOList && null != buPO) {
            for (TEMarineBUPO tempBUPO : buPOList) {
                if (!TEMarineScriptUtil.isSameBU(tempBUPO, buPO)) continue;
                isExist = true;
                break;
            }
        }
        return isExist;
    }

    private static boolean isSameBU(TEMarineBUPO tempBUPO, TEMarineBUPO buPO) {
        boolean isSame = false;
        isSame = tempBUPO.getBuName().equals(buPO.getBuName());
        return isSame;
    }
}

