/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.script;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptHandler;
import com.huawei.nglct.cbb.script.TEScriptOperationMgr;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineCable;
import com.huawei.nglct.nemgr.marine.e2e.cablemgr.TEMarineCableMgrTask;
import com.huawei.nglct.nemgr.marine.e2e.cablemgr.TEMarineCableNoticeMgr;
import com.huawei.nglct.nemgr.marine.e2e.script.TEMarineScriptUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TECableBondLinePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCablePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineRepeaterPO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public class TEMarineCableScriptHandler
implements TEScriptHandler {
    private static final String CABLE_ID = "cableID";
    private static final String SRC_TYPE = "srcType";
    private static final String SRC_STATION_ID = "srcStationID";
    private static final String SRC_STATION_NAME = "srcStationName";
    private static final String SRC_NODE_NAME = "srcNodeName";
    private static final String SRCBUPORTNAME = "srcBuPortName";
    private static final String SINK_TYPE = "sinkType";
    private static final String SINK_STATION_ID = "sinkStationID";
    private static final String SINK_STATION_NAME = "sinkStationName";
    private static final String SINK_NODE_NAME = "sinkNodeName";
    private static final String SINKBUPORTNAME = "sinkBuPortName";
    private static final String CABLE_NAME = "cableName";
    private static final String RPT_NUM = "rptNum";
    private static final String FAULT_TYPE = "faultType";
    private static final String CABLELEN = "cableLen";
    private static final String CABLE_MEMO = "cableMemo";
    private static final String CABLERESISTANCE = "cableResistance";
    private static final String CABLE20RESISTANCE = "cable20Resistance";
    private static final String CABLECURTEMP = "cableCurTemperature";
    private static final String RPTLIST_SIZE = "rptListSize";
    private static final String BINDLINE_SIZE = "bindLineSize";
    private static final String RPT_SCRIPT_ID_PREFIX = "rptID";
    private static final String BIND_LINE_SCRIPT_ID_PREFIX = "bindLineID";
    private static final Logger normalLogger = TELogFactory.getNormalLogger();

    public int doExport(int neID, int item) {
        if (!TENEListMgr.getInstance().isAddedNE(neID)) {
            return 0;
        }
        TENE ne = TEConfigurationDataMgr.getInstance().getNE(neID);
        int nePhyType = ne.getNEType();
        if (!TEMarineScriptUtil.isMarineDevice(nePhyType)) {
            return 1090613252;
        }
        normalLogger.info("Marine export cable to script begin.");
        int result = 0;
        ArrayList<TEMarineCablePO> cablePOList = new ArrayList<TEMarineCablePO>();
        result = this.getExportDataFromDataBase(cablePOList);
        if (0 == result) {
            result = this.writeExportDataToScript(cablePOList, neID, item);
        }
        normalLogger.info("Marine export cable to script. result->" + result);
        return result;
    }

    public int doImport(int neID, int item, List<TEScriptCmd> contents) {
        int result = 0;
        if (null == contents || contents.isEmpty()) {
            return result;
        }
        TEMarineCablePO cablePO = null;
        for (TEScriptCmd cmd : contents) {
            cablePO = this.parsePOFromCmd(cmd);
            result = this.doCreateOperation(cablePO);
        }
        return result;
    }

    private int getExportDataFromDataBase(List<TEMarineCablePO> cablePOList) {
        int returnCode = 0;
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineCablePO.class);
        }
        catch (Exception e) {
            normalLogger.error("Marine find all data error!", (Throwable)e);
            returnCode = 1092743443;
            return returnCode;
        }
        if (0 == returnCode && null == dbResult) {
            normalLogger.error("The dbResult is null!");
            returnCode = 1092743443;
            return returnCode;
        }
        returnCode = dbResult.getResult();
        if (0 == returnCode) {
            TEMarineCablePO cablePO = null;
            List data = dbResult.getData();
            for (Object obj : data) {
                cablePO = (TEMarineCablePO)obj;
                cablePOList.add(cablePO);
            }
        }
        return returnCode;
    }

    private int writeExportDataToScript(List<TEMarineCablePO> cablePOList, int neID, int item) {
        int result = 0;
        TEScriptCmd cmd = null;
        for (TEMarineCablePO cablePO : cablePOList) {
            cmd = new TEScriptCmd();
            cmd.setCmdCode(item);
            this.constractScriptCmd(cmd, cablePO);
            result = TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd);
            if (0 == result) continue;
            break;
        }
        return result;
    }

    private void constractScriptCmd(TEScriptCmd cmd, TEMarineCablePO cablePO) {
        int cableID = cablePO.getCableID();
        int srcType = cablePO.getSrcType();
        int srcStationID = cablePO.getSrcStationID();
        String srcStationName = cablePO.getSrcStationName();
        String srcNodeName = cablePO.getSrcNodeName();
        int sinkType = cablePO.getSinkType();
        int sinkStationID = cablePO.getSinkStationID();
        String sinkStationName = cablePO.getSinkStationName();
        String sinkNodeName = cablePO.getSinkNodeName();
        String cableName = cablePO.getCableName();
        int rptNum = cablePO.getRptNum();
        int faultType = cablePO.getFaultType();
        String cableMemo = cablePO.getCableMemo();
        Set rptList = cablePO.getRPTList();
        Set bONDLineList = cablePO.getBONDLineList();
        String srcBUPortName = cablePO.getSrcBuPortName();
        String sinkBUPortName = cablePO.getSinkBuPortName();
        int cableLen = cablePO.getCableLen();
        int cableResistance = cablePO.getCableResistance();
        int cable20Resistance = cablePO.getCable20Resistance();
        int curTemperature = cablePO.getCurTemperature();
        cmd.addPara(CABLE_ID, cableID, false, true);
        cmd.addPara(SRC_TYPE, srcType, false, true);
        cmd.addPara(SRC_STATION_ID, srcStationID, false, true);
        cmd.addPara(SRC_STATION_NAME, srcStationName, true, true);
        cmd.addPara(SRC_NODE_NAME, srcNodeName, true, true);
        cmd.addPara(SRCBUPORTNAME, srcBUPortName, true, true);
        cmd.addPara(SINK_TYPE, sinkType, false, true);
        cmd.addPara(SINK_STATION_ID, sinkStationID, false, true);
        cmd.addPara(SINK_STATION_NAME, sinkStationName, true, true);
        cmd.addPara(SINK_NODE_NAME, sinkNodeName, true, true);
        cmd.addPara(SINKBUPORTNAME, sinkBUPortName, true, true);
        cmd.addPara(CABLE_NAME, cableName, true, true);
        cmd.addPara(RPT_NUM, rptNum, false, true);
        cmd.addPara(FAULT_TYPE, faultType, false, true);
        cmd.addPara(CABLELEN, cableLen, false, true);
        cmd.addPara(CABLERESISTANCE, cableResistance, false, true);
        cmd.addPara(CABLE20RESISTANCE, cable20Resistance, false, true);
        cmd.addPara(CABLECURTEMP, curTemperature, false, true);
        cmd.addPara(CABLE_MEMO, cableMemo, true, true);
        cmd.addPara(RPTLIST_SIZE, rptList.size(), false, true);
        cmd.addPara(BINDLINE_SIZE, bONDLineList.size(), false, true);
        StringBuffer sb = null;
        String rptScriptIDStr = null;
        int rptID = -1;
        int vDrop = -1;
        String rptName = null;
        String rptRemark = null;
        int index = 0;
        for (TEMarineRepeaterPO rptPO : rptList) {
            rptScriptIDStr = RPT_SCRIPT_ID_PREFIX + index;
            rptID = rptPO.getID();
            vDrop = rptPO.getVDrop();
            rptName = rptPO.getName();
            rptRemark = rptPO.getRemark();
            sb = new StringBuffer();
            sb.append('\"');
            sb.append(rptID);
            sb.append('&');
            sb.append(rptName);
            sb.append('&');
            sb.append(rptRemark);
            sb.append('&');
            sb.append(rptPO.getCreatTime());
            sb.append('&');
            sb.append(vDrop);
            sb.append('\"');
            cmd.addPara(rptScriptIDStr, sb.toString(), false, true);
            ++index;
        }
        StringBuffer bLineSB = null;
        String bLineScriptIDStr = null;
        int blindex = 0;
        for (TECableBondLinePO bline : bONDLineList) {
            bLineScriptIDStr = BIND_LINE_SCRIPT_ID_PREFIX + blindex;
            int lineId = bline.getLineId();
            long srcNeID = bline.getSrcNeID();
            long snkNeID = bline.getSnkNeID();
            bLineSB = new StringBuffer();
            bLineSB.append('\"');
            bLineSB.append(lineId);
            bLineSB.append('&');
            bLineSB.append(srcNeID);
            bLineSB.append('&');
            bLineSB.append(snkNeID);
            bLineSB.append('\"');
            cmd.addPara(bLineScriptIDStr, bLineSB.toString(), false, true);
            ++blindex;
        }
    }

    private TEMarineCablePO parsePOFromCmd(TEScriptCmd cmd) {
        int i;
        TEMarineCablePO cablePO = null;
        ArrayList paraValueList = new ArrayList();
        int cableID = -1;
        int srcType = -1;
        int srcStationID = -1;
        String srcStationName = null;
        String srcNodeName = null;
        String srcBUPortName = null;
        int sinkType = -1;
        int sinkStationID = -1;
        String sinkStationName = null;
        String sinkNodeName = null;
        String snkBUPortName = null;
        String cableName = null;
        int rptNum = -1;
        int faultType = 1;
        String cableMemo = null;
        int rptListSize = -1;
        int bindLineListSize = -1;
        String rptIDStr = null;
        String rptInfoStr = null;
        String blineInfoStr = null;
        TEMarineRepeaterPO rptPO = null;
        HashSet<TEMarineRepeaterPO> rptList = null;
        String blineIDStr = null;
        HashSet<TECableBondLinePO> bindLineList = null;
        paraValueList.clear();
        cmd.getPara(CABLE_ID, paraValueList, false);
        cableID = Integer.parseInt((String)paraValueList.get(0));
        paraValueList.clear();
        cmd.getPara(SRC_TYPE, paraValueList, false);
        srcType = Integer.parseInt((String)paraValueList.get(0));
        paraValueList.clear();
        cmd.getPara(SRC_STATION_ID, paraValueList, false);
        srcStationID = Integer.parseInt((String)paraValueList.get(0));
        paraValueList.clear();
        cmd.getPara(SRC_STATION_NAME, paraValueList, false);
        srcStationName = (String)paraValueList.get(0);
        paraValueList.clear();
        cmd.getPara(SRC_NODE_NAME, paraValueList, false);
        srcNodeName = (String)paraValueList.get(0);
        paraValueList.clear();
        cmd.getPara(SRCBUPORTNAME, paraValueList, false);
        srcBUPortName = (String)paraValueList.get(0);
        paraValueList.clear();
        cmd.getPara(SINK_TYPE, paraValueList, false);
        sinkType = Integer.parseInt((String)paraValueList.get(0));
        paraValueList.clear();
        cmd.getPara(SINK_STATION_ID, paraValueList, false);
        sinkStationID = Integer.parseInt((String)paraValueList.get(0));
        paraValueList.clear();
        cmd.getPara(SINK_STATION_NAME, paraValueList, false);
        sinkStationName = (String)paraValueList.get(0);
        paraValueList.clear();
        cmd.getPara(SINK_NODE_NAME, paraValueList, false);
        sinkNodeName = (String)paraValueList.get(0);
        paraValueList.clear();
        cmd.getPara(SINKBUPORTNAME, paraValueList, false);
        snkBUPortName = (String)paraValueList.get(0);
        paraValueList.clear();
        cmd.getPara(CABLE_NAME, paraValueList, false);
        cableName = (String)paraValueList.get(0);
        paraValueList.clear();
        cmd.getPara(RPT_NUM, paraValueList, false);
        rptNum = Integer.parseInt((String)paraValueList.get(0));
        paraValueList.clear();
        cmd.getPara(FAULT_TYPE, paraValueList, false);
        faultType = Integer.parseInt((String)paraValueList.get(0));
        paraValueList.clear();
        cmd.getPara(CABLELEN, paraValueList, false);
        int cableLen = Integer.parseInt((String)paraValueList.get(0));
        paraValueList.clear();
        cmd.getPara(CABLERESISTANCE, paraValueList, false);
        int cableResistance = Integer.parseInt((String)paraValueList.get(0));
        paraValueList.clear();
        cmd.getPara(CABLE20RESISTANCE, paraValueList, false);
        int cable20Resistance = Integer.parseInt((String)paraValueList.get(0));
        paraValueList.clear();
        cmd.getPara(CABLECURTEMP, paraValueList, false);
        int curTemperature = Integer.parseInt((String)paraValueList.get(0));
        paraValueList.clear();
        cmd.getPara(CABLE_MEMO, paraValueList, false);
        cableMemo = (String)paraValueList.get(0);
        paraValueList.clear();
        cmd.getPara(RPTLIST_SIZE, paraValueList, false);
        rptListSize = Integer.parseInt((String)paraValueList.get(0));
        rptList = new HashSet<TEMarineRepeaterPO>();
        for (i = 0; i < rptListSize; ++i) {
            rptIDStr = RPT_SCRIPT_ID_PREFIX + i;
            paraValueList.clear();
            cmd.getPara(rptIDStr, paraValueList, false);
            rptInfoStr = (String)paraValueList.get(0);
            rptPO = this.createRptPOFromInfoStr(rptInfoStr);
            rptList.add(rptPO);
        }
        paraValueList.clear();
        cmd.getPara(BINDLINE_SIZE, paraValueList, false);
        bindLineListSize = Integer.parseInt((String)paraValueList.get(0));
        bindLineList = new HashSet<TECableBondLinePO>();
        for (i = 0; i < bindLineListSize; ++i) {
            blineIDStr = BIND_LINE_SCRIPT_ID_PREFIX + i;
            paraValueList.clear();
            cmd.getPara(blineIDStr, paraValueList, false);
            blineInfoStr = (String)paraValueList.get(0);
            bindLineList.add(this.createBindLinePOFromeInfoStr(blineInfoStr));
        }
        cablePO = new TEMarineCablePO();
        cablePO.setCableID(cableID);
        cablePO.setSrcType(srcType);
        cablePO.setSrcStationID(srcStationID);
        cablePO.setSrcStationName(srcStationName);
        cablePO.setSrcNodeName(srcNodeName);
        cablePO.setSrcBuPortName(srcBUPortName);
        cablePO.setSinkType(sinkType);
        cablePO.setSinkStationID(sinkStationID);
        cablePO.setSinkStationName(sinkStationName);
        cablePO.setSinkNodeName(sinkNodeName);
        cablePO.setSinkBuPortName(snkBUPortName);
        cablePO.setCableName(cableName);
        cablePO.setRptNum(rptNum);
        cablePO.setFaultType(faultType);
        cablePO.setCableLen(cableLen);
        cablePO.setCableResistance(cableResistance);
        cablePO.setCable20Resistance(cable20Resistance);
        cablePO.setCurTemperature(curTemperature);
        cablePO.setCableMemo(cableMemo);
        cablePO.setRPTList(rptList);
        cablePO.setBONDLineList(bindLineList);
        return cablePO;
    }

    private TECableBondLinePO createBindLinePOFromeInfoStr(String blineInfoStr) {
        TECableBondLinePO bpo = new TECableBondLinePO();
        String[] blineInfoAttr = blineInfoStr.split("&");
        bpo.setLineId(Integer.parseInt(blineInfoAttr[0]));
        bpo.setSrcNeID(Long.parseLong(blineInfoAttr[1]));
        bpo.setSnkNeID(Long.parseLong(blineInfoAttr[2]));
        return bpo;
    }

    private TEMarineRepeaterPO createRptPOFromInfoStr(String rptInfoStr) {
        TEMarineRepeaterPO rptPO = new TEMarineRepeaterPO();
        String[] rptInfoArr = rptInfoStr.split("&");
        rptPO.setID(Integer.parseInt(rptInfoArr[0]));
        rptPO.setName(rptInfoArr[1]);
        rptPO.setRemark(rptInfoArr[2]);
        rptPO.setCreatTime(Long.parseLong(rptInfoArr[3]));
        return rptPO;
    }

    private int doCreateOperation(TEMarineCablePO cablePO) {
        int result = 0;
        if (this.isCableExist(cablePO)) {
            result = 1090615093;
        } else if (!this.isCableSrcExist(cablePO)) {
            result = 1090615098;
        } else if (!this.isCableSinkExist(cablePO)) {
            result = 1090615099;
        } else {
            this.filterExistRepeaters(cablePO);
            result = this.doCreateCable(cablePO);
        }
        return result;
    }

    private int filterExistRepeaters(TEMarineCablePO cablePO) {
        int returnCode = 0;
        ArrayList<TEMarineRepeaterPO> rptPOList = new ArrayList<TEMarineRepeaterPO>();
        ArrayList<TEMarineRepeaterPO> removedRptPOList = new ArrayList<TEMarineRepeaterPO>();
        this.getRptFromDB(rptPOList);
        returnCode = this.filterExistRepeaters(rptPOList, cablePO, removedRptPOList);
        return returnCode;
    }

    private int filterExistRepeaters(List<TEMarineRepeaterPO> rptPOList, TEMarineCablePO cablePO, List<TEMarineRepeaterPO> removedrptPOList) {
        int returnCode = 0;
        Set cableRptPOList = cablePO.getRPTList();
        Iterator iterator = null;
        TEMarineRepeaterPO cableRPTPO2 = null;
        block0: for (TEMarineRepeaterPO rptPO : rptPOList) {
            for (TEMarineRepeaterPO cableRPTPO2 : cableRptPOList) {
                if (!this.isSameRptName(cableRPTPO2, rptPO)) continue;
                if (1090615096 != returnCode) {
                    returnCode = 1090615096;
                }
                removedrptPOList.add(cableRPTPO2);
                cableRptPOList.remove(cableRPTPO2);
                continue block0;
            }
        }
        return returnCode;
    }

    private boolean isSameRptName(TEMarineRepeaterPO cableRPTPO, TEMarineRepeaterPO rptPO) {
        boolean isSame = false;
        isSame = cableRPTPO.getName().equals(rptPO.getName());
        return isSame;
    }

    private boolean isCableSrcExist(TEMarineCablePO cablePO) {
        boolean isExist = false;
        int srcType = cablePO.getSrcType();
        String srcStationName = cablePO.getSrcStationName();
        String srcNodeName = cablePO.getSrcNodeName();
        isExist = this.isCableEndPointExist(srcType, srcStationName, srcNodeName);
        return isExist;
    }

    private boolean isCableSinkExist(TEMarineCablePO cablePO) {
        boolean isExist = false;
        int sinkType = cablePO.getSinkType();
        String sinkStationName = cablePO.getSinkStationName();
        String sinkNodeName = cablePO.getSinkNodeName();
        isExist = this.isCableEndPointExist(sinkType, sinkStationName, sinkNodeName);
        return isExist;
    }

    private boolean isCableEndPointExist(int nodeType, String stationName, String nodeName) {
        boolean isAvailable = false;
        isAvailable = 0 == nodeType ? TEMarineScriptUtil.isStationExistInDB(stationName, nodeName) : TEMarineScriptUtil.isBUExistInDB(nodeName);
        return isAvailable;
    }

    private int doCreateCable(TEMarineCablePO cablePO) {
        int returnCode = 0;
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.create((Object)cablePO);
        }
        catch (Exception e) {
            normalLogger.error("", (Throwable)e);
            returnCode = 1092743443;
            return returnCode;
        }
        if (null == dbResult) {
            normalLogger.error("The dbResult is null!");
            returnCode = 1092743443;
            return returnCode;
        }
        returnCode = dbResult.getResult();
        if (0 == returnCode) {
            AsnMarineCable asnCable = TEMarineCableMgrTask.poCable2AsnCable(cablePO);
            TEMarineCableNoticeMgr.sendCreateCableNtfToC(asnCable);
        }
        return returnCode;
    }

    private boolean isCableExist(TEMarineCablePO cablePO) {
        boolean isExist = false;
        int cableID = 0;
        ArrayList<TEMarineCablePO> cablePOList = new ArrayList<TEMarineCablePO>();
        this.getCableListFromDB(cablePOList, cableID);
        isExist = this.isCableExist(cablePOList, cablePO);
        return isExist;
    }

    private boolean isCableExist(List<TEMarineCablePO> cablePOList, TEMarineCablePO cablePO) {
        boolean isExist = false;
        if (null != cablePOList && null != cablePO) {
            for (TEMarineCablePO tempCablePO : cablePOList) {
                if (!tempCablePO.getCableName().equals(cablePO.getCableName())) continue;
                isExist = true;
                break;
            }
        }
        return isExist;
    }

    private int getCableListFromDB(List<TEMarineCablePO> cablePOList, int cableID) {
        normalLogger.info("Marine Script: Get cable list from db.");
        int returnCode = 0;
        if (null == cablePOList) {
            cablePOList = new ArrayList<TEMarineCablePO>();
        }
        TEDaoOperationResult dbResult = null;
        try {
            if (0 == cableID) {
                dbResult = TECommonDaoService.findAll(TEMarineCablePO.class);
            } else {
                ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
                TEDaoNameValuePair aPair = new TEDaoNameValuePair("CableID", String.valueOf(cableID));
                criteria.add(aPair);
                dbResult = TECommonDaoService.findByID(TEMarineCablePO.class, criteria);
            }
        }
        catch (Exception e) {
            normalLogger.error("", (Throwable)e);
            returnCode = 1092743443;
            return returnCode;
        }
        if (null == dbResult) {
            normalLogger.error("The dbResult is null!");
            returnCode = 1092743443;
            return returnCode;
        }
        returnCode = dbResult.getResult();
        if (0 == returnCode) {
            TEMarineCablePO cablePO = null;
            List data = dbResult.getData();
            for (Object obj : data) {
                cablePO = (TEMarineCablePO)obj;
                cablePOList.add(cablePO);
            }
        }
        return returnCode;
    }

    private int getRptFromDB(List<TEMarineRepeaterPO> rptPOList) {
        int returnCode = 0;
        normalLogger.info("Marine Script: get repeaters from db.");
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineCablePO.class);
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
            returnCode = 1092743443;
            return returnCode;
        }
        if (null == dbResult) {
            normalLogger.error("The dbResult is null!");
            returnCode = 1092743443;
            return returnCode;
        }
        returnCode = dbResult.getResult();
        if (0 == returnCode) {
            List data = dbResult.getData();
            Set rptPOSet = null;
            for (Object obj : data) {
                TEMarineCablePO tmpPO = (TEMarineCablePO)obj;
                rptPOSet = tmpPO.getRPTList();
                rptPOList.addAll(rptPOSet);
            }
        }
        return returnCode;
    }
}

