/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.repeatermgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineRepeater;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineRepeaterList;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnModifyRepeaterReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnModifyRepeaterRsp;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnRPTModifyReturn;
import com.huawei.nglct.nemgr.marine.e2e.repeatermgr.TEMarineRepeaterNoticeMgr;
import com.huawei.nglct.nemgr.marine.e2e.repeatermgr.TEMarineRepeaterPubFunMgr;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCablePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineRepeaterPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEMarineModifyRepeaterHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private static int TECMDCODE_MODIFY_REPEATER = 2179353;

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm, TETaskInfo info) {
        List data;
        normalLogger.info(TEAsn1Util.getAsn1String((Object)req));
        AsnModifyRepeaterReq cReq = (AsnModifyRepeaterReq)req;
        AsnModifyRepeaterRsp cRsp = (AsnModifyRepeaterRsp)rsp;
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("repeatermgr").append(File.separator).append("repeatermgr_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)0, (StringBuffer)filePath);
        ArrayList<TEMarineLogInfo> marineLogInfoList = new ArrayList<TEMarineLogInfo>();
        TEMarineLogInfo marineLogInfo = new TEMarineLogInfo();
        marineLogInfo.setCmdID(TECMDCODE_MODIFY_REPEATER);
        marineLogInfo.setOperateName(res.getString("slm_modify_repeater"));
        marineLogInfo.setOperateDesc(this.getDetailStr(cReq, res));
        marineLogInfo.setOperateObject(this.getObjectStr(cReq, res));
        String ipAddress = TopoUtility.ipToString((long)info.getMsgHead().senderProcIP);
        int userID = cReq.userID.intValue();
        int cableID = cReq.cableID.intValue();
        TEDaoOperationResult dbResult = null;
        TEMarineCablePO cablePO = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineCablePO.class);
            data = dbResult.getData();
            for (Object obj : data) {
                TEMarineCablePO tmpPO = (TEMarineCablePO)obj;
                int cableIDTmp = tmpPO.CableID;
                if (cableID != cableIDTmp) continue;
                cablePO = tmpPO;
                break;
            }
        }
        catch (Exception e) {
            normalLogger.error("", (Throwable)e);
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        if (null == cablePO) {
            normalLogger.error("can't find cable po->" + cableID);
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        cRsp.result.isSuccess = true;
        cRsp.result.setRetCode(0);
        Set rptList = cablePO.getRPTList();
        HashSet<TEMarineRepeaterPO> rptChgList = new HashSet<TEMarineRepeaterPO>();
        int modifyNum = 0;
        int rptID = 0;
        int vDrop = 0;
        int tmpRtn = 0;
        int len = cReq.repeaterList.size();
        for (int i = 0; i < len; ++i) {
            rptID = ((AsnMarineRepeater)cReq.repeaterList.get((int)i)).rptId.intValue();
            String name = new String(((AsnMarineRepeater)cReq.repeaterList.get((int)i)).name);
            vDrop = ((AsnMarineRepeater)cReq.repeaterList.get((int)i)).vDrop.intValue();
            String remark = new String(((AsnMarineRepeater)cReq.repeaterList.get((int)i)).remark);
            tmpRtn = TEMarineRepeaterPubFunMgr.checkRepeaterByName(data, name, rptID);
            if (0 != tmpRtn) {
                cRsp.result.setRetCode(1);
                AsnRPTModifyReturn modifyRet = new AsnRPTModifyReturn();
                modifyRet.rptId = BigInteger.valueOf(rptID);
                modifyRet.name = name.getBytes();
                modifyRet.vDrop = BigInteger.valueOf(vDrop);
                modifyRet.result.setRetCode(1090615087);
                cRsp.rptReturnList.add((Object)modifyRet);
                continue;
            }
            for (TEMarineRepeaterPO tmpRptPO : rptList) {
                if (rptID != tmpRptPO.getID()) continue;
                ++modifyNum;
                tmpRptPO.setName(name);
                tmpRptPO.setVDrop(vDrop);
                tmpRptPO.setRemark(remark);
                rptChgList.add(tmpRptPO);
            }
        }
        try {
            if (modifyNum != 0) {
                dbResult = TECommonDaoService.update((Object)cablePO);
            }
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        if (null == dbResult) {
            normalLogger.error("The dbResult is null!");
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(retCode);
            marineLogInfo.setErrCode(retCode);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
        } else if (null != rptChgList && !rptChgList.isEmpty()) {
            AsnMarineRepeaterList rptDataList = new AsnMarineRepeaterList();
            for (TEMarineRepeaterPO rptNtfPO : rptChgList) {
                AsnMarineRepeater asnRpt = new AsnMarineRepeater();
                asnRpt.rptId = BigInteger.valueOf(rptNtfPO.getID());
                asnRpt.name = rptNtfPO.getName().getBytes();
                asnRpt.remark = rptNtfPO.getRemark().getBytes();
                asnRpt.vDrop = BigInteger.valueOf(rptNtfPO.getVDrop());
                asnRpt.createtime = BigInteger.valueOf(rptNtfPO.getCreatTime());
                rptDataList.add((Object)asnRpt);
            }
            TEMarineRepeaterNoticeMgr.sendModifyRepeaterNtfToC(cableID, rptDataList);
            marineLogInfo.setErrCode(0);
            marineLogInfo.setResult(0);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
        }
        normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    public String getDetailStr(AsnModifyRepeaterReq req, TEResourceUtil res) {
        StringBuffer bf = new StringBuffer("");
        AsnMarineRepeaterList rList = req.repeaterList;
        AsnMarineRepeater repeater = null;
        int len = rList.size();
        for (int i = 0; i < len; ++i) {
            repeater = (AsnMarineRepeater)rList.get(i);
            bf.append(res.getString("repeater_name_str")).append(':');
            bf.append(new String(repeater.name)).append(',');
            bf.append(res.getString("repeater_vdrop_str")).append(':');
            bf.append(repeater.vDrop).append(',');
            bf.append(res.getString("repeater_memo_str")).append(':');
            bf.append(new String(repeater.remark)).append(';');
        }
        return bf.toString();
    }

    public String getObjectStr(AsnModifyRepeaterReq req, TEResourceUtil res) {
        StringBuffer bf = new StringBuffer("");
        AsnMarineRepeaterList rList = req.repeaterList;
        AsnMarineRepeater repeater = null;
        if (rList.size() > 0) {
            repeater = (AsnMarineRepeater)rList.get(0);
            bf.append(new String(repeater.name));
        }
        int len = rList.size();
        for (int i = 1; i < len; ++i) {
            repeater = (AsnMarineRepeater)rList.get(i);
            bf.append(',');
            bf.append(new String(repeater.name));
        }
        return bf.toString();
    }
}

