/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.repeatermgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineRepeater;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineRepeaterList;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnQueryRepeaterReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnQueryRepeaterRsp;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCablePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineRepeaterPO;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public class TEMarineGetRepeaterHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();

    public int handleRequest(AsnQueryRepeaterReq req, AsnQueryRepeaterRsp rsp, TaskMgr tm) {
        normalLogger.info(TEAsn1Util.getAsn1String((Object)req));
        AsnQueryRepeaterReq cReq = req;
        AsnQueryRepeaterRsp cRsp = rsp;
        int cableID = cReq.cableID.intValue();
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineCablePO.class);
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            return 2;
        }
        if (null == dbResult) {
            normalLogger.error("The dbResult is null!");
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            return 2;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            AsnMarineRepeaterList rptList = cRsp.repeaterList;
            List data = dbResult.getData();
            Set rptPOSet = new HashSet();
            for (Object obj : data) {
                TEMarineCablePO tmpPO = (TEMarineCablePO)obj;
                int cableIDTmp = tmpPO.CableID;
                if (cableID != cableIDTmp) continue;
                rptPOSet = tmpPO.getRPTList();
                break;
            }
            ArrayList<TEMarineRepeaterPO> rptPOList = new ArrayList<TEMarineRepeaterPO>();
            for (TEMarineRepeaterPO tmpRptPO : rptPOSet) {
                rptPOList.add(tmpRptPO);
            }
            Collections.sort(rptPOList);
            for (TEMarineRepeaterPO rptPOTmp : rptPOList) {
                AsnMarineRepeater asnData = new AsnMarineRepeater();
                asnData.rptId = BigInteger.valueOf(rptPOTmp.getID());
                asnData.name = rptPOTmp.getName().getBytes();
                asnData.vDrop = BigInteger.valueOf(rptPOTmp.getVDrop());
                asnData.remark = rptPOTmp.getRemark().getBytes();
                asnData.createtime = BigInteger.valueOf(rptPOTmp.getCreatTime());
                rptList.add((Object)asnData);
            }
            cRsp.result.isSuccess = true;
            cRsp.result.setRetCode(retCode);
        } else {
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(retCode);
        }
        normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }
}

