/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.repeatermgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnIntList;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnDeleteRepeaterReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnDeleteRepeaterRsp;
import com.huawei.nglct.nemgr.marine.e2e.repeatermgr.TEMarineRepeaterNoticeMgr;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCablePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineRepeaterPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEMarineDeleteRepeaterHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private static int TECMDCODE_DEL_REPEATER = 2179354;
    private TEMarineCablePO cableInfo = null;

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm, TETaskInfo info) {
        AsnDeleteRepeaterReq cReq = (AsnDeleteRepeaterReq)req;
        AsnDeleteRepeaterRsp cRsp = (AsnDeleteRepeaterRsp)rsp;
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("repeatermgr").append(File.separator).append("repeatermgr_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)0, (StringBuffer)filePath);
        ArrayList<TEMarineLogInfo> marineLogInfoList = new ArrayList<TEMarineLogInfo>();
        TEMarineLogInfo marineLogInfo = new TEMarineLogInfo();
        marineLogInfo.setCmdID(TECMDCODE_DEL_REPEATER);
        marineLogInfo.setOperateName(res.getString("slm_delete_repeater"));
        marineLogInfo.setOperateDesc(this.getDetailStr(cReq, res));
        marineLogInfo.setOperateObject(res.getString("slm_delete_repeater"));
        String ipAddress = TopoUtility.ipToString((long)info.getMsgHead().senderProcIP);
        int userID = cReq.userID.intValue();
        AsnIntList rptIDLst = cReq.rptIDList;
        int cableID = cReq.cableID.intValue();
        if (rptIDLst.isEmpty()) {
            cRsp.result.isSuccess = true;
            cRsp.result.setRetCode(0);
            normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
            marineLogInfo.setErrCode(0);
            marineLogInfo.setResult(0);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 0;
        }
        TEDaoOperationResult daoOperResult = null;
        TEMarineCablePO cablePO = null;
        try {
            daoOperResult = TECommonDaoService.findAll(TEMarineCablePO.class);
            List data = daoOperResult.getData();
            for (Object obj : data) {
                TEMarineCablePO tmpPO = (TEMarineCablePO)obj;
                int cableIDTmp = tmpPO.CableID;
                if (cableID != cableIDTmp) continue;
                cablePO = tmpPO;
                break;
            }
            this.cableInfo = cablePO;
            marineLogInfo.setOperateDesc(this.getDetailStr(cReq, res));
            marineLogInfo.setOperateObject(this.getObjectStr(cReq, res));
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        if (cablePO == null) {
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        this.delMarineRptPO(cablePO, rptIDLst);
        try {
            daoOperResult = TECommonDaoService.update((Object)cablePO);
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        if (null == daoOperResult) {
            normalLogger.error("The dbResult is null!");
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        int retCode = daoOperResult.getResult();
        if (0 == retCode) {
            cRsp.result.isSuccess = true;
            cRsp.result.setRetCode(retCode);
            marineLogInfo.setErrCode(0);
            marineLogInfo.setResult(0);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            TEMarineRepeaterNoticeMgr.sendDelRepeaterNtfToC(cableID, cReq.rptIDList);
        } else {
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(retCode);
            marineLogInfo.setErrCode(retCode);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
        }
        normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    private void delMarineRptPO(TEMarineCablePO CablePO, AsnIntList rptIDLst) {
        Set rptList = CablePO.getRPTList();
        int len = rptIDLst.size();
        block0: for (int i = 0; i < len; ++i) {
            int rptID = rptIDLst.get(i);
            for (TEMarineRepeaterPO tmpRpt : rptList) {
                if (tmpRpt.getID() != rptID) continue;
                rptList.remove(tmpRpt);
                --CablePO.RptNum;
                continue block0;
            }
        }
    }

    public String getDetailStr(AsnDeleteRepeaterReq req, TEResourceUtil res) {
        StringBuffer bf = new StringBuffer("");
        if (null == this.cableInfo) {
            return "";
        }
        Set repeaterList = this.cableInfo.RPTList;
        AsnIntList rptIDList = req.rptIDList;
        Integer repeaterID = null;
        block0: for (TEMarineRepeaterPO repeaterPO : repeaterList) {
            int len = rptIDList.size();
            for (int i = 0; i < len; ++i) {
                repeaterID = rptIDList.get(i);
                if (repeaterPO.getID() != repeaterID.intValue()) continue;
                bf.append(res.getString("repeater_name_str")).append(':');
                bf.append(repeaterPO.getName()).append(';');
                continue block0;
            }
        }
        return bf.toString();
    }

    public String getObjectStr(AsnDeleteRepeaterReq req, TEResourceUtil res) {
        StringBuffer bf = new StringBuffer("");
        if (null == this.cableInfo) {
            return "";
        }
        Set repeaterList = this.cableInfo.RPTList;
        AsnIntList rptIDList = req.rptIDList;
        Integer rptID = null;
        block0: for (TEMarineRepeaterPO repeaterPO : repeaterList) {
            int len = rptIDList.size();
            for (int i = 0; i < len; ++i) {
                rptID = rptIDList.get(i);
                if (repeaterPO.getID() != rptID.intValue()) continue;
                bf.append(repeaterPO.getName()).append(',');
                continue block0;
            }
        }
        return bf.toString().substring(0, bf.toString().length() - 1);
    }
}

