/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.quickfault;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnGetMarineQuickFaultReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnGetMarineQuickFaultRsp;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineQuickFaultInfoList;
import com.huawei.nglct.nemgr.marine.e2e.quickfault.TEMarineQuickFaultTask;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineQuickFaultAttributePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineQuickFaultConfPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineQuickFaultInfoPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;

public class TEMarineGetQuickFaultInfoHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private static int TECMDCODE_QUERY_MARINE_QUICKFAULTINFO = 2180253;
    private static final int RUNFLAG_STOP = 0;

    public int handleRequest(AsnGetMarineQuickFaultReq req, AsnGetMarineQuickFaultRsp rsp, TaskMgr tm, TETaskInfo info) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("quickfault").append(File.separator).append("quickfault_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)0, (StringBuffer)filePath);
        ArrayList<TEMarineLogInfo> marineLogInfoList = new ArrayList<TEMarineLogInfo>();
        TEMarineLogInfo marineLogInfo = new TEMarineLogInfo();
        marineLogInfo.setCmdID(TECMDCODE_QUERY_MARINE_QUICKFAULTINFO);
        marineLogInfo.setOperateName(res.getString("slm_query_quickfaultinfo"));
        marineLogInfo.setOperateDesc(res.getString("slm_query_quickfaultinfo"));
        marineLogInfo.setOperateObject(res.getString("slm_query_quickfaultinfo"));
        String ipAddress = TopoUtility.ipToString((long)info.getMsgHead().senderProcIP);
        int userID = req.userID.intValue();
        rsp.runFlag = BigInteger.valueOf(this.getRunFlag());
        normalLogger.info(TEAsn1Util.getAsn1String((Object)req));
        TEDaoOperationResult dbResult = null;
        try {
            int clearanceStatus = req.clearanceStatus.intValue();
            if (0 == clearanceStatus) {
                dbResult = TECommonDaoService.findAll(TEMarineQuickFaultInfoPO.class);
            } else {
                ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
                TEDaoNameValuePair aPair = new TEDaoNameValuePair("ClearanceStatus", String.valueOf(clearanceStatus));
                criteria.add(aPair);
                dbResult = TECommonDaoService.findByID(TEMarineQuickFaultInfoPO.class, criteria);
            }
        }
        catch (Exception e) {
            normalLogger.error("DB oper error!", (Throwable)e);
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        if (null == dbResult) {
            normalLogger.error("The dbResult is null!");
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            AsnMarineQuickFaultInfoList asnMarineQuickFaultInfoList = rsp.marineQuickFaultInfoList;
            TEMarineQuickFaultInfoPO quickFaultInfoPO = null;
            List data = dbResult.getData();
            for (Object obj : data) {
                quickFaultInfoPO = (TEMarineQuickFaultInfoPO)obj;
                asnMarineQuickFaultInfoList.add((Object)TEMarineQuickFaultTask.poFaultInfo2AsnFaultInfo(quickFaultInfoPO));
            }
            rsp.result.isSuccess = true;
            rsp.result.setRetCode(retCode);
            marineLogInfo.setErrCode(0);
            marineLogInfo.setResult(0);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
        } else {
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(retCode);
            marineLogInfo.setErrCode(retCode);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
        }
        normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    private int getRunFlag() {
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineQuickFaultConfPO.class);
            List data = dbResult.getData();
            Iterator i$ = data.iterator();
            if (i$.hasNext()) {
                Object obj = i$.next();
                TEMarineQuickFaultConfPO tmpPO = (TEMarineQuickFaultConfPO)obj;
                for (TEMarineQuickFaultAttributePO attributePO : tmpPO.getAttributeList()) {
                    if (!attributePO.getAttributeName().equals("runFlag")) continue;
                    return attributePO.getAttributeValue();
                }
            }
        }
        catch (Exception e) {
            return 0;
        }
        return 0;
    }
}

