/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.quickfault;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnClearMarineQuickFaultInfoReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnClearMarineQuickFaultInfoRsp;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineQuickFaultInfo;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineQuickFaultInfoList;
import com.huawei.nglct.nemgr.marine.e2e.quickfault.TEMarineQuickFaultNoticeMgr;
import com.huawei.nglct.nemgr.marine.e2e.quickfault.TEMarineQuickFaultTask;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineE2EUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineQuickFaultInfoPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;

public class TEMarineClearQuickFaultInfoHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private static int TECMDCODE_CLEAR_MARINE_QUICKFAULTINFO = 2180255;
    private static int UNCLEAR_STATUS = 0;

    public int handleRequest(AsnClearMarineQuickFaultInfoReq req, AsnClearMarineQuickFaultInfoRsp rsp, TaskMgr tm, TETaskInfo info) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("quickfault").append(File.separator).append("quickfault_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)0, (StringBuffer)filePath);
        ArrayList<TEMarineLogInfo> marineLogInfoList = new ArrayList<TEMarineLogInfo>();
        String ipAddress = TopoUtility.ipToString((long)info.getMsgHead().senderProcIP);
        int userID = req.userID.intValue();
        normalLogger.info(TEAsn1Util.getAsn1String((Object)req));
        AsnMarineQuickFaultInfoList quickFaultInfoList = req.quickFaultInfoList;
        if (quickFaultInfoList.isEmpty()) {
            rsp.result.isSuccess = true;
            rsp.result.setRetCode(0);
            TEMarineLogInfo marineLogInfo = new TEMarineLogInfo();
            marineLogInfo.setCmdID(TECMDCODE_CLEAR_MARINE_QUICKFAULTINFO);
            marineLogInfo.setOperateName(res.getString("slm_clear_quickfaultinfo"));
            marineLogInfo.setOperateDesc(this.getDetailStr(req, res));
            marineLogInfo.setOperateObject(res.getString("slm_clear_quickfaultinfo"));
            marineLogInfo.setErrCode(0);
            marineLogInfo.setResult(0);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 0;
        }
        HashMap<Integer, Integer> dbOperResult = new HashMap<Integer, Integer>();
        int len = quickFaultInfoList.size();
        for (int i = 0; i < len; ++i) {
            TEMarineLogInfo marineLogInfo = new TEMarineLogInfo();
            marineLogInfo.setCmdID(TECMDCODE_CLEAR_MARINE_QUICKFAULTINFO);
            marineLogInfo.setOperateName(res.getString("slm_clear_quickfaultinfo"));
            marineLogInfo.setOperateObject(res.getString("slm_clear_quickfaultinfo"));
            AsnMarineQuickFaultInfo asnFaultInfo = (AsnMarineQuickFaultInfo)quickFaultInfoList.get(i);
            String faultTime = new String(asnFaultInfo.faultTime);
            TEMarineQuickFaultInfoPO newFaultInfoPO = TEMarineQuickFaultTask.asnFaultInfo2POFaultInfo(asnFaultInfo);
            TEMarineQuickFaultInfoPO faultInfoPO = this.getOneInfoByFaultTime(faultTime);
            if (null == faultInfoPO) continue;
            faultInfoPO.ClearanceStatue = newFaultInfoPO.ClearanceStatue;
            faultInfoPO.ClearanceTime = newFaultInfoPO.ClearanceTime;
            faultInfoPO.ClearanceUser = newFaultInfoPO.ClearanceUser;
            marineLogInfo.setOperateDesc(this.getDetailStr(asnFaultInfo, res));
            TEDaoOperationResult dbResult = null;
            try {
                dbResult = TECommonDaoService.update((Object)faultInfoPO);
            }
            catch (Exception e) {
                normalLogger.error("DB oper error!", (Throwable)e);
                rsp.result.isSuccess = false;
                rsp.result.setRetCode(1092743443);
                marineLogInfo.setOperateDesc(this.getDetailStr(asnFaultInfo, res));
                marineLogInfo.setErrCode(1092743443);
                marineLogInfo.setResult(2);
                marineLogInfoList.add(marineLogInfo);
                TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
                return 2;
            }
            if (null == dbResult) {
                normalLogger.error("The dbResult is null!");
                rsp.result.isSuccess = false;
                rsp.result.setRetCode(1092743443);
                marineLogInfo.setOperateDesc(this.getDetailStr(asnFaultInfo, res));
                marineLogInfo.setErrCode(1092743443);
                marineLogInfo.setResult(2);
                marineLogInfoList.add(marineLogInfo);
                TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
                return 2;
            }
            int retCode = dbResult.getResult();
            dbOperResult.put(i, retCode);
            if (0 == retCode) {
                rsp.result.isSuccess = true;
                rsp.result.setRetCode(retCode);
                marineLogInfo.setOperateDesc(this.getDetailStr(asnFaultInfo, res));
                marineLogInfo.setErrCode(0);
                marineLogInfo.setResult(0);
                marineLogInfoList.add(marineLogInfo);
                continue;
            }
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(retCode);
            marineLogInfo.setOperateDesc(this.getDetailStr(asnFaultInfo, res));
            marineLogInfo.setErrCode(retCode);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
        }
        AsnMarineQuickFaultInfoList quickFaultInfoSuccList = new AsnMarineQuickFaultInfoList();
        int len2 = quickFaultInfoList.size();
        for (int i = 0; i < len2; ++i) {
            int retCode = (Integer)dbOperResult.get(i);
            if (0 != retCode) continue;
            quickFaultInfoSuccList.add((Object)((AsnMarineQuickFaultInfo)quickFaultInfoList.get(i)));
        }
        if (!quickFaultInfoSuccList.isEmpty()) {
            TEMarineQuickFaultNoticeMgr.sendClearQuickFaultInfoNtfToC(quickFaultInfoSuccList);
        }
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineQuickFaultInfoPO.class);
        }
        catch (Exception e) {
            normalLogger.error("DB oper error!", (Throwable)e);
        }
        if (null != dbResult && 0 == dbResult.getResult()) {
            TEMarineQuickFaultInfoPO quickFaultInfoPO = null;
            List data = dbResult.getData();
            boolean haveClearAll = true;
            for (Object obj : data) {
                quickFaultInfoPO = (TEMarineQuickFaultInfoPO)obj;
                if (UNCLEAR_STATUS != quickFaultInfoPO.getClearanceStatue()) continue;
                haveClearAll = false;
            }
            if (haveClearAll) {
                TEMarineE2EUtil.sendQFLampStatusToClient(0);
            }
        }
        TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
        normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    public TEMarineQuickFaultInfoPO getOneInfoByFaultTime(String faultTime) {
        List data;
        TEDaoNameValuePair qfP = new TEDaoNameValuePair("FaultTime", faultTime);
        ArrayList<TEDaoNameValuePair> nvp = new ArrayList<TEDaoNameValuePair>();
        nvp.add(qfP);
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findByID(TEMarineQuickFaultInfoPO.class, nvp);
        }
        catch (Exception e) {
            normalLogger.info("getOneInfoByFaultTime fail!");
            return null;
        }
        if (null != dbResult && 0 == dbResult.getResult() && null != (data = dbResult.getData()) && !data.isEmpty()) {
            TEMarineQuickFaultInfoPO qfInfoPO = (TEMarineQuickFaultInfoPO)data.get(0);
            return qfInfoPO;
        }
        return null;
    }

    public String getDetailStr(AsnClearMarineQuickFaultInfoReq req, TEResourceUtil res) {
        StringBuffer bf = new StringBuffer("");
        AsnMarineQuickFaultInfoList quickFaultInfoList = req.quickFaultInfoList;
        AsnMarineQuickFaultInfo quickFaultInfo = null;
        int len = quickFaultInfoList.size();
        for (int i = 0; i < len; ++i) {
            quickFaultInfo = (AsnMarineQuickFaultInfo)quickFaultInfoList.get(i);
            String faultTime = new String(quickFaultInfo.faultTime);
            if (!faultTime.equals("")) {
                faultTime = TEMarineE2EUtil.formatTimeInServer(Long.parseLong(faultTime));
            }
            bf.append(res.getString("faultTime")).append(':');
            bf.append(faultTime).append(',');
            bf.append(res.getString("faultArea")).append(':');
            bf.append(new String(quickFaultInfo.faultArea)).append(',');
            bf.append(res.getString("clearanceStatue_" + quickFaultInfo.clearanceStatue)).append(';');
            String clearanceTime = new String(quickFaultInfo.clearanceTime);
            if (!clearanceTime.equals("")) {
                clearanceTime = TEMarineE2EUtil.formatTimeInServer(Long.parseLong(clearanceTime));
            }
            bf.append(res.getString("clearanceTime")).append(':');
            bf.append(clearanceTime).append(',');
            bf.append(res.getString("clearanceUser")).append(':');
            bf.append(new String(quickFaultInfo.clearanceUser)).append(';');
        }
        return bf.toString();
    }

    public String getDetailStr(AsnMarineQuickFaultInfo asnFaultInfo, TEResourceUtil res) {
        StringBuffer bf = new StringBuffer("");
        String faultTime = new String(asnFaultInfo.faultTime);
        if (!faultTime.equals("")) {
            faultTime = TEMarineE2EUtil.formatTimeInServer(Long.parseLong(faultTime));
        }
        bf.append(res.getString("faultTime")).append(':');
        bf.append(faultTime).append(',');
        bf.append(res.getString("faultArea")).append(':');
        bf.append(new String(asnFaultInfo.faultArea)).append(',');
        bf.append(res.getString("clearanceStatue_" + asnFaultInfo.clearanceStatue)).append(';');
        String clearanceTime = new String(asnFaultInfo.clearanceTime);
        if (!clearanceTime.equals("")) {
            clearanceTime = TEMarineE2EUtil.formatTimeInServer(Long.parseLong(clearanceTime));
        }
        bf.append(res.getString("clearanceTime")).append(':');
        bf.append(clearanceTime).append(',');
        bf.append(res.getString("clearanceUser")).append(':');
        bf.append(new String(asnFaultInfo.clearanceUser)).append(';');
        return bf.toString();
    }
}

