/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.psumgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarinePSU;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnModifyMarinePSUReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnModifyMarinePSURsp;
import com.huawei.nglct.nemgr.marine.e2e.stationviewmgr.TEMarineStnViewNoticeMgr;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarinePowerSupplyUnitPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEMarineModifyPSUHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private static int TECMDCODE_MODIFY_MARINE_PSU = 2180195;

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm, TETaskInfo info) {
        normalLogger.info(TEAsn1Util.getAsn1String((Object)req));
        AsnModifyMarinePSUReq request = (AsnModifyMarinePSUReq)req;
        AsnModifyMarinePSURsp response = (AsnModifyMarinePSURsp)rsp;
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("psumgr").append(File.separator).append("psumgr_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)0, (StringBuffer)filePath);
        ArrayList<TEMarineLogInfo> marineLogInfoList = new ArrayList<TEMarineLogInfo>();
        TEMarineLogInfo marineLogInfo = new TEMarineLogInfo();
        marineLogInfo.setCmdID(TECMDCODE_MODIFY_MARINE_PSU);
        marineLogInfo.setOperateName(res.getString("slm_modify_psu"));
        marineLogInfo.setOperateDesc(this.getDetailStr(request, res));
        marineLogInfo.setOperateObject(new String(request.psuData.name));
        String ipAddress = TopoUtility.ipToString((long)info.getMsgHead().senderProcIP);
        int userID = request.userID.intValue();
        TEMarinePowerSupplyUnitPO psuPO = new TEMarinePowerSupplyUnitPO();
        psuPO.setName(new String(request.psuData.name));
        psuPO.setVoltage(request.psuData.voltage.intValue());
        psuPO.setCurrent(request.psuData.current.intValue());
        psuPO.setMemo(new String(request.psuData.memo));
        psuPO.setStationID(request.psuData.stnID.intValue());
        psuPO.setPosX(request.psuData.posX.intValue());
        psuPO.setPosY(request.psuData.posY.intValue());
        TEMarineStationPO stationPO = this.getStationPO(psuPO.getStationID());
        if (null == stationPO) {
            response.result.isSuccess = false;
            response.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        this.updateMarinePSUPOList(stationPO.PSUList, psuPO);
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.update((Object)stationPO);
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
            response.result.isSuccess = false;
            response.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        if (null == dbResult) {
            normalLogger.error("The dbResult is null!");
            response.result.isSuccess = false;
            response.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            response.result.isSuccess = true;
            response.result.setRetCode(retCode);
            marineLogInfo.setErrCode(0);
            marineLogInfo.setResult(0);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            TEMarineStnViewNoticeMgr.sendPSUModifyNoticeToClient(request.psuData);
        } else {
            response.result.isSuccess = false;
            response.result.setRetCode(retCode);
            marineLogInfo.setErrCode(retCode);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
        }
        normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    private void updateMarinePSUPOList(Set<TEMarinePowerSupplyUnitPO> PSUList, TEMarinePowerSupplyUnitPO psuPO) {
        String psuName = psuPO.getName();
        for (TEMarinePowerSupplyUnitPO tmpPSUPOData : PSUList) {
            if (!psuName.equals(tmpPSUPOData.Name)) continue;
            tmpPSUPOData.setVoltage(psuPO.getVoltage());
            tmpPSUPOData.setCurrent(psuPO.getCurrent());
            tmpPSUPOData.setMemo(psuPO.getMemo());
            return;
        }
    }

    private TEMarineStationPO getStationPO(int psuStnID) {
        TEMarineStationPO stationPO = null;
        TEMarineStationPO tmpPO = null;
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineStationPO.class);
            List data = dbResult.getData();
            for (Object obj : data) {
                tmpPO = (TEMarineStationPO)obj;
                int stnID = tmpPO.StationID;
                if (psuStnID != stnID) continue;
                stationPO = tmpPO;
                return stationPO;
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEMarineModifyPSUHandler.getStationPO() fail!", (Throwable)e);
        }
        return null;
    }

    public String getDetailStr(AsnModifyMarinePSUReq req, TEResourceUtil res) {
        StringBuffer bf = new StringBuffer("");
        AsnMarinePSU psu = req.psuData;
        bf.append(res.getString("name_str")).append(':');
        bf.append(new String(psu.name)).append(',');
        bf.append(res.getString("voltage_str")).append(':');
        bf.append(psu.voltage.toString()).append(',');
        bf.append(res.getString("current_str")).append(':');
        bf.append(psu.current.toString()).append(',');
        bf.append(res.getString("memo_str")).append(':');
        bf.append(new String(psu.memo)).append(';');
        return bf.toString();
    }
}

