/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.psumgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnDeleteMarinePSUReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnDeleteMarinePSURsp;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarinePSU;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarinePSUList;
import com.huawei.nglct.nemgr.marine.e2e.stationviewmgr.TEMarineStnViewNoticeMgr;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarinePowerSupplyUnitPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEMarineDeletePSUHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private static int TECMDCODE_DELETE_MARINE_PSU = 2180194;

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm, TETaskInfo info) {
        AsnDeleteMarinePSUReq request = (AsnDeleteMarinePSUReq)req;
        AsnDeleteMarinePSURsp response = (AsnDeleteMarinePSURsp)rsp;
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("psumgr").append(File.separator).append("psumgr_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)0, (StringBuffer)filePath);
        ArrayList<TEMarineLogInfo> marineLogInfoList = new ArrayList<TEMarineLogInfo>();
        TEMarineLogInfo marineLogInfo = new TEMarineLogInfo();
        marineLogInfo.setCmdID(TECMDCODE_DELETE_MARINE_PSU);
        marineLogInfo.setOperateName(res.getString("slm_delete_psu"));
        marineLogInfo.setOperateDesc(this.getDetailStr(request, res));
        marineLogInfo.setOperateObject(this.getObjectStr(request, res));
        String ipAddress = TopoUtility.ipToString((long)info.getMsgHead().senderProcIP);
        int userID = request.userID.intValue();
        AsnMarinePSUList psuList = request.psuList;
        if (request.psuList.isEmpty()) {
            response.result.isSuccess = false;
            response.result.setRetCode(2);
            normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
            marineLogInfo.setErrCode(0);
            marineLogInfo.setResult(0);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        TEMarineStationPO stationPO = this.getStationPO(this.getStnID(request.psuList));
        if (null == stationPO) {
            response.result.isSuccess = false;
            response.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        this.updateMarinePSUPOList(stationPO.PSUList, psuList);
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.update((Object)stationPO);
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
            response.result.isSuccess = false;
            response.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        if (null == dbResult) {
            normalLogger.error("The dbResult is null!");
            response.result.isSuccess = false;
            response.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            response.result.isSuccess = true;
            response.result.setRetCode(retCode);
            marineLogInfo.setErrCode(0);
            marineLogInfo.setResult(0);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            this.noticeClientPSUDelHandler(request.psuList);
        } else {
            response.result.isSuccess = false;
            response.result.setRetCode(retCode);
            marineLogInfo.setErrCode(retCode);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
        }
        normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    private int getStnID(AsnMarinePSUList psuList) {
        AsnMarinePSU tmpPSU = (AsnMarinePSU)psuList.get(0);
        return tmpPSU.stnID.intValue();
    }

    private TEMarineStationPO getStationPO(int psuStnID) {
        TEMarineStationPO stationPO = null;
        TEMarineStationPO tmpPO = null;
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineStationPO.class);
            List data = dbResult.getData();
            for (Object obj : data) {
                tmpPO = (TEMarineStationPO)obj;
                int stnID = tmpPO.StationID;
                if (psuStnID != stnID) continue;
                stationPO = tmpPO;
                return stationPO;
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEMarineDeletePSUHandler.getStationPO() fail!", (Throwable)e);
        }
        return null;
    }

    private void updateMarinePSUPOList(Set<TEMarinePowerSupplyUnitPO> PSUList, AsnMarinePSUList psuDataList) {
        int len = psuDataList.size();
        for (int index = 0; index < len; ++index) {
            AsnMarinePSU asnPSUData = (AsnMarinePSU)psuDataList.get(index);
            String psuName = new String(asnPSUData.name);
            this.delMarinePSUData(PSUList, psuName);
        }
    }

    private void delMarinePSUData(Set<TEMarinePowerSupplyUnitPO> PSUList, String psuName) {
        if (null == psuName || 0 == psuName.length()) {
            return;
        }
        Iterator<TEMarinePowerSupplyUnitPO> iter = PSUList.iterator();
        while (iter.hasNext()) {
            TEMarinePowerSupplyUnitPO psuPOData = iter.next();
            if (!psuName.equals(psuPOData.Name)) continue;
            iter.remove();
            return;
        }
    }

    private void noticeClientPSUDelHandler(AsnMarinePSUList noticePSUList) {
        if (null == noticePSUList || 0 == noticePSUList.size()) {
            return;
        }
        TEMarineStnViewNoticeMgr.sendPSUDeleteNoticeToClient(noticePSUList);
    }

    public String getDetailStr(AsnDeleteMarinePSUReq req, TEResourceUtil res) {
        StringBuffer bf = new StringBuffer("");
        AsnMarinePSUList psuList = req.psuList;
        AsnMarinePSU psu = null;
        int len = psuList.size();
        for (int i = 0; i < len; ++i) {
            psu = (AsnMarinePSU)psuList.get(i);
            bf.append(res.getString("name_str")).append(':');
            bf.append(new String(psu.name)).append(';');
        }
        return bf.toString();
    }

    public String getObjectStr(AsnDeleteMarinePSUReq req, TEResourceUtil res) {
        StringBuffer bf = new StringBuffer("");
        AsnMarinePSUList psuList = req.psuList;
        AsnMarinePSU psu = null;
        if (psuList.size() > 0) {
            psu = (AsnMarinePSU)psuList.get(0);
            bf.append(new String(psu.name));
        }
        int len = psuList.size();
        for (int i = 1; i < len; ++i) {
            psu = (AsnMarinePSU)psuList.get(i);
            bf.append(';');
            bf.append(new String(psu.name));
        }
        return bf.toString();
    }
}

