/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.psumgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnCreateMarinePSUReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnCreateMarinePSURsp;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarinePSU;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarinePSUList;
import com.huawei.nglct.nemgr.marine.e2e.stationviewmgr.TEMarineStnViewNoticeMgr;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarinePowerSupplyUnitPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEMarineCreatePSUHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private static final int OFFSET_POS = 40;
    private static int TECMDCODE_CREATE_MARINE_PSU = 2180196;

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm, TETaskInfo info) {
        AsnCreateMarinePSUReq cReq = (AsnCreateMarinePSUReq)req;
        AsnCreateMarinePSURsp cRsp = (AsnCreateMarinePSURsp)rsp;
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("psumgr").append(File.separator).append("psumgr_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)0, (StringBuffer)filePath);
        ArrayList<TEMarineLogInfo> marineLogInfoList = new ArrayList<TEMarineLogInfo>();
        TEMarineLogInfo marineLogInfo = new TEMarineLogInfo();
        marineLogInfo.setCmdID(TECMDCODE_CREATE_MARINE_PSU);
        marineLogInfo.setOperateName(res.getString("slm_create_psu"));
        marineLogInfo.setOperateDesc(this.getDetailStr(cReq, res));
        marineLogInfo.setOperateObject(new String(cReq.psuData.name));
        String ipAddress = TopoUtility.ipToString((long)info.getMsgHead().senderProcIP);
        int userID = cReq.userID.intValue();
        int psuStnID = cReq.psuData.stnID.intValue();
        String psuName = new String(cReq.psuData.name);
        TEMarinePowerSupplyUnitPO psuPO = new TEMarinePowerSupplyUnitPO();
        psuPO.setName(psuName);
        psuPO.setVoltage(cReq.psuData.voltage.intValue());
        psuPO.setCurrent(cReq.psuData.current.intValue());
        psuPO.setMemo(new String(cReq.psuData.memo));
        psuPO.setStationID(psuStnID);
        TEMarineStationPO stationPO = null;
        TEMarineStationPO tmpPO = null;
        TEDaoOperationResult dbResult = null;
        int tmpRtn = 0;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineStationPO.class);
            List data = dbResult.getData();
            tmpRtn = this.checkPSUByName(data, psuName);
            this.updatePosOfNewPSU(cReq, data);
            psuPO.setPosX(cReq.psuData.posX.intValue());
            psuPO.setPosY(cReq.psuData.posY.intValue());
            if (0 != tmpRtn) {
                cRsp.result.isSuccess = false;
                cRsp.result.setRetCode(1090615224);
                marineLogInfo.setErrCode(1090615224);
                marineLogInfo.setResult(2);
                marineLogInfoList.add(marineLogInfo);
                TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
                return 2;
            }
            for (Object obj : data) {
                tmpPO = (TEMarineStationPO)obj;
                int stnID = tmpPO.StationID;
                if (psuStnID != stnID) continue;
                stationPO = tmpPO;
            }
        }
        catch (Exception ex) {
            normalLogger.error(ex.toString());
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        if (stationPO == null) {
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        stationPO.PSUList.add(psuPO);
        try {
            dbResult = TECommonDaoService.update(stationPO);
        }
        catch (Exception ex) {
            normalLogger.error(ex.toString());
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        if (dbResult == null) {
            normalLogger.error("The dbResult is null!");
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        int retCode = dbResult.getResult();
        if (retCode == 0) {
            cRsp.result.isSuccess = true;
            cRsp.result.setRetCode(retCode);
            marineLogInfo.setErrCode(0);
            marineLogInfo.setResult(0);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            AsnMarinePSUList psuList = new AsnMarinePSUList();
            psuList.add((Object)cReq.psuData);
            TEMarineStnViewNoticeMgr.sendPSUCreateNoticeToClient(psuList);
        } else {
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(retCode);
            marineLogInfo.setErrCode(retCode);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
        }
        return 0;
    }

    private void updatePosOfNewPSU(AsnCreateMarinePSUReq cReq, List<Object> dataList) {
        if (null == dataList || 0 == dataList.size()) {
            return;
        }
        TEMarineStationPO tmpPO = null;
        int stnID = cReq.psuData.stnID.intValue();
        for (Object obj : dataList) {
            tmpPO = (TEMarineStationPO)obj;
            if (stnID != tmpPO.StationID) continue;
            this.updatePSUPos(cReq.psuData, tmpPO.PSUList);
            break;
        }
    }

    private void updatePSUPos(AsnMarinePSU psuReqData, Set<TEMarinePowerSupplyUnitPO> PSUList) {
        if (null == PSUList || 0 == PSUList.size()) {
            return;
        }
        boolean hasSame = false;
        for (TEMarinePowerSupplyUnitPO psuPOData : PSUList) {
            if (psuPOData.PosX != psuReqData.posX.intValue() || psuPOData.PosY != psuReqData.posY.intValue()) continue;
            psuReqData.posX = BigInteger.valueOf(40 + psuReqData.posX.intValue());
            hasSame = true;
            break;
        }
        if (hasSame) {
            this.updatePSUPos(psuReqData, PSUList);
        }
    }

    private int checkPSUByName(List<Object> dataList, String psuName) {
        if (null == psuName || 0 == psuName.length()) {
            return 2;
        }
        if (null == dataList || 0 == dataList.size()) {
            return 0;
        }
        TEMarineStationPO tmpPO = null;
        for (Object obj : dataList) {
            tmpPO = (TEMarineStationPO)obj;
            if (!this.havePSUData(tmpPO.PSUList, psuName)) continue;
            return 1090615224;
        }
        return 0;
    }

    private boolean havePSUData(Set<TEMarinePowerSupplyUnitPO> psuPOSet, String psuName) {
        for (TEMarinePowerSupplyUnitPO psuPO : psuPOSet) {
            if (!psuName.equals(psuPO.Name)) continue;
            return true;
        }
        return false;
    }

    public String getDetailStr(AsnCreateMarinePSUReq req, TEResourceUtil res) {
        StringBuffer strBuffer = new StringBuffer("");
        AsnMarinePSU psu = req.psuData;
        strBuffer.append(res.getString("name_str")).append(':');
        strBuffer.append(new String(psu.name)).append(',');
        strBuffer.append(res.getString("voltage_str")).append(':');
        strBuffer.append(psu.voltage.toString()).append(',');
        strBuffer.append(res.getString("current_str")).append(':');
        strBuffer.append(psu.current.toString()).append(',');
        strBuffer.append(res.getString("memo_str")).append(':');
        strBuffer.append(new String(psu.memo)).append(';');
        return strBuffer.toString();
    }
}

