/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.linemonitor;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnSingleReturn;
import com.huawei.nglct.nemgr.f_interface.marinetestmgr.AsnMarineCheckComm;
import com.huawei.nglct.nemgr.f_interface.marinetestmgr.AsnMarineSetCheckCommReq;
import com.huawei.nglct.nemgr.f_interface.marinetestmgr.AsnMarineSetCheckCommRsp;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.nemgr.marine.linemonitor_u2kv1r3c00.TESLMCommunicateCheckMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class TESLMTestSetCheckCommuStatusHandler {
    private static final int ERROR_CODE_LINE_NOT_EXSIT = 42781;
    private static final int TECMDCODE_SLM_E2E_SET_CHECK_COMMU = 2179782;

    public int handleRequest(AsnMarineSetCheckCommReq req, AsnMarineSetCheckCommRsp rsp, TaskMgr tm, TETaskInfo info) {
        if (req.checkCommList.isEmpty()) {
            AsnSingleReturn curRet = new AsnSingleReturn();
            curRet.isSuccess = true;
            curRet.retCode = BigInteger.ZERO;
            rsp.result.add((Object)curRet);
            return 0;
        }
        int reqCheckCommSize = req.checkCommList.size();
        for (int i = 0; i < reqCheckCommSize; ++i) {
            AsnSingleReturn curRet;
            AsnMarineCheckComm curCheckComm = (AsnMarineCheckComm)req.checkCommList.get(i);
            int neID = curCheckComm.neID.intValue();
            int lineRealID = curCheckComm.lineRealID.intValue();
            int checkComm = curCheckComm.checkComm.intValue();
            boolean isSuccess = TESLMCommunicateCheckMgr.getInstance().refreshData(neID, lineRealID, checkComm);
            if (!isSuccess) {
                curRet = new AsnSingleReturn();
                curRet.isSuccess = false;
                curRet.retCode = BigInteger.valueOf(42781L);
                String curReason = "LineID:" + lineRealID + "neID:" + neID;
                curRet.reason = curReason.getBytes();
                rsp.result.add((Object)curRet);
            }
            curRet = new AsnSingleReturn();
            curRet.isSuccess = true;
            curRet.retCode = BigInteger.ZERO;
            List<TEMarineLogInfo> logInfoList = this.getLogInfo(curCheckComm, curRet, info);
            this.writeLog(req.userID.intValue(), TopoUtility.ipToString((long)info.getMsgHead().senderProcIP), logInfoList);
        }
        if (rsp.result.isEmpty()) {
            AsnSingleReturn curRet = new AsnSingleReturn();
            curRet.isSuccess = true;
            curRet.retCode = BigInteger.ZERO;
            rsp.result.add((Object)curRet);
        }
        return 0;
    }

    private List<TEMarineLogInfo> getLogInfo(AsnMarineCheckComm req, AsnSingleReturn rsp, TETaskInfo info) {
        StringBuilder filePath = new StringBuilder();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("linemonitor").append(File.separator).append("linemonitor_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)0, (String)filePath.toString());
        int neID = req.neID.intValue();
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        ArrayList<TEMarineLogInfo> logInfoList = new ArrayList<TEMarineLogInfo>();
        TEMarineLogInfo logInfo = new TEMarineLogInfo();
        logInfo.setCmdID(info.getMsgHead().cmdCode);
        logInfo.setOperateName(res.getString("slm_set_test_param"));
        logInfo.setOperateObject(ne.getNEName());
        int ret = rsp.retCode.intValue();
        logInfo.setResult(ret);
        logInfo.setOperateDesc(this.getErrDetail(req));
        logInfo.setErrCode(ret);
        logInfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)ret));
        logInfoList.add(logInfo);
        return logInfoList;
    }

    private String getErrDetail(AsnMarineCheckComm req) {
        StringBuilder filePath = new StringBuilder();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("linemonitor").append(File.separator).append("linemonitor_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)0, (String)filePath.toString());
        StringBuilder detailStr = new StringBuilder(res.getString("slm_e2e_set_checkcommu"));
        int neID = req.neID.intValue();
        int lineRealID = req.lineRealID.intValue();
        int checkComm = req.checkComm.intValue();
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = ne.getNEName();
        detailStr.append(res.getString("NE")).append(neName).append(", ");
        detailStr.append(res.getString("LINE_ID")).append(lineRealID);
        detailStr.append(", ");
        String communicateCheck = res.getString("CommunicateCheck_" + checkComm);
        detailStr.append(res.getString("CommunicateCheck")).append(communicateCheck);
        return detailStr.toString();
    }

    private void writeLog(int userID, String ipAddress, List<TEMarineLogInfo> logInfoList) {
        TEMarineLogMgrUtil.writeLog(userID, ipAddress, logInfoList);
    }
}

