/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.linemonitor;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnSingleReturn;
import com.huawei.nglct.nemgr.f_interface.marinetestmgr.AsnQueryTestParamReq;
import com.huawei.nglct.nemgr.f_interface.marinetestmgr.AsnQueryTestParamRsp;
import com.huawei.nglct.nemgr.marine.e2e.linemonitor.TESLMTestUtil;
import com.huawei.nglct.nemgr.marine.linemonitor_u2kv1r3c00.TEGetTestParam;
import java.math.BigInteger;

public class TESLMQueryTestParamHandler {
    private String userID = null;

    public int handleRequest(AsnQueryTestParamReq req, AsnQueryTestParamRsp rsp, TaskMgr tm, TETaskInfo info) {
        this.userID = String.valueOf(req.userID);
        int neID = req.neID.intValue();
        this.initRspDefaultValue(rsp);
        Datainterface reqData = this.constructQueryTestParamReq(req);
        SubFunc subFunc = TESLMTestUtil.getSubFunc(neID, 2556002);
        TEGetTestParam bean = new TEGetTestParam();
        Datainterface neRsp = bean.performBussinessProcess(neID, subFunc, reqData, null, this.userID, TopoUtility.ipToString((long)info.getMsgHead().senderProcIP));
        this.constructQueryTestParamResult(neRsp, rsp);
        return Integer.parseInt(neRsp.getErrorMessage().getErrorcode());
    }

    private Datainterface constructQueryTestParamReq(AsnQueryTestParamReq req) {
        Datainterface data = new Datainterface();
        BussinessParams bus = new BussinessParams();
        data.setBussinessParams(bus);
        RowParams rp = new RowParams();
        Param param = new Param("neid", String.valueOf(req.neID.intValue()));
        rp.addParam(param);
        param = new Param("lineID", String.valueOf(req.realLineID.intValue()));
        rp.addParam(param);
        param = new Param("lineDirection", String.valueOf(req.lineDirection.intValue()));
        rp.addParam(param);
        param = new Param("testMode", String.valueOf(req.testMode.intValue()));
        rp.addParam(param);
        param = new Param("testType", String.valueOf(req.testType.intValue()));
        rp.addParam(param);
        param = new Param("spanNo", String.valueOf(req.spanNo.intValue()));
        rp.addParam(param);
        param = new Param("lmiSlotID", String.valueOf(req.lmiSlotID.intValue()));
        rp.addParam(param);
        param = new Param("lmiPortID", String.valueOf(req.lmiPortID.intValue()));
        rp.addParam(param);
        param = new Param("lmiChannelID", String.valueOf(req.lmiChannelID.intValue()));
        rp.addParam(param);
        bus.addRowParams(rp);
        return data;
    }

    private void constructQueryTestParamResult(Datainterface neRsp, AsnQueryTestParamRsp rsp) {
        AsnSingleReturn bigErrCode;
        this.initRspDefaultValue(rsp);
        int nErrorCode = Integer.parseInt(neRsp.getErrorMessage().getErrorcode());
        if (0 == nErrorCode) {
            bigErrCode = new AsnSingleReturn();
            bigErrCode.isSuccess = true;
            bigErrCode.retCode = BigInteger.valueOf(nErrorCode);
            rsp.result.add((Object)bigErrCode);
        } else {
            bigErrCode = new AsnSingleReturn();
            bigErrCode.isSuccess = false;
            bigErrCode.retCode = BigInteger.valueOf(nErrorCode);
            rsp.result.add((Object)bigErrCode);
        }
        BussinessParams bp = neRsp.getBussinessParams();
        int rps = bp.getRowParamsCount();
        Param param = null;
        for (int i = 0; i < rps; ++i) {
            RowErrors[] res;
            RowParams rp = bp.getRowParams(i);
            if (null == rp) continue;
            for (RowErrors re : res = rp.getRowErrors()) {
                AsnSingleReturn curErr = new AsnSingleReturn();
                if (null == re) continue;
                curErr.isSuccess = false;
                curErr.retCode = BigInteger.valueOf(Integer.valueOf(re.getErrorMessage().getErrorcode()).intValue());
                rsp.result.add((Object)curErr);
            }
            param = rp.getParam("pulseWidth");
            if (this.isInvalidParam(param)) {
                rsp.pulseWidth = new BigInteger(param.getValue());
            }
            if (this.isInvalidParam(param = rp.getParam("samplingTimes"))) {
                rsp.samplingTimes = new BigInteger(param.getValue());
            }
            if (this.isInvalidParam(param = rp.getParam("samplingFreq"))) {
                rsp.samplingFreq = new BigInteger(param.getValue());
            }
            if (this.isInvalidParam(param = rp.getParam("codePattern"))) {
                rsp.codePattern = new BigInteger(param.getValue());
            }
            if (this.isInvalidParam(param = rp.getParam("lmiPower"))) {
                rsp.lmiPower = new BigInteger(param.getValue());
            }
            if (this.isInvalidParam(param = rp.getParam("power"))) {
                rsp.power = new BigInteger(param.getValue());
            }
            if (this.isInvalidParam(param = rp.getParam("spanNo"))) {
                rsp.spanNo = new BigInteger(param.getValue());
            }
            if (this.isInvalidParam(param = rp.getParam("fiberType"))) {
                rsp.fiberType = param.getValue().getBytes();
            }
            if (this.isInvalidParam(param = rp.getParam("fiberLength"))) {
                rsp.fiberLength = new BigInteger(param.getValue());
            }
            if (this.isInvalidParam(param = rp.getParam("refractiveRate"))) {
                rsp.refraction = new BigInteger(param.getValue());
            }
            if (this.isInvalidParam(param = rp.getParam("attenuation"))) {
                rsp.attenuation = new BigInteger(param.getValue());
            }
            if (this.isInvalidParam(param = rp.getParam("inSerThrMax"))) {
                rsp.inSerThrMax = new BigInteger(param.getValue());
            }
            if (this.isInvalidParam(param = rp.getParam("inSerThrMin"))) {
                rsp.inSerThrMin = new BigInteger(param.getValue());
            }
            if (this.isInvalidParam(param = rp.getParam("probeWaveBand"))) {
                rsp.probeWaveBand = new BigInteger(param.getValue());
            }
            if (this.isInvalidParam(param = rp.getParam("probeWaveIndex"))) {
                rsp.probeWaveIndex = new BigInteger(param.getValue());
            }
            if (this.isInvalidParam(param = rp.getParam("loadingWaveBand"))) {
                rsp.loadingWaveBand = new BigInteger(param.getValue());
            }
            if (!this.isInvalidParam(param = rp.getParam("loadingWaveIndex"))) continue;
            rsp.loadingWaveIndex = new BigInteger(param.getValue());
        }
    }

    private void initRspDefaultValue(AsnQueryTestParamRsp rsp) {
        rsp.pulseWidth = BigInteger.ZERO;
        rsp.samplingTimes = BigInteger.ZERO;
        rsp.samplingFreq = BigInteger.ZERO;
        rsp.codePattern = BigInteger.ZERO;
        rsp.power = BigInteger.ZERO;
        rsp.lmiPower = BigInteger.ZERO;
        rsp.spanNo = BigInteger.ZERO;
        rsp.fiberType = "".getBytes();
        rsp.refraction = BigInteger.ZERO;
        rsp.fiberLength = BigInteger.ZERO;
        rsp.attenuation = BigInteger.ZERO;
        rsp.inSerThrMax = BigInteger.ZERO;
        rsp.inSerThrMin = BigInteger.ZERO;
        rsp.probeWaveBand = BigInteger.ZERO;
        rsp.probeWaveIndex = BigInteger.ZERO;
        rsp.loadingWaveBand = BigInteger.ZERO;
        rsp.loadingWaveIndex = BigInteger.ZERO;
    }

    private boolean isInvalidParam(Param param) {
        boolean result = true;
        if (null == param || null == param.getValue() || param.getValue().isEmpty()) {
            result = false;
        }
        return result;
    }
}

