/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.linemonitor;

import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.mdp.TEASN1CommMgr;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnDateTimeType;
import com.huawei.nglct.nemgr.f_interface.marinetestmgr.AsnMarineLineState;
import com.huawei.nglct.nemgr.f_interface.marinetestmgr.AsnRefreshLineStateNtfToC;
import com.huawei.nglct.nemgr.marine.e2e.linemonitor.TESLMTestUtil;
import com.huawei.nglct.otdr.linedata.TESLMLineState;
import java.math.BigInteger;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public final class TESLMLineTestStateNoticeMgr {
    private static final Logger log = TELogFactory.getNormalLogger();

    private TESLMLineTestStateNoticeMgr() {
    }

    public static void sendLineTestStateProgressChangeNtfToC(int neID, int lineID, TESLMLineState sta, AsnDateTimeType dt) {
        log.info("Line Monitor send sendLineTestStateProgressChangeNtfToC to Client.");
        if (null == sta) {
            log.info("Failed! state is null.");
            return;
        }
        TESLMLineState state = new TESLMLineState();
        state.refresh(sta);
        AsnMarineLineState lineState = new AsnMarineLineState();
        AsnRefreshLineStateNtfToC sendReFreshLineStateMsg = new AsnRefreshLineStateNtfToC();
        dt = TESLMTestUtil.convertCalendarToServerTime(neID, dt.year, dt.month, dt.day, dt.hour, dt.minute, dt.second);
        TESLMLineTestStateNoticeMgr.encapAsnMarineLineState(neID, lineID, state, lineState, dt);
        TESLMLineTestStateNoticeMgr.encapAsnRefreshLineStateNtfToC(lineState, sendReFreshLineStateMsg);
        log.info(TEAsn1Util.getAsn1String((Object)lineState));
        TEASN1CommMgr.sendEventClient((FStruct)sendReFreshLineStateMsg, (int)2179422);
    }

    private static void encapAsnRefreshLineStateNtfToC(AsnMarineLineState lineState, AsnRefreshLineStateNtfToC sendReFreshLineStateMsg) {
        sendReFreshLineStateMsg.neID = lineState.neID;
        sendReFreshLineStateMsg.lineID = lineState.lineID;
        sendReFreshLineStateMsg.lineState = lineState;
    }

    private static void encapAsnMarineLineState(int neID, int lineID, TESLMLineState state, AsnMarineLineState lineState, AsnDateTimeType dt) {
        lineState.neID = BigInteger.valueOf(neID);
        lineState.lineID = BigInteger.valueOf(lineID);
        lineState.testMode = BigInteger.valueOf(state.getTestMode());
        lineState.testType = BigInteger.valueOf(state.getTestType());
        lineState.testState = BigInteger.valueOf(state.getTestState());
        lineState.startTime = dt;
        lineState.timeToEnd = state.getTimeToEnd().getBytes();
        lineState.testProgress = BigInteger.valueOf(state.getTestProgress());
        lineState.midResultState = BigInteger.valueOf(state.getMidResultState());
        lineState.abortErrorCode = BigInteger.valueOf(state.getAbortErrorCode());
    }
}

