/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.linemonitor;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnDateTimeType;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnNEIDList;
import com.huawei.nglct.nemgr.f_interface.marinetestmgr.AsnMarineLineState;
import com.huawei.nglct.nemgr.f_interface.marinetestmgr.AsnMarineLineStateErr;
import com.huawei.nglct.nemgr.f_interface.marinetestmgr.AsnMarineQueryLineStateReq;
import com.huawei.nglct.nemgr.f_interface.marinetestmgr.AsnMarineQueryLineStateRsp;
import com.huawei.nglct.nemgr.marine.e2e.linemonitor.TESLMTestUtil;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLinePubFun;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class TESLMETestGetLineStateHandler {
    private String userID;
    private TETaskInfo info = null;

    public int handleRequest(AsnMarineQueryLineStateReq req, AsnMarineQueryLineStateRsp rsp, TaskMgr tm, TETaskInfo info1) {
        this.info = info1;
        AsnNEIDList asnNeIdList = req.neIDList;
        this.userID = String.valueOf(req.userID);
        int retCode = this.getLineState(asnNeIdList, rsp, this.userID, this.info);
        return retCode;
    }

    private int getLineState(AsnNEIDList asnNeIdList, AsnMarineQueryLineStateRsp rsp, String userID, TETaskInfo info) {
        int neID = -1;
        int retCode = -1;
        ArrayList<AsnMarineLineState> lineStateList = new ArrayList<AsnMarineLineState>();
        AsnMarineLineStateErr errorInfo = null;
        neID = asnNeIdList.get(0);
        Object neList = null;
        rsp.result.isSuccess = true;
        rsp.result.setRetCode(0);
        neList = 0 == neID ? TEMarineLinePubFun.getNeList() : asnNeIdList;
        int len = neList.size();
        for (int i = 0; i < len; ++i) {
            neID = neList.get(i);
            lineStateList.clear();
            retCode = this.getLineState(neID, lineStateList, userID, info);
            rsp.lineStateList.addAll(lineStateList);
            if (0 == retCode) continue;
            errorInfo = new AsnMarineLineStateErr();
            errorInfo.neID = BigInteger.valueOf(neID);
            errorInfo.errorCode = BigInteger.valueOf(retCode);
            rsp.detailRet.add((Object)errorInfo);
        }
        int neIDNum = neList.size();
        this.constructErrInfo(rsp, neIDNum);
        return 0;
    }

    private int getLineState(int neID, List<AsnMarineLineState> lineStateList, String userID, TETaskInfo info) {
        Datainterface neReq = this.constructGetStateData(neID);
        SubFunc subFunc = TESLMTestUtil.getSubFunc(neID, 2555990);
        TENEExplorerBean bean = new TENEExplorerBean();
        Datainterface neRsp = bean.performBussinessProcess(neID, subFunc, neReq, null, userID, TopoUtility.ipToString((long)info.getMsgHead().senderProcIP));
        this.constructAsnLineStateList(neID, neRsp, lineStateList);
        return Integer.parseInt(neRsp.getErrorMessage().getErrorcode());
    }

    private Datainterface constructGetStateData(int neID) {
        Datainterface data = new Datainterface();
        BussinessParams bus = new BussinessParams();
        data.setBussinessParams(bus);
        RowParams rp = new RowParams();
        Param param = new Param("neid", String.valueOf(neID));
        rp.addParam(param);
        param = new Param("lineID", String.valueOf(0));
        rp.addParam(param);
        bus.addRowParams(rp);
        return data;
    }

    private void constructAsnLineStateList(int neID, Datainterface neRsp, List<AsnMarineLineState> lineStateList) {
        AsnMarineLineState asnLineState = null;
        BussinessParams bus = neRsp.getBussinessParams();
        if (null != bus) {
            RowParams[] rows;
            for (RowParams row : rows = bus.getRowParams()) {
                asnLineState = this.convertRowData(neID, row);
                if (null == asnLineState) continue;
                lineStateList.add(asnLineState);
            }
        }
    }

    private AsnMarineLineState convertRowData(int neID, RowParams row) {
        try {
            AsnMarineLineState asnLineState = new AsnMarineLineState();
            int lineID = Integer.parseInt(row.getParam("lineID").getValue());
            int testMode = Integer.parseInt(row.getParam("testMode").getValue());
            int testType = Integer.parseInt(row.getParam("testType").getValue());
            int testState = Integer.parseInt(row.getParam("currentWorkStatus").getValue());
            int abortErrorCode = Integer.parseInt(row.getParam("abortErrorCode").getValue());
            asnLineState.neID = BigInteger.valueOf(neID);
            asnLineState.lineID = BigInteger.valueOf(lineID);
            asnLineState.testMode = BigInteger.valueOf(testMode);
            asnLineState.testType = BigInteger.valueOf(testType);
            asnLineState.testState = BigInteger.valueOf(testState);
            asnLineState.abortErrorCode = BigInteger.valueOf(abortErrorCode);
            asnLineState.midResultState = BigInteger.ZERO;
            this.convertRowTimeInfo(neID, row, asnLineState);
            return asnLineState;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void convertRowTimeInfo(int neID, RowParams row, AsnMarineLineState asnLineState) {
        TimeZoneDateBean timezonebean = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neID);
        String stringValue = row.getParam("startYear").getValue().trim();
        int startYear = Integer.parseInt(stringValue);
        int currentWorkStatus = Integer.parseInt(row.getParam("currentWorkStatus").getValue());
        if (this.isNETimeValid(neID, currentWorkStatus, startYear += timezonebean.nebaseyear)) {
            AsnDateTimeType curDT = new AsnDateTimeType();
            curDT.year = -1;
            curDT.month = 1;
            curDT.day = 1;
            curDT.hour = 1;
            curDT.minute = 1;
            curDT.second = 1;
            asnLineState.startTime = curDT;
            asnLineState.timeToEnd = "-".getBytes();
            asnLineState.testProgress = BigInteger.ZERO;
        } else {
            stringValue = row.getParam("startMonth").getValue().trim();
            int startMonth = Integer.parseInt(stringValue);
            stringValue = row.getParam("startDay").getValue().trim();
            int startDay = Integer.parseInt(stringValue);
            stringValue = row.getParam("startHour").getValue().trim();
            int startHour = Integer.parseInt(stringValue);
            stringValue = row.getParam("startMinute").getValue().trim();
            int startMinute = Integer.parseInt(stringValue);
            stringValue = "1";
            int startSecond = Integer.parseInt(stringValue);
            String remainTime = row.getParam("remainTime").getValue().trim();
            int testProgress = Integer.parseInt(row.getParam("progress").getValue());
            AsnDateTimeType curDT = new AsnDateTimeType();
            curDT.year = startYear;
            curDT.month = startMonth;
            curDT.day = startDay;
            curDT.hour = startHour;
            curDT.minute = startMinute;
            curDT.second = startSecond;
            asnLineState.startTime = curDT;
            asnLineState.timeToEnd = remainTime.getBytes();
            asnLineState.testProgress = BigInteger.valueOf(testProgress);
        }
    }

    private boolean isNETimeValid(int neID, int currentWorkStatus, int startYear) {
        TimeZoneDateBean timezonebean = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neID);
        boolean isValid = currentWorkStatus != 2 || startYear == 48 + timezonebean.nebaseyear || startYear == timezonebean.nebaseyear;
        return isValid;
    }

    private void constructErrInfo(AsnMarineQueryLineStateRsp rsp, int neIDNum) {
        int errorNum = rsp.detailRet.size();
        if (0 == errorNum || 0 == neIDNum) {
            rsp.result.isSuccess = true;
            rsp.result.retCode = BigInteger.valueOf(0L);
        } else if (neIDNum == errorNum) {
            rsp.result.isSuccess = false;
            rsp.result.retCode = BigInteger.valueOf(2L);
        } else {
            rsp.result.isSuccess = false;
            rsp.result.retCode = BigInteger.valueOf(1L);
        }
    }
}

