/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.faultlocatedemo;

import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.core.mdp.TEASN1CommMgr;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnSingleReturn;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnFaultLocationDemo;
import com.huawei.nglct.nemgr.marine.e2e.faultlocatedemo.TEFaultDemoInfo;
import com.huawei.nglct.nemgr.marine.e2e.faultlocatedemo.TEFaultLocateDemoInterval;
import com.huawei.nglct.nemgr.marine.e2e.faultlocatedemo.TEFaultLocateDemoNoticeHandler;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineE2EUtil;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineEngInfoDaoService;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineStationGetter;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEQuickFaultDaoService;
import com.huawei.nglct.nemgr.marine.e2ecommon.longlatcalculor.GeographicCoordinate;
import com.huawei.nglct.nemgr.marine.e2ecommon.longlatcalculor.Latitude;
import com.huawei.nglct.nemgr.marine.e2ecommon.longlatcalculor.Longitude;
import com.huawei.nglct.nemgr.marine.e2ecommon.longlatcalculor.PositionCalculator;
import com.huawei.nglct.po.embeddednemgrmo.marine.TELineDevicePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineEngineerInfoDetailPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineEngineerInfoPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineQuickFaultAttributePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineQuickFaultConfPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineQuickFaultInfoPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TESLMLinePO;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.io.FileNotFoundException;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.commustru.fstru.FStruct;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.slf4j.Logger;

public class TEFaultLocateDemoManager {
    private static TEFaultLocateDemoManager instance;
    private static final String EVT_DES_PATH;
    private static final String NSEVT_SLM_START_FLTLOCA_DEMONSTRATION = "NSEVT_SLM_START_FLTLOCA_DEMONSTRATION";
    public static final int START_RUN_FLAG = 1;
    private static final int DEMO_PURSUANTNEID = -1;
    private static final Logger log;
    private TEFaultLocateDemoNoticeHandler handler = new TEFaultLocateDemoNoticeHandler();
    private boolean isSuspending = false;
    private ScheduledExecutorService scheduledExecutor;

    private TEFaultLocateDemoManager() {
    }

    public static synchronized TEFaultLocateDemoManager getInstance() {
        if (instance == null) {
            instance = new TEFaultLocateDemoManager();
        }
        return instance;
    }

    public void registerNoticeHandler() {
        try {
            Definitions definitions = TECreateObjectFactory.parseQxDesFile(null, (String)EVT_DES_PATH);
            Operation operation = definitions.getOperation(NSEVT_SLM_START_FLTLOCA_DEMONSTRATION);
            if (operation != null) {
                TENECommMgr.getInstance().registerListener(operation, (NoticeHandler)this.handler);
            }
        }
        catch (MarshalException e) {
            log.error("TEFaultLocateDemoManager.registerNoticeHandler() Failed: MarshalException", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            log.error("TEFaultLocateDemoManager.registerNoticeHandler() Failed: FileNotFoundException", (Throwable)e);
        }
        catch (ValidationException e) {
            log.error("TEFaultLocateDemoManager.registerNoticeHandler() Failed: ValidationException", (Throwable)e);
        }
    }

    public void setStart(boolean isStart) {
        if (!isStart) {
            this.shutdownSuspending();
        }
    }

    private void shutdownSuspending() {
        this.isSuspending = false;
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdownNow();
            try {
                this.scheduledExecutor.awaitTermination(0L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.error("TEFaultLocateDemoManager.shutdownSuspending() Failed: InterruptedException");
            }
            this.scheduledExecutor = null;
        }
    }

    public void unregisterNoticeHander() {
        try {
            Definitions definitions = TECreateObjectFactory.parseQxDesFile(null, (String)EVT_DES_PATH);
            Operation operation = definitions.getOperation(NSEVT_SLM_START_FLTLOCA_DEMONSTRATION);
            if (operation != null) {
                TENECommMgr.getInstance().unregisterListener(operation, (NoticeHandler)this.handler);
            }
        }
        catch (MarshalException e) {
            log.error("TEFaultLocateDemoManager.unregisterNoticeHander() Failed: MarshalException");
        }
        catch (FileNotFoundException e) {
            log.error("TEFaultLocateDemoManager.unregisterNoticeHander() Failed: FileNotFoundException");
        }
        catch (ValidationException e) {
            log.error("TEFaultLocateDemoManager.unregisterNoticeHander() Failed: ValidationException");
        }
    }

    public void locateFault(TEFaultDemoInfo faultInfo) {
        int runFlag = this.getQuickFaultRunFlag();
        if (runFlag != 1) {
            log.info("Marine Fast Fault Location Demo: Fast fault location doesn't start, so the fault information will not be processed.");
            return;
        }
        if (this.isSuspending) {
            log.info("Marine Fast Fault Location Demo: Last marine fault location has been successfully completed within the 12 hours, so the fault information will not be processed.");
            return;
        }
        log.info("Marine Fast Fault Location Demo: begin marine fault locate----faultInfo: " + faultInfo);
        AsnFaultLocationDemo message = this.createMessage();
        StringBuffer oprationLog = new StringBuffer();
        TEFaultLocateDemoInterval interval = this.findFaultInterval(faultInfo, message.result);
        if (message.result.isSuccess) {
            log.info("Marine Fast Fault Location Demo: calculate the location of fault.");
            GeographicCoordinate faultCoordinate = this.calculateFaultCoordinate(interval);
            log.info("Marine Fast Fault Location Demo: save fault location information.");
            String stationName = interval.getSrcStation().getName();
            int distance = faultInfo.getDistance();
            String latitude = faultCoordinate.getLatitude().toString();
            String longitude = faultCoordinate.getLongitude().toString();
            TEResourceUtil res = TEMarineE2EUtil.getQuickFaultResourceUtil();
            String neName = TENEListMgr.getInstance().getNE(faultInfo.getNeID()).getNEName();
            oprationLog.append(res.getString("fault_locate_demo")).append(". ").append(res.getString("NE_ID")).append(":").append(neName).append(";").append(res.getString("LINE_ID")).append(":").append(faultInfo.getLineID()).append(";").append(res.getString("fault_type")).append(":").append(faultInfo.getFaultType()).append(";").append(res.getString("fault_station")).append(":").append(stationName).append(";").append(res.getString("fault_distance")).append(":").append(distance).append("km;").append(res.getString("fault_latitude")).append(":").append(latitude).append(";").append(res.getString("fault_longitude")).append(":").append(longitude).append(";");
            TEMarineQuickFaultInfoPO quickFaultInfo = this.createQuickFaultInfo(stationName, -1L, distance, latitude, longitude);
            int resultCode = TEQuickFaultDaoService.getInstance().saveQuickFaultInfoWithUser(quickFaultInfo);
            if (resultCode == 0) {
                log.info("Marine Fast Fault Location Demo: send fault location SMS to users");
                this.sendSMS(faultInfo.getNeID(), stationName, distance, latitude, longitude);
                this.setResultCode(message.result, 0);
                this.assembleMessage(message, faultInfo, interval.getSrcStation().getStationID(), faultCoordinate);
            } else {
                this.setResultCode(message.result, 1090615256);
            }
        }
        log.info("Marine Fast Fault Location Demo: send fault location result to client.");
        TEASN1CommMgr.sendEventClient((FStruct)message, (int)2180307);
        this.writeOperationLog(oprationLog.toString(), message.result.getRetCode());
        this.isSuspending = message.result.isSuccess;
        if (this.isSuspending) {
            log.info("Marine Fast Fault Location Demo: The fault location is successfully completed. The next fault must wait at least 12 hours.");
            this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
            this.scheduledExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    TEFaultLocateDemoManager.this.isSuspending = false;
                }
            }, 12L, TimeUnit.HOURS);
        }
        log.info("end marine fault locate----message: " + TEAsn1Util.getAsn1String((Object)message));
    }

    private void sendSMS(int neid, String stationName, int distance, String latitude, String longitude) {
        TEResourceUtil res = TEMarineE2EUtil.getQuickFaultResourceUtil();
        long faultTime = System.currentTimeMillis();
        String faultArea = MessageFormat.format(res.getString("fault_area"), stationName, distance, latitude, longitude);
        StringBuilder contentStr = new StringBuilder();
        String formatTime = TEMarineE2EUtil.formatTimeInServer(faultTime);
        contentStr.append(res.getString("fault_locate_info")).append("\n\r");
        contentStr.append(res.getString("fault_time")).append(formatTime).append("\n\r");
        contentStr.append(res.getString("fault_address")).append(faultArea).append("\n\r");
        contentStr.append(res.getString("fault_dispose"));
        TEMarineE2EUtil.sendQFMessageToC_Mgr(neid, contentStr.toString());
    }

    private AsnFaultLocationDemo createMessage() {
        AsnFaultLocationDemo message = new AsnFaultLocationDemo();
        message.result.isSuccess = true;
        message.distance = BigInteger.valueOf(0L);
        message.faultType = BigInteger.valueOf(0L);
        message.neID = BigInteger.valueOf(0L);
        message.stationID = BigInteger.valueOf(0L);
        message.latitude = "".getBytes();
        message.longitude = "".getBytes();
        return message;
    }

    private TEFaultLocateDemoInterval findFaultInterval(TEFaultDemoInfo faultInfo, AsnSingleReturn result) {
        TESLMLinePO line = this.getMarineLine(faultInfo);
        if (line == null) {
            log.error("Marine Fast Fault Location Demo(Error): Did not find fault line.");
            this.setResultCode(result, 1090615255);
            return null;
        }
        log.error("Marine Fast Fault Location Demo: begin find engineer information.");
        ArrayList<TEMarineEngineerInfoPO> enginfos = new ArrayList<TEMarineEngineerInfoPO>();
        TEMarineEngInfoDaoService.getInstance().findAllEngInfo(enginfos);
        if (enginfos.isEmpty()) {
            log.error("Marine Fast Fault Location Demo(Error): Can not find any engineer information in U2000.");
            this.setResultCode(result, 1090615237);
            return null;
        }
        return this.findFaultIntervalFromEngInfo(line, enginfos, faultInfo, result);
    }

    private TEFaultLocateDemoInterval findFaultIntervalFromEngInfo(TESLMLinePO line, Collection<TEMarineEngineerInfoPO> enginfos, TEFaultDemoInfo faultInfo, AsnSingleReturn result) {
        List<Integer> neList;
        log.error("Marine Fast Fault Location Demo: begin find station.");
        TEMarineStationGetter stationGetter = new TEMarineStationGetter();
        TEMarineStationPO srcStation = stationGetter.getStationByNeID((int)line.getNeID());
        TEMarineStationPO sinkStation = stationGetter.getStationByNeID((int)line.getOppositeNEID());
        if (srcStation == null) {
            log.error("Marine Fast Fault Location Demo(Error): Did not find fault source station.");
            this.setResultCode(result, 1090615234);
            return null;
        }
        log.error("Marine Fast Fault Location Demo: check pfe and 1600s in station.");
        if ((faultInfo.getFaultType() == 1 || faultInfo.getFaultType() == 2) && (neList = stationGetter.getNEsFromStationByType(srcStation, 72)).isEmpty()) {
            log.error("Marine Fast Fault Location Demo(Error): Did not find PFE in fault source station.");
            this.setResultCode(result, 1090615265);
            return null;
        }
        if ((faultInfo.getFaultType() == 3 || faultInfo.getFaultType() == 4) && (neList = stationGetter.getNEsFromStationByType(srcStation, 56)).isEmpty()) {
            log.error("Marine Fast Fault Location Demo(Error): Did not find BWS 1600S in fault source station.");
            this.setResultCode(result, 1090615266);
            return null;
        }
        log.error("Marine Fast Fault Location Demo: get bus from marine line.");
        List<String> buEvents = this.getBUEventsSortedBySpan(line);
        log.error("Marine Fast Fault Location Demo: begin find fault interval in engineer information.");
        double remainingDistance = faultInfo.getDistance();
        if (!buEvents.isEmpty()) {
            TEFaultLocateDemoInterval fistInterval = this.findIntervalFromStaionToBU(srcStation.getName(), buEvents.get(0), enginfos);
            if (fistInterval == null) {
                log.error("Marine Fast Fault Location Demo(Error): Can not find first interval in engineer information.");
                this.setResultCode(result, 1090615238);
                return null;
            }
            fistInterval.setSrcStation(srcStation);
            fistInterval.setSinkStation(sinkStation);
            if (fistInterval.calculateIntervalDistance(remainingDistance)) {
                return fistInterval;
            }
            remainingDistance -= fistInterval.getIntervalDistance();
            for (int i = 1; i < buEvents.size(); ++i) {
                TEFaultLocateDemoInterval buInterval = this.findBUInterval(buEvents.get(i - 1), buEvents.get(i), enginfos);
                if (buInterval == null) {
                    log.error("Marine Fast Fault Location Demo(Error): Can not find BU interval in engineer information.");
                    this.setResultCode(result, 1090615238);
                    return null;
                }
                buInterval.setSrcStation(srcStation);
                buInterval.setSinkStation(sinkStation);
                if (buInterval.calculateIntervalDistance(remainingDistance)) {
                    return buInterval;
                }
                remainingDistance -= buInterval.getIntervalDistance();
            }
            if (sinkStation != null) {
                TEFaultLocateDemoInterval lastInterval = this.findIntervalFromBUToStation(buEvents.get(buEvents.size() - 1), sinkStation.getName(), enginfos);
                if (lastInterval == null) {
                    log.error("Marine Fast Fault Location Demo(Error): Can not find last interval in engineer information.");
                    this.setResultCode(result, 1090615238);
                    return null;
                }
                lastInterval.setSrcStation(srcStation);
                lastInterval.setSinkStation(sinkStation);
                if (lastInterval.calculateIntervalDistance(remainingDistance)) {
                    return lastInterval;
                }
            }
        } else if (sinkStation != null) {
            TEFaultLocateDemoInterval interval = this.findNoBUInterval(srcStation.getName(), sinkStation.getName(), enginfos);
            if (interval == null) {
                log.error("Marine Fast Fault Location Demo(Error): Can not find interval between stations in engineer information.");
                this.setResultCode(result, 1090615238);
                return null;
            }
            interval.setSrcStation(srcStation);
            interval.setSinkStation(sinkStation);
            if (interval.calculateIntervalDistance(remainingDistance)) {
                return interval;
            }
        }
        log.error("Marine Fast Fault Location Demo(Error): Can not find any interval in engineer information.");
        this.setResultCode(result, 1090615238);
        return null;
    }

    private TEFaultLocateDemoInterval findNoBUInterval(String srcStationName, String sinkStaionName, Collection<TEMarineEngineerInfoPO> enginfos) {
        for (TEMarineEngineerInfoPO enginfo : enginfos) {
            TEFaultLocateDemoInterval interval = new TEFaultLocateDemoInterval();
            List events = enginfo.getSortedDetailList();
            if (((TEMarineEngineerInfoDetailPO)events.get(0)).getEvtType() != 1 || ((TEMarineEngineerInfoDetailPO)events.get(events.size() - 1)).getEvtType() != 1) continue;
            if (enginfo.getSrc().toLowerCase().contains(srcStationName.toLowerCase()) && enginfo.getSink().toLowerCase().contains(sinkStaionName.toLowerCase())) {
                interval.setEvents(events);
                return interval;
            }
            if (!enginfo.getSink().toLowerCase().contains(srcStationName.toLowerCase()) || !enginfo.getSrc().toLowerCase().contains(sinkStaionName.toLowerCase())) continue;
            interval.setReverseEvents(events);
            return interval;
        }
        return null;
    }

    private TEFaultLocateDemoInterval findBUInterval(String srcBUEvent, String sinkBUEvent, Collection<TEMarineEngineerInfoPO> enginfos) {
        for (TEMarineEngineerInfoPO enginfo : enginfos) {
            TEFaultLocateDemoInterval interval = new TEFaultLocateDemoInterval();
            List events = enginfo.getSortedDetailList();
            int srcIndex = -1;
            int sinkIndex = -1;
            int length = events.size();
            for (int i = 0; i < length; ++i) {
                TEMarineEngineerInfoDetailPO event = (TEMarineEngineerInfoDetailPO)events.get(i);
                if (event.getEvtType() == 2 && event.getEvent().toLowerCase().contains(srcBUEvent.toLowerCase())) {
                    srcIndex = i;
                }
                if (event.getEvtType() == 2 && event.getEvent().toLowerCase().contains(sinkBUEvent.toLowerCase())) {
                    sinkIndex = i;
                }
                if (srcIndex == -1 || sinkIndex == -1) continue;
                if (srcIndex < sinkIndex) {
                    interval.setEvents(events.subList(srcIndex, sinkIndex + 1));
                } else {
                    interval.setReverseEvents(events.subList(sinkIndex, srcIndex + 1));
                }
                return interval;
            }
        }
        return null;
    }

    private TEFaultLocateDemoInterval findIntervalFromStaionToBU(String stationName, String buName, Collection<TEMarineEngineerInfoPO> enginfos) {
        for (TEMarineEngineerInfoPO enginfo : enginfos) {
            TEMarineEngineerInfoDetailPO event;
            TEFaultLocateDemoInterval interval = new TEFaultLocateDemoInterval();
            List events = enginfo.getSortedDetailList();
            if (((TEMarineEngineerInfoDetailPO)events.get(0)).getEvtType() == 1 && enginfo.getSrc().toLowerCase().contains(stationName.toLowerCase())) {
                interval.appendEvent((TEMarineEngineerInfoDetailPO)events.get(0));
                int length = events.size();
                for (int i = 1; i < length; ++i) {
                    event = (TEMarineEngineerInfoDetailPO)events.get(i);
                    interval.appendEvent(event);
                    if (event.getEvtType() != 2 || !event.getEvent().toLowerCase().contains(buName.toLowerCase())) continue;
                    return interval;
                }
                continue;
            }
            if (((TEMarineEngineerInfoDetailPO)events.get(events.size() - 1)).getEvtType() != 1 || !enginfo.getSink().toLowerCase().contains(stationName.toLowerCase())) continue;
            int length = events.size();
            interval.appendEvent((TEMarineEngineerInfoDetailPO)events.get(length - 1));
            for (int i = length - 2; i >= 0; --i) {
                event = (TEMarineEngineerInfoDetailPO)events.get(i);
                interval.appendEvent(event);
                if (event.getEvtType() != 2 || !event.getEvent().toLowerCase().contains(buName.toLowerCase())) continue;
                return interval;
            }
        }
        return null;
    }

    private TEFaultLocateDemoInterval findIntervalFromBUToStation(String buName, String stationName, Collection<TEMarineEngineerInfoPO> enginfos) {
        for (TEMarineEngineerInfoPO enginfo : enginfos) {
            TEMarineEngineerInfoDetailPO event;
            TEFaultLocateDemoInterval interval = new TEFaultLocateDemoInterval();
            List events = enginfo.getSortedDetailList();
            if (((TEMarineEngineerInfoDetailPO)events.get(0)).getEvtType() == 1 && enginfo.getSrc().toLowerCase().contains(stationName.toLowerCase())) {
                interval.insertEventFirst((TEMarineEngineerInfoDetailPO)events.get(0));
                int length = events.size();
                for (int i = 1; i < length; ++i) {
                    event = (TEMarineEngineerInfoDetailPO)events.get(i);
                    interval.insertEventFirst(event);
                    if (event.getEvtType() != 2 || !event.getEvent().toLowerCase().contains(buName.toLowerCase())) continue;
                    return interval;
                }
            }
            if (((TEMarineEngineerInfoDetailPO)events.get(events.size() - 1)).getEvtType() != 1 || !enginfo.getSink().toLowerCase().contains(stationName.toLowerCase())) continue;
            int length = events.size();
            interval.insertEventFirst((TEMarineEngineerInfoDetailPO)events.get(length - 1));
            for (int i = length - 2; i >= 0; --i) {
                event = (TEMarineEngineerInfoDetailPO)events.get(i);
                interval.insertEventFirst(event);
                if (event.getEvtType() != 2 || !event.getEvent().toLowerCase().contains(buName.toLowerCase())) continue;
                return interval;
            }
        }
        return null;
    }

    private GeographicCoordinate calculateFaultCoordinate(TEFaultLocateDemoInterval interval) {
        GeographicCoordinate srcCoordinate = this.getEventCoordinate(interval.getSrcEvent());
        GeographicCoordinate sinkCoordinate = this.getEventCoordinate(interval.getSinkEvent());
        return PositionCalculator.calcPointPosition(srcCoordinate, sinkCoordinate, interval.getDistance());
    }

    private GeographicCoordinate getEventCoordinate(TEMarineEngineerInfoDetailPO enginfoDetail) {
        Latitude srcLatitude = new Latitude(Math.abs(Integer.parseInt(enginfoDetail.getLatitudeDegree())), Math.abs(Double.parseDouble(enginfoDetail.getLatitudeMinute())), enginfoDetail.getLatitudeDirection().charAt(0));
        Longitude srcLongitude = new Longitude(Math.abs(Integer.parseInt(enginfoDetail.getLongitudeDegree())), Math.abs(Double.parseDouble(enginfoDetail.getLongitudeMinute())), enginfoDetail.getLongitudeDirection().charAt(0));
        GeographicCoordinate srcCoordinate = new GeographicCoordinate(srcLatitude, srcLongitude);
        return srcCoordinate;
    }

    private TEMarineQuickFaultInfoPO createQuickFaultInfo(String stationName, long pursuantNeID, int distance, String latitude, String longitude) {
        TEResourceUtil res = TEMarineE2EUtil.getQuickFaultResourceUtil();
        long faultTime = System.currentTimeMillis();
        String faultArea = MessageFormat.format(res.getString("fault_area"), stationName, distance, latitude, longitude);
        String theme = res.getString("fault_email_theme");
        StringBuilder contentStr = new StringBuilder();
        String formatTime = TEMarineE2EUtil.formatTimeInServer(faultTime);
        contentStr.append(res.getString("send_mail_date")).append(formatTime).append("\n\r");
        contentStr.append(res.getString("fault_mailtheme")).append(theme).append("\n\r");
        contentStr.append(res.getString("fault_locate_info")).append("\n\r");
        contentStr.append(res.getString("fault_time")).append(formatTime).append("\n\r");
        contentStr.append(res.getString("fault_address")).append(faultArea).append("\n\r");
        contentStr.append(res.getString("fault_dispose"));
        TEMarineQuickFaultInfoPO quickFaultInfo = new TEMarineQuickFaultInfoPO();
        quickFaultInfo.setDistance(distance);
        quickFaultInfo.setFaultTime(String.valueOf(faultTime));
        quickFaultInfo.setFaultArea(faultArea);
        quickFaultInfo.setLatitude(latitude);
        quickFaultInfo.setLongitude(longitude);
        quickFaultInfo.setTheme(theme);
        quickFaultInfo.setContent(contentStr.toString());
        quickFaultInfo.setPursuantNe(pursuantNeID);
        return quickFaultInfo;
    }

    private List<String> getBUEventsSortedBySpan(TESLMLinePO line) {
        boolean OADM_BU_TYPE = true;
        int PS_BU_TYPE = 2;
        ArrayList<TELineDevicePO> bus = new ArrayList<TELineDevicePO>(line.getDeviceList().size());
        for (TELineDevicePO device : line.getDeviceList()) {
            if (device.getDeviceType() != 1 && device.getDeviceType() != 2) continue;
            bus.add(device);
        }
        Collections.sort(bus, new Comparator<TELineDevicePO>(){

            @Override
            public int compare(TELineDevicePO o1, TELineDevicePO o2) {
                return o1.getSpanID() - o2.getSpanID();
            }
        });
        ArrayList<String> events = new ArrayList<String>(bus.size());
        for (TELineDevicePO bu : bus) {
            events.add(bu.getRemark());
        }
        return events;
    }

    private TESLMLinePO getMarineLine(TEFaultDemoInfo faultInfo) {
        log.error("Marine Fast Fault Location Demo: begin find fault line.");
        ArrayList<TESLMLinePO> lines = new ArrayList<TESLMLinePO>();
        int resultCode = TEQuickFaultDaoService.getInstance().findMarineLineByNeID(lines, faultInfo.getLineID(), faultInfo.getNeID());
        if (resultCode == 0 && lines.size() == 1) {
            return (TESLMLinePO)lines.iterator().next();
        }
        return null;
    }

    private void writeOperationLog(String oprateDesc, int resultCode) {
        TEResourceUtil res = TEMarineE2EUtil.getQuickFaultResourceUtil();
        ArrayList<TEMarineLogInfo> marineLogInfoList = new ArrayList<TEMarineLogInfo>();
        TEMarineLogInfo marineLogInfo = new TEMarineLogInfo();
        marineLogInfo.setCmdID(2180307);
        marineLogInfo.setOperateName(res.getString("fault_locate_demo"));
        marineLogInfo.setOperateObject(res.getString("fault_locate_demo"));
        marineLogInfo.setErrCode(resultCode);
        marineLogInfo.setResult(resultCode == 0 ? 0 : 2);
        if (resultCode == 0) {
            marineLogInfo.setOperateDesc(oprateDesc);
        } else {
            marineLogInfo.setOperateDesc("");
        }
        marineLogInfoList.add(marineLogInfo);
        TEMarineLogMgrUtil.writeLog(this.getQuickFaultUserID(), "127.0.0.1", marineLogInfoList);
    }

    private int getQuickFaultUserID() {
        TEDaoOperationResult dbresult = null;
        try {
            dbresult = TECommonDaoService.findAll(TEMarineQuickFaultConfPO.class);
            if (dbresult.getResult() == 0) {
                for (Object recode : dbresult.getData()) {
                    TEMarineQuickFaultConfPO conf = (TEMarineQuickFaultConfPO)recode;
                    for (TEMarineQuickFaultAttributePO attr : conf.getAttributeList()) {
                        if (!attr.getAttributeName().equals("user")) continue;
                        return attr.getAttributeValue();
                    }
                }
            } else {
                log.error("Can not find UserID for fault locate demo: DB operation error!");
            }
        }
        catch (Exception e) {
            log.error("Can not find UserID for fault locate demo: DB operation error!");
        }
        return 0;
    }

    private int getQuickFaultRunFlag() {
        TEDaoOperationResult dbresult = null;
        try {
            dbresult = TECommonDaoService.findAll(TEMarineQuickFaultConfPO.class);
            if (dbresult.getResult() == 0) {
                for (Object recode : dbresult.getData()) {
                    TEMarineQuickFaultConfPO conf = (TEMarineQuickFaultConfPO)recode;
                    for (TEMarineQuickFaultAttributePO attr : conf.getAttributeList()) {
                        if (!attr.getAttributeName().equals("runFlag")) continue;
                        return attr.getAttributeValue();
                    }
                }
            } else {
                log.error("Can not find UserID for fault locate demo: DB operation error!");
            }
        }
        catch (Exception e) {
            log.error("Can not find UserID for fault locate demo: DB operation error!");
        }
        return 0;
    }

    private void assembleMessage(AsnFaultLocationDemo asnDemo, TEFaultDemoInfo faultInfo, int stationID, GeographicCoordinate faultCoordinate) {
        asnDemo.distance = BigInteger.valueOf(faultInfo.getDistance());
        asnDemo.faultType = BigInteger.valueOf(faultInfo.getFaultType());
        asnDemo.neID = BigInteger.valueOf(faultInfo.getNeID());
        asnDemo.stationID = BigInteger.valueOf(stationID);
        asnDemo.latitude = faultCoordinate.getLatitude().toString().getBytes();
        asnDemo.longitude = faultCoordinate.getLongitude().toString().getBytes();
    }

    private void setResultCode(AsnSingleReturn result, int resultCode) {
        result.setRetCode(resultCode);
        result.isSuccess = resultCode == 0;
    }

    static {
        EVT_DES_PATH = "conf" + File.separator + "eventqxdescrib.xml";
        log = TELogFactory.getNormalLogger();
    }
}

