/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.enginfo;

import com.huawei.nglct.nemgr.f_interface.asncommon.AsnStrList;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineEngInfo;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineEngInfoDetail;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineEngInfoList;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineEngInfoDaoService;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineEngineerInfoDetailPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineEngineerInfoPO;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class TEMarineEngInfoMgrUtil {
    private TEMarineEngInfoMgrUtil() {
    }

    public static AsnMarineEngInfo createAsnEngInfoFromPO(TEMarineEngineerInfoPO engInfoPO) {
        AsnMarineEngInfo engInfoAsn = new AsnMarineEngInfo();
        engInfoAsn.infoID = BigInteger.valueOf(engInfoPO.getInfoID());
        engInfoAsn.name = engInfoPO.getName().getBytes();
        engInfoAsn.memo = engInfoPO.getMemo().getBytes();
        engInfoAsn.source = engInfoPO.getSrc().getBytes();
        engInfoAsn.sink = engInfoPO.getSink().getBytes();
        engInfoAsn.importUser = engInfoPO.getImportUser().getBytes();
        engInfoAsn.importTime = engInfoPO.getImportTime().getBytes();
        for (TEMarineEngineerInfoDetailPO item : engInfoPO.getDetailList()) {
            AsnMarineEngInfoDetail enginfoDetailAsn = TEMarineEngInfoMgrUtil.createAsnEngInfoDetailFromPO(item);
            engInfoAsn.detailList.add((Object)enginfoDetailAsn);
        }
        return engInfoAsn;
    }

    public static AsnMarineEngInfoDetail createAsnEngInfoDetailFromPO(TEMarineEngineerInfoDetailPO engInfoDetailPO) {
        AsnMarineEngInfoDetail engInfoDetailAsn = new AsnMarineEngInfoDetail();
        engInfoDetailAsn.posNo = BigInteger.valueOf(engInfoDetailPO.getPosNo());
        engInfoDetailAsn.event = engInfoDetailPO.getEvent().getBytes();
        engInfoDetailAsn.eventType = BigInteger.valueOf(engInfoDetailPO.getEvtType());
        engInfoDetailAsn.latitudeDegree = engInfoDetailPO.getLatitudeDegree().getBytes();
        engInfoDetailAsn.latitudeMinute = engInfoDetailPO.getLatitudeMinute().getBytes();
        engInfoDetailAsn.latitudeDirection = engInfoDetailPO.getLatitudeDirection().getBytes();
        engInfoDetailAsn.longitudeDegree = engInfoDetailPO.getLongitudeDegree().getBytes();
        engInfoDetailAsn.longitudeMinute = engInfoDetailPO.getLongitudeMinute().getBytes();
        engInfoDetailAsn.longitudeDirection = engInfoDetailPO.getLongitudeDirection().getBytes();
        engInfoDetailAsn.distance = engInfoDetailPO.getCmlDst().getBytes();
        engInfoDetailAsn.depth = engInfoDetailPO.getDepth().getBytes();
        engInfoDetailAsn.additionalFeatures = engInfoDetailPO.getAdditionalFeatures().getBytes();
        return engInfoDetailAsn;
    }

    public static TEMarineEngineerInfoPO createEngInfoPOFromAsn(AsnMarineEngInfo engInfoAsn) {
        TEMarineEngineerInfoPO engInfoPO = new TEMarineEngineerInfoPO();
        engInfoPO.setInfoID(engInfoAsn.infoID.intValue());
        engInfoPO.setName(new String(engInfoAsn.name));
        engInfoPO.setMemo(new String(engInfoAsn.memo));
        engInfoPO.setSrc(new String(engInfoAsn.source));
        engInfoPO.setSink(new String(engInfoAsn.sink));
        engInfoPO.setImportUser(new String(engInfoAsn.importUser));
        engInfoPO.setImportTime(new String(engInfoAsn.importTime));
        for (Object item : engInfoAsn.detailList) {
            engInfoPO.getDetailList().add(TEMarineEngInfoMgrUtil.createEngInfoDetailPOFromAsn((AsnMarineEngInfoDetail)item));
        }
        return engInfoPO;
    }

    public static TEMarineEngineerInfoDetailPO createEngInfoDetailPOFromAsn(AsnMarineEngInfoDetail engInfoDetailAsn) {
        TEMarineEngineerInfoDetailPO engInfoDetailPO = new TEMarineEngineerInfoDetailPO();
        engInfoDetailPO.setPosNo(engInfoDetailAsn.posNo.intValue());
        engInfoDetailPO.setEvent(new String(engInfoDetailAsn.event));
        engInfoDetailPO.setEvtType(engInfoDetailAsn.eventType.intValue());
        engInfoDetailPO.setLatitudeDegree(new String(engInfoDetailAsn.latitudeDegree));
        engInfoDetailPO.setLatitudeMinute(new String(engInfoDetailAsn.latitudeMinute));
        engInfoDetailPO.setLatitudeDirection(new String(engInfoDetailAsn.latitudeDirection));
        engInfoDetailPO.setLongitudeDegree(new String(engInfoDetailAsn.longitudeDegree));
        engInfoDetailPO.setLongitudeMinute(new String(engInfoDetailAsn.longitudeMinute));
        engInfoDetailPO.setLongitudeDirection(new String(engInfoDetailAsn.longitudeDirection));
        engInfoDetailPO.setCmlDst(new String(engInfoDetailAsn.distance));
        engInfoDetailPO.setDepth(new String(engInfoDetailAsn.depth));
        engInfoDetailPO.setAdditionalFeatures(new String(engInfoDetailAsn.additionalFeatures));
        return engInfoDetailPO;
    }

    public static List<TEMarineEngineerInfoPO> createEngInfoPOListFromAsn(AsnMarineEngInfoList engInfoAsnList) {
        ArrayList<TEMarineEngineerInfoPO> engInfoList = new ArrayList<TEMarineEngineerInfoPO>();
        for (Object item : engInfoAsnList) {
            engInfoList.add(TEMarineEngInfoMgrUtil.createEngInfoPOFromAsn((AsnMarineEngInfo)item));
        }
        return engInfoList;
    }

    public static String[] createErrorArgumentsFromAsn(AsnStrList asnStringList) {
        String[] result = null;
        if (asnStringList != null) {
            result = new String[asnStringList.size()];
            for (int i = 0; i < asnStringList.size(); ++i) {
                byte[] param = (byte[])asnStringList.get(i);
                result[i] = new String(param);
            }
        }
        return result;
    }

    public static int[] generateInfoIDs(int howmany) {
        int[] result = null;
        if (howmany > 0) {
            result = new int[howmany];
            ArrayList<TEMarineEngineerInfoPO> enginfos = new ArrayList<TEMarineEngineerInfoPO>(howmany);
            int resultCode = TEMarineEngInfoDaoService.getInstance().findAllEngInfo(enginfos);
            if (resultCode == 0) {
                HashSet<Integer> existedIds = new HashSet<Integer>();
                for (TEMarineEngineerInfoPO item : enginfos) {
                    existedIds.add(item.getInfoID());
                }
                block1: for (int i = 0; i < howmany; ++i) {
                    for (int id = 1; id < Integer.MAX_VALUE; ++id) {
                        if (existedIds.contains(id)) continue;
                        result[i] = id;
                        existedIds.add(id);
                        continue block1;
                    }
                }
            }
        }
        return result;
    }
}

