/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.enginfo;

import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnImportMarineEngInfoReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnImportMarineEngInfoRsp;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineEngInfo;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineEngInfoList;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineEngInfoLog;
import com.huawei.nglct.nemgr.marine.e2e.enginfo.TEAbstractMarineEngInfoHandler;
import com.huawei.nglct.nemgr.marine.e2e.enginfo.TEMarineEngInfoMgrConstants;
import com.huawei.nglct.nemgr.marine.e2e.enginfo.TEMarineEngInfoMgrUtil;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineEngInfoDaoService;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineEngineerInfoPO;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.commustru.fstru.FStruct;

public class TEImportMarineEngInfoHandler
extends TEAbstractMarineEngInfoHandler {
    @Override
    protected int handleRequest(FStruct req, FStruct rsp) {
        CharSequence operateDesc;
        AsnImportMarineEngInfoReq request = (AsnImportMarineEngInfoReq)req;
        AsnImportMarineEngInfoRsp response = (AsnImportMarineEngInfoRsp)rsp;
        this.setUserID(request.userID.intValue());
        String operateName = this.getOperateName();
        TEResourceUtil res = TEMarineEngInfoMgrConstants.RESOURCEUTIL;
        for (Object item : request.logList) {
            operateDesc = new StringBuilder();
            ((StringBuilder)operateDesc).append(operateName).append(". ");
            AsnMarineEngInfoLog log = (AsnMarineEngInfoLog)item;
            ((StringBuilder)operateDesc).append(res.getString("filename")).append(":").append(new String(log.operateObject)).append(".");
            this.addLogInfo(operateName, new String(log.operateObject), ((StringBuilder)operateDesc).toString(), log.errCode.intValue(), 2);
        }
        List<TEMarineEngineerInfoPO> engInfoList = TEMarineEngInfoMgrUtil.createEngInfoPOListFromAsn(request.engInfoList);
        String operateObject = this.getOperateObject(engInfoList);
        operateDesc = this.getOperateDesc(engInfoList);
        int resultCode = 0;
        response.result.isSuccess = true;
        response.result.setRetCode(resultCode);
        if (!engInfoList.isEmpty()) {
            int size = engInfoList.size();
            int[] ids = TEMarineEngInfoMgrUtil.generateInfoIDs(size);
            if (ids == null) {
                resultCode = 1092743443;
            } else {
                for (int i = 0; i < size; ++i) {
                    engInfoList.get(i).setInfoID(ids[i]);
                }
                resultCode = TEMarineEngInfoDaoService.getInstance().createEngInfos(engInfoList);
            }
            if (resultCode == 0) {
                AsnMarineEngInfoList engInfoAsnList = response.engInfoList;
                for (TEMarineEngineerInfoPO item : engInfoList) {
                    AsnMarineEngInfo enginfo = TEMarineEngInfoMgrUtil.createAsnEngInfoFromPO(item);
                    engInfoAsnList.add((Object)enginfo);
                }
                this.addLogInfo(operateName, operateObject, (String)operateDesc, resultCode, 0);
            } else {
                response.result.isSuccess = false;
                this.addLogInfo(operateName, operateObject, (String)operateDesc, resultCode, 2);
            }
            response.result.setRetCode(resultCode);
        }
        return resultCode;
    }

    private String getOperateName() {
        return TEMarineEngInfoMgrConstants.RESOURCEUTIL.getString("importenginfo");
    }

    private String getOperateObject(Collection<TEMarineEngineerInfoPO> enginfos) {
        StringBuilder result = new StringBuilder();
        Iterator<TEMarineEngineerInfoPO> iterator = enginfos.iterator();
        while (iterator.hasNext()) {
            TEMarineEngineerInfoPO item = iterator.next();
            result.append(item.getName());
            if (!iterator.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    private String getOperateDesc(Collection<TEMarineEngineerInfoPO> enginfos) {
        StringBuilder result = new StringBuilder();
        TEResourceUtil res = TEMarineEngInfoMgrConstants.RESOURCEUTIL;
        result.append(this.getOperateName()).append(". ");
        Locale local = Locale.getDefault();
        Calendar calendar = Calendar.getInstance(local);
        Iterator<TEMarineEngineerInfoPO> iterator = enginfos.iterator();
        while (iterator.hasNext()) {
            TEMarineEngineerInfoPO item = iterator.next();
            result.append(res.getString("filename")).append(":").append(item.getName()).append(";");
            result.append(res.getString("source")).append(":").append(item.getSrc()).append(";");
            result.append(res.getString("sink")).append(":").append(item.getSink()).append(";");
            result.append(res.getString("importuser")).append(":").append(item.getImportUser()).append(";");
            calendar.setTimeInMillis(Long.parseLong(item.getImportTime()));
            SimpleDateFormat formatter = new SimpleDateFormat(TETimeTocalizationSwitchBean.getDateFormat(), local);
            result.append(res.getString("importtime")).append(":").append(formatter.format(calendar.getTime()));
            if (iterator.hasNext()) {
                result.append(" ");
                continue;
            }
            result.append(". ");
        }
        return result.toString();
    }
}

