/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.enginfo;

import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnDelMarineEngInfoReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnDelMarineEngInfoRsp;
import com.huawei.nglct.nemgr.marine.e2e.enginfo.TEAbstractMarineEngInfoHandler;
import com.huawei.nglct.nemgr.marine.e2e.enginfo.TEMarineEngInfoMgrConstants;
import com.huawei.nglct.nemgr.marine.e2e.enginfo.TEMarineEngInfoMgrUtil;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineEngInfoDaoService;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineEngineerInfoPO;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.commustru.fstru.FStruct;

public class TEDelMarineEngInfoHandler
extends TEAbstractMarineEngInfoHandler {
    @Override
    protected int handleRequest(FStruct req, FStruct rsp) {
        AsnDelMarineEngInfoReq request = (AsnDelMarineEngInfoReq)req;
        AsnDelMarineEngInfoRsp response = (AsnDelMarineEngInfoRsp)rsp;
        this.setUserID(request.userID.intValue());
        List<TEMarineEngineerInfoPO> engInfoList = TEMarineEngInfoMgrUtil.createEngInfoPOListFromAsn(request.engInfoList);
        String operateName = this.getOperateName();
        String operateObject = this.getOperateObject(engInfoList);
        String operateDesc = this.getOperateDesc(engInfoList);
        HashSet<Integer> infoIDs = new HashSet<Integer>(engInfoList.size());
        for (TEMarineEngineerInfoPO enginfo : engInfoList) {
            infoIDs.add(enginfo.getInfoID());
        }
        int resultCode = TEMarineEngInfoDaoService.getInstance().deleteEngInfoByID(infoIDs);
        if (resultCode == 0) {
            response.result.isSuccess = true;
            this.addLogInfo(operateName, operateObject, operateDesc, resultCode, 0);
        } else {
            response.result.isSuccess = false;
            this.addLogInfo(operateName, operateObject, operateDesc, resultCode, 2);
        }
        response.result.setRetCode(resultCode);
        return resultCode;
    }

    private String getOperateName() {
        return TEMarineEngInfoMgrConstants.RESOURCEUTIL.getString("deleteenginfo");
    }

    private String getOperateObject(Collection<TEMarineEngineerInfoPO> enginfos) {
        StringBuilder result = new StringBuilder();
        Iterator<TEMarineEngineerInfoPO> iterator = enginfos.iterator();
        while (iterator.hasNext()) {
            TEMarineEngineerInfoPO item = iterator.next();
            result.append(item.getName());
            if (!iterator.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    private String getOperateDesc(Collection<TEMarineEngineerInfoPO> enginfos) {
        StringBuilder result = new StringBuilder();
        TEResourceUtil res = TEMarineEngInfoMgrConstants.RESOURCEUTIL;
        result.append(this.getOperateName()).append(". ");
        Locale local = Locale.getDefault();
        Calendar calendar = Calendar.getInstance(local);
        Iterator<TEMarineEngineerInfoPO> iterator = enginfos.iterator();
        while (iterator.hasNext()) {
            TEMarineEngineerInfoPO item = iterator.next();
            result.append(res.getString("filename")).append(":").append(item.getName()).append(";");
            result.append(res.getString("source")).append(":").append(item.getSrc()).append(";");
            result.append(res.getString("sink")).append(":").append(item.getSink()).append(";");
            result.append(res.getString("importuser")).append(":").append(item.getImportUser()).append(";");
            calendar.setTimeInMillis(Long.parseLong(item.getImportTime()));
            SimpleDateFormat formatter = new SimpleDateFormat(TETimeTocalizationSwitchBean.getDateFormat(), local);
            result.append(res.getString("importtime")).append(":").append(formatter.format(calendar.getTime()));
            if (iterator.hasNext()) {
                result.append(" ");
                continue;
            }
            result.append(". ");
        }
        return result.toString();
    }
}

