/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.enginfo;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public abstract class TEAbstractMarineEngInfoHandler {
    protected static Logger logger = TELogFactory.getNormalLogger();
    private List<TEMarineLogInfo> marineLogInfoList;
    private String ipAddress;
    private int cmdID;
    private int userID;

    public void setUserID(int userID) {
        this.userID = userID;
    }

    public int handleRequest(FStruct request, FStruct response, TaskMgr taskManger, TETaskInfo taskInfo) {
        logger.info(TEAsn1Util.getAsn1String((Object)request));
        this.ipAddress = TopoUtility.ipToString((long)taskInfo.getMsgHead().senderProcIP);
        this.cmdID = taskInfo.getMsgHead().cmdCode;
        this.marineLogInfoList = new ArrayList<TEMarineLogInfo>();
        int resultCode = this.handleRequest(request, response);
        if (resultCode == 0) {
            logger.info(TEAsn1Util.getAsn1String((Object)response));
        }
        TEMarineLogMgrUtil.writeLog(this.userID, this.ipAddress, this.marineLogInfoList);
        return resultCode;
    }

    protected abstract int handleRequest(FStruct var1, FStruct var2);

    protected void addLogInfo(String operateName, String operateObject, String operateDesc, int errCode, int result) {
        TEMarineLogInfo marineLogInfo = new TEMarineLogInfo();
        marineLogInfo.setCmdID(this.cmdID);
        marineLogInfo.setOperateName(operateName);
        marineLogInfo.setOperateObject(operateObject);
        marineLogInfo.setOperateDesc(operateDesc);
        marineLogInfo.setErrCode(errCode);
        marineLogInfo.setResult(result);
        this.marineLogInfoList.add(marineLogInfo);
    }
}

