/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.eleccablemgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nemgr.f_interface.eleccablemgr.AsnElecCableError;
import com.huawei.nglct.nemgr.f_interface.eleccablemgr.AsnElecCableErrorList;
import com.huawei.nglct.nemgr.f_interface.eleccablemgr.AsnMarineElecCable;
import com.huawei.nglct.nemgr.f_interface.eleccablemgr.AsnMarineElecCableList;
import com.huawei.nglct.nemgr.f_interface.eleccablemgr.AsnModifyMarineElecCableReq;
import com.huawei.nglct.nemgr.f_interface.eleccablemgr.AsnModifyMarineElecCableRsp;
import com.huawei.nglct.nemgr.marine.e2e.eleccablemgr.TEMarineElecCableUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineElecCablePO;
import java.math.BigInteger;
import org.slf4j.Logger;

public class TEModifyElecCableHandler {
    private static final Logger LOG = TELogFactory.getNormalLogger();

    public int handleRequest(AsnModifyMarineElecCableReq req, AsnModifyMarineElecCableRsp rsp, TaskMgr tm) {
        LOG.info(TEAsn1Util.getAsn1String((Object)req));
        AsnMarineElecCableList asnCableList = req.elecCableList;
        if (asnCableList.isEmpty()) {
            LOG.info("ElecCable: Modify null success!");
            return 0;
        }
        int modifyResult = -1;
        AsnElecCableErrorList cableErrorList = new AsnElecCableErrorList();
        AsnElecCableError cableError = null;
        AsnMarineElecCable asnElecCable = null;
        int len = asnCableList.size();
        for (int i = 0; i < len; ++i) {
            asnElecCable = (AsnMarineElecCable)asnCableList.get(i);
            modifyResult = this.modifyElecCableDB(asnElecCable);
            cableError = new AsnElecCableError();
            cableError.index = BigInteger.valueOf(i);
            cableError.result = BigInteger.valueOf(modifyResult);
            cableErrorList.add((Object)cableError);
        }
        int retCode = -1;
        int reqSize = asnCableList.size();
        int errorListSize = cableErrorList.size();
        retCode = 0 == errorListSize ? 0 : (errorListSize == reqSize ? 2 : 1);
        rsp.cableErrorList = cableErrorList;
        rsp.result.isSuccess = 0 == retCode;
        rsp.result.retCode = BigInteger.valueOf(retCode);
        LOG.info(TEAsn1Util.getAsn1String((Object)rsp));
        return retCode;
    }

    private int modifyElecCableDB(AsnMarineElecCable asnElecCable) {
        TEMarineElecCablePO cablePO = TEMarineElecCableUtil.asnCable2POCable(asnElecCable);
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.update((Object)cablePO);
        }
        catch (Exception e) {
            LOG.error("ElecCable: Modify elec cable error");
            return 1092743443;
        }
        if (null == dbResult) {
            LOG.error("ElecCable: The dbResult is null!");
            return 1092743443;
        }
        int retCode = dbResult.getResult();
        return retCode;
    }
}

