/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.eleccablemgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nemgr.f_interface.eleccablemgr.AsnGetMarineElecCableReq;
import com.huawei.nglct.nemgr.f_interface.eleccablemgr.AsnGetMarineElecCableRsp;
import com.huawei.nglct.nemgr.f_interface.eleccablemgr.AsnMarineElecCable;
import com.huawei.nglct.nemgr.f_interface.eleccablemgr.AsnMarineElecCableList;
import com.huawei.nglct.nemgr.marine.e2e.eleccablemgr.TEMarineElecCableUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineElecCablePO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEGetElecCableHandler {
    private static final Logger LOG = TELogFactory.getNormalLogger();
    private static final int GET_ALL_FLAG = 0;
    private static final String ELEC_CABLE_ID_STR = "ElecCableID";

    public int handleRequest(AsnGetMarineElecCableReq req, AsnGetMarineElecCableRsp rsp, TaskMgr tm) {
        LOG.info(TEAsn1Util.getAsn1String((Object)req));
        TEDaoOperationResult dbResult = null;
        try {
            int elecCableID = req.elecCableID.intValue();
            if (0 == elecCableID) {
                dbResult = TECommonDaoService.findAll(TEMarineElecCablePO.class);
            } else {
                ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
                TEDaoNameValuePair aPair = new TEDaoNameValuePair(ELEC_CABLE_ID_STR, String.valueOf(elecCableID));
                criteria.add(aPair);
                dbResult = TECommonDaoService.findByID(TEMarineElecCablePO.class, criteria);
            }
        }
        catch (Exception e) {
            LOG.error("ElecCable:Get elec cable error!", (Throwable)e);
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(1092743443);
            return 2;
        }
        if (null == dbResult) {
            LOG.error("The dbResult is null!");
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(1092743443);
            return 2;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            AsnMarineElecCableList asnStationList = rsp.elecCableList;
            AsnMarineElecCable asnCable = null;
            TEMarineElecCablePO cablePO = null;
            List data = dbResult.getData();
            for (Object obj : data) {
                cablePO = (TEMarineElecCablePO)obj;
                asnCable = TEMarineElecCableUtil.poCable2AsnCable(cablePO);
                asnStationList.add((Object)asnCable);
            }
            rsp.result.isSuccess = true;
            rsp.result.setRetCode(retCode);
        } else {
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(retCode);
        }
        LOG.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }
}

