/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.eleccablemgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnIntList;
import com.huawei.nglct.nemgr.f_interface.eleccablemgr.AsnDelMarineElecCableReq;
import com.huawei.nglct.nemgr.f_interface.eleccablemgr.AsnDelMarineElecCableRsp;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCablePO;
import java.util.ArrayList;
import org.slf4j.Logger;

public class TEDelElecCableHandler {
    private static final Logger LOG = TELogFactory.getNormalLogger();

    public int handleRequest(AsnDelMarineElecCableReq req, AsnDelMarineElecCableRsp rsp, TaskMgr tm) {
        LOG.info(TEAsn1Util.getAsn1String((Object)req));
        AsnIntList cableIDList = req.elecCableIDList;
        if (cableIDList.isEmpty()) {
            LOG.info("ElecCable: delete null success!");
            return 0;
        }
        ArrayList<TEDaoNameValuePair> deleteCriterion = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair aPair = null;
        int len = cableIDList.size();
        for (int i = 0; i < len; ++i) {
            aPair = new TEDaoNameValuePair("ElecCableID", String.valueOf(cableIDList.get(i)));
            deleteCriterion.add(aPair);
        }
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.deleteByID(TEMarineCablePO.class, deleteCriterion);
        }
        catch (Exception e) {
            LOG.error("ElecCable: Delete elec cable error!", (Throwable)e);
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(1092743443);
            return 2;
        }
        if (null == dbResult) {
            LOG.error("ElecCable:The dbResult is null!");
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(1092743443);
            return 2;
        }
        int retCode = dbResult.getResult();
        rsp.result.setRetCode(retCode);
        rsp.result.isSuccess = 0 == retCode;
        LOG.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }
}

