/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.eleccablemgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nemgr.f_interface.eleccablemgr.AsnCreateMarineElecCableReq;
import com.huawei.nglct.nemgr.f_interface.eleccablemgr.AsnCreateMarineElecCableRsp;
import com.huawei.nglct.nemgr.f_interface.eleccablemgr.AsnElecCableError;
import com.huawei.nglct.nemgr.f_interface.eleccablemgr.AsnElecCableErrorList;
import com.huawei.nglct.nemgr.f_interface.eleccablemgr.AsnMarineElecCable;
import com.huawei.nglct.nemgr.f_interface.eleccablemgr.AsnMarineElecCableList;
import com.huawei.nglct.nemgr.marine.e2e.eleccablemgr.TEMarineElecCableUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineElecCablePO;
import gnu.trove.TIntArrayList;
import java.math.BigInteger;
import java.util.List;
import org.slf4j.Logger;

public class TECreateElecCableHandler {
    private static final Logger LOG = TELogFactory.getNormalLogger();
    private static final int CABLE_ID_BEGIN = 1;
    private static final int CABLE_ID_END = 65535;
    private static final int CABLE_ID_INVALID = -1;

    public int handleRequest(AsnCreateMarineElecCableReq req, AsnCreateMarineElecCableRsp rsp, TaskMgr tm) {
        LOG.info(TEAsn1Util.getAsn1String((Object)req));
        AsnMarineElecCableList cableList = req.elecCableList;
        if (cableList.isEmpty()) {
            return 0;
        }
        int createResult = -1;
        AsnMarineElecCable asnElecCable = null;
        AsnElecCableErrorList cableErrorList = new AsnElecCableErrorList();
        AsnElecCableError elecCableError = null;
        int len = cableList.size();
        for (int i = 0; i < len; ++i) {
            asnElecCable = (AsnMarineElecCable)cableList.get(i);
            createResult = this.createElecCableToDB(asnElecCable);
            elecCableError = new AsnElecCableError();
            elecCableError.index = BigInteger.valueOf(i);
            elecCableError.result = BigInteger.valueOf(createResult);
            cableErrorList.add((Object)elecCableError);
        }
        int retCode = -1;
        int reqSize = cableList.size();
        int errorListSize = cableErrorList.size();
        retCode = 0 == errorListSize ? 0 : (errorListSize == reqSize ? 2 : 1);
        rsp.cableErrorList = cableErrorList;
        rsp.result.isSuccess = 0 == retCode;
        rsp.result.retCode = BigInteger.valueOf(retCode);
        LOG.info(TEAsn1Util.getAsn1String((Object)rsp));
        return retCode;
    }

    private int createElecCableToDB(AsnMarineElecCable asnElecCable) {
        NextCableID nextCableID = this.getNextCableID();
        if (0 != nextCableID.getResult()) {
            return nextCableID.getResult();
        }
        asnElecCable.elecCableID = BigInteger.valueOf(nextCableID.getCableID());
        TEMarineElecCablePO cablePO = TEMarineElecCableUtil.asnCable2POCable(asnElecCable);
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.create((Object)cablePO);
        }
        catch (Exception e) {
            LOG.error("ElecCable: Create cable error", (Throwable)e);
            return 1092743443;
        }
        if (null == dbResult) {
            LOG.error("ElecCable: The dbResult is null!");
            return 1092743443;
        }
        int retCode = dbResult.getResult();
        return retCode;
    }

    private NextCableID getNextCableID() {
        NextCableID nextCableID = new NextCableID();
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineElecCablePO.class);
        }
        catch (Exception e) {
            LOG.error("ElecCable: Get marine elec cable error", (Throwable)e);
            nextCableID.setResult(1092743443);
            return nextCableID;
        }
        if (null == dbResult) {
            LOG.error("ElecCable: The dbResult is null!");
            nextCableID.setResult(1092743443);
            return nextCableID;
        }
        TEMarineElecCablePO cablePO = null;
        int curCableID = -1;
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            LOG.error("ElecCable: The dbResult.getResult() is fail!");
            nextCableID.setResult(1092743443);
        } else {
            List data = dbResult.getData();
            TIntArrayList cableIDList = new TIntArrayList(data.size());
            for (Object obj : data) {
                cablePO = (TEMarineElecCablePO)obj;
                curCableID = cablePO.getElecCableID();
                cableIDList.add(curCableID);
            }
            int nextID = -1;
            for (int i = 1; i <= 65535; ++i) {
                if (-1 == cableIDList.indexOf(i)) continue;
                nextID = i;
                break;
            }
            if (-1 != nextID) {
                nextCableID.setCableID(nextID);
                nextCableID.setResult(0);
            } else {
                LOG.error("ElecCable: No available id!");
                nextCableID.setResult(2);
            }
        }
        return nextCableID;
    }

    static class NextCableID {
        private int cableID = 1;
        private int result = 2;

        NextCableID() {
        }

        public int getCableID() {
            return this.cableID;
        }

        public void setCableID(int cableID) {
            this.cableID = cableID;
        }

        public int getResult() {
            return this.result;
        }

        public void setResult(int result) {
            this.result = result;
        }
    }
}

