/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.ctbmgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineCTB;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnModifyMarineCTBReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnModifyMarineCTBRsp;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCTBPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEMarineModifyCTBHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private static int TECMDCODE_MODIFY_MARINE_CTB = 0x214112;

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm, TETaskInfo info) {
        normalLogger.info(TEAsn1Util.getAsn1String((Object)req));
        AsnModifyMarineCTBReq request = (AsnModifyMarineCTBReq)req;
        AsnModifyMarineCTBRsp response = (AsnModifyMarineCTBRsp)rsp;
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("ctbmgr").append(File.separator).append("ctbmgr_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)0, (StringBuffer)filePath);
        ArrayList<TEMarineLogInfo> marineLogInfoList = new ArrayList<TEMarineLogInfo>();
        TEMarineLogInfo marineLogInfo = new TEMarineLogInfo();
        marineLogInfo.setCmdID(TECMDCODE_MODIFY_MARINE_CTB);
        marineLogInfo.setOperateName(res.getString("slm_modify_ctb"));
        marineLogInfo.setOperateDesc(this.getDetailStr(request, res));
        marineLogInfo.setOperateObject(new String(request.ctbData.name));
        String ipAddress = TopoUtility.ipToString((long)info.getMsgHead().senderProcIP);
        int userID = request.userID.intValue();
        TEMarineCTBPO ctbPO = new TEMarineCTBPO();
        ctbPO.setName(new String(request.ctbData.name));
        ctbPO.setMemo(new String(request.ctbData.memo));
        ctbPO.setStationID(request.ctbData.stnID.intValue());
        ctbPO.setPosX(request.ctbData.posX.intValue());
        ctbPO.setPosY(request.ctbData.posY.intValue());
        TEMarineStationPO stationPO = this.getStationPO(ctbPO.getStationID());
        if (null == stationPO) {
            response.result.isSuccess = false;
            response.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        this.updateMarineCTBPOList(stationPO.CTBList, ctbPO);
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.update((Object)stationPO);
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
            response.result.isSuccess = false;
            response.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        if (null == dbResult) {
            normalLogger.error("The dbResult is null!");
            response.result.isSuccess = false;
            response.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            response.result.isSuccess = true;
            response.result.setRetCode(retCode);
            marineLogInfo.setErrCode(0);
            marineLogInfo.setResult(0);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
        } else {
            response.result.isSuccess = false;
            response.result.setRetCode(retCode);
            marineLogInfo.setErrCode(retCode);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
        }
        normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    private void updateMarineCTBPOList(Set<TEMarineCTBPO> CTBList, TEMarineCTBPO ctbPO) {
        String ctbName = ctbPO.getName();
        for (TEMarineCTBPO tmpCTBPOData : CTBList) {
            if (!ctbName.equals(tmpCTBPOData.Name)) continue;
            tmpCTBPOData.setMemo(ctbPO.getMemo());
            return;
        }
    }

    private TEMarineStationPO getStationPO(int ctbStnID) {
        TEMarineStationPO stationPO = null;
        TEMarineStationPO tmpPO = null;
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineStationPO.class);
            List data = dbResult.getData();
            for (Object obj : data) {
                tmpPO = (TEMarineStationPO)obj;
                int stnID = tmpPO.StationID;
                if (ctbStnID != stnID) continue;
                stationPO = tmpPO;
                return stationPO;
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEMarineModifyCTBHandler.getStationPO() fail!", (Throwable)e);
        }
        return null;
    }

    public String getDetailStr(AsnModifyMarineCTBReq req, TEResourceUtil res) {
        StringBuffer bf = new StringBuffer("");
        AsnMarineCTB ctb = req.ctbData;
        bf.append(res.getString("ctb_name_str")).append(':');
        bf.append(new String(ctb.name)).append(',');
        bf.append(res.getString("ctb_memo_str")).append(':');
        bf.append(new String(ctb.memo)).append(';');
        return bf.toString();
    }
}

