/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.ctbmgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnDeleteMarineCTBReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnDeleteMarineCTBRsp;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineCTB;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineCTBList;
import com.huawei.nglct.nemgr.marine.e2e.stationviewmgr.TEMarineStnViewNoticeMgr;
import com.huawei.nglct.nemgr.marine.e2e.stnelecable.TEMarineStnEleCblDBOper;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCTBPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStnEleCablePO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEMarineDeleteCTBHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private static final int TECMDCODE_DELETE_MARINE_CTB = 0x214111;
    private static final int NSERR_MARINE_CTB_IS_INUSE = 1090615305;

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm, TETaskInfo info) {
        AsnDeleteMarineCTBReq request = (AsnDeleteMarineCTBReq)req;
        AsnDeleteMarineCTBRsp response = (AsnDeleteMarineCTBRsp)rsp;
        StringBuffer filePath = new StringBuffer("");
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("ctbmgr").append(File.separator).append("ctbmgr_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)0, (StringBuffer)filePath);
        ArrayList<TEMarineLogInfo> marineLogInfoList = new ArrayList<TEMarineLogInfo>();
        TEMarineLogInfo marineLogInfo = new TEMarineLogInfo();
        marineLogInfo.setCmdID(0x214111);
        marineLogInfo.setOperateName(res.getString("slm_delete_ctb"));
        marineLogInfo.setOperateDesc(this.getDetailStr(request, res));
        marineLogInfo.setOperateObject(this.getObjectStr(request, res));
        String ipAddress = TopoUtility.ipToString((long)info.getMsgHead().senderProcIP);
        int userID = request.userID.intValue();
        AsnMarineCTBList ctbList = request.ctbList;
        if (request.ctbList.isEmpty()) {
            response.result.isSuccess = false;
            response.result.setRetCode(2);
            normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
            marineLogInfo.setErrCode(0);
            marineLogInfo.setResult(0);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        TEMarineStationPO stationPO = this.getStationPO(this.getStnID(request.ctbList));
        if (null == stationPO) {
            response.result.isSuccess = false;
            response.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        HashSet<String> canNotBeDelCTNLst = new HashSet<String>();
        int updateRetCode = this.updateMarineCTBPOList(stationPO.CTBList, ctbList, canNotBeDelCTNLst);
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.update((Object)stationPO);
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
            response.result.isSuccess = false;
            response.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        if (null == dbResult) {
            normalLogger.error("The dbResult is null!");
            response.result.isSuccess = false;
            response.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            if (0 == updateRetCode) {
                response.result.isSuccess = true;
                response.result.setRetCode(retCode);
                marineLogInfo.setErrCode(0);
                marineLogInfo.setResult(0);
                marineLogInfoList.add(marineLogInfo);
            } else {
                response.result.isSuccess = false;
                response.result.setRetCode(1090615305);
                marineLogInfo.setErrCode(1090615305);
                marineLogInfo.setResult(1090615305);
                marineLogInfo.setOperateDesc(this.getUsedCTBNameStr(canNotBeDelCTNLst));
                marineLogInfoList.add(marineLogInfo);
            }
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            this.noticeClientCTBDelHandler(this.getDelCtbList(request.ctbList, canNotBeDelCTNLst));
        } else {
            response.result.isSuccess = false;
            response.result.setRetCode(retCode);
            marineLogInfo.setErrCode(retCode);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
        }
        normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    private int getStnID(AsnMarineCTBList ctbList) {
        AsnMarineCTB tmpCTB = (AsnMarineCTB)ctbList.get(0);
        return tmpCTB.stnID.intValue();
    }

    private TEMarineStationPO getStationPO(int ctbStnID) {
        TEMarineStationPO stationPO = null;
        TEMarineStationPO tmpPO = null;
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineStationPO.class);
            List data = dbResult.getData();
            for (Object obj : data) {
                tmpPO = (TEMarineStationPO)obj;
                int stnID = tmpPO.StationID;
                if (ctbStnID != stnID) continue;
                stationPO = tmpPO;
                return stationPO;
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEMarineDeleteCTBHandler.getStationPO() fail!", (Throwable)e);
        }
        return null;
    }

    private int updateMarineCTBPOList(Set<TEMarineCTBPO> CTBList, AsnMarineCTBList ctbDataList, Set<String> canNotBeDelLst) {
        Set<String> usedCTBSet = this.getUsedCTB();
        int len = ctbDataList.size();
        for (int index = 0; index < len; ++index) {
            AsnMarineCTB asnCTBData = (AsnMarineCTB)ctbDataList.get(index);
            String ctbName = new String(asnCTBData.name);
            if (usedCTBSet.contains(ctbName)) {
                canNotBeDelLst.add(ctbName);
                continue;
            }
            this.delMarineCTBData(CTBList, ctbName);
        }
        return canNotBeDelLst.isEmpty() ? 0 : 1;
    }

    private Set<String> getUsedCTB() {
        ArrayList<TEMarineStnEleCablePO> eCableLst = new ArrayList<TEMarineStnEleCablePO>();
        int retCode = TEMarineStnEleCblDBOper.getInstance().getAllStnEleCbls(eCableLst);
        HashSet<String> usedCTBSet = new HashSet<String>();
        if (retCode == 0 && !eCableLst.isEmpty()) {
            for (TEMarineStnEleCablePO eCable : eCableLst) {
                if (0L == eCable.getSrcNEID()) {
                    usedCTBSet.add(eCable.getSrcNEName());
                    continue;
                }
                if (0L != eCable.getDstNEID()) continue;
                usedCTBSet.add(eCable.getDstNEName());
            }
        }
        return usedCTBSet;
    }

    private void delMarineCTBData(Set<TEMarineCTBPO> CTBList, String ctbName) {
        if (null == ctbName || 0 == ctbName.length()) {
            return;
        }
        Iterator<TEMarineCTBPO> iter = CTBList.iterator();
        while (iter.hasNext()) {
            TEMarineCTBPO ctbPOData = iter.next();
            if (!ctbName.equals(ctbPOData.Name)) continue;
            iter.remove();
            return;
        }
    }

    private void noticeClientCTBDelHandler(AsnMarineCTBList noticeCTBList) {
        if (null == noticeCTBList || 0 == noticeCTBList.size()) {
            return;
        }
        TEMarineStnViewNoticeMgr.sendCTBDeleteNoticeToClient(noticeCTBList);
    }

    public String getDetailStr(AsnDeleteMarineCTBReq req, TEResourceUtil res) {
        StringBuffer bf = new StringBuffer("");
        AsnMarineCTBList ctbList = req.ctbList;
        AsnMarineCTB ctb = null;
        int len = ctbList.size();
        for (int i = 0; i < len; ++i) {
            ctb = (AsnMarineCTB)ctbList.get(i);
            bf.append(res.getString("ctb_name_str")).append(':');
            bf.append(new String(ctb.name)).append(';');
        }
        return bf.toString();
    }

    public String getObjectStr(AsnDeleteMarineCTBReq req, TEResourceUtil res) {
        StringBuffer bf = new StringBuffer("");
        AsnMarineCTBList ctbList = req.ctbList;
        AsnMarineCTB ctb = null;
        if (ctbList.size() > 0) {
            ctb = (AsnMarineCTB)ctbList.get(0);
            bf.append(new String(ctb.name));
        }
        int len = ctbList.size();
        for (int i = 1; i < len; ++i) {
            ctb = (AsnMarineCTB)ctbList.get(i);
            bf.append(';');
            bf.append(new String(ctb.name));
        }
        return bf.toString();
    }

    private String getUsedCTBNameStr(Set<String> usedCTBSet) {
        StringBuffer bf = new StringBuffer("");
        Iterator<String> it = usedCTBSet.iterator();
        while (it.hasNext()) {
            bf.append(it.next());
            if (!it.hasNext()) continue;
            bf.append(";");
        }
        return bf.toString();
    }

    private AsnMarineCTBList getDelCtbList(AsnMarineCTBList asnCTBList, Set<String> cannotDelCtbSet) {
        if (null == cannotDelCtbSet || cannotDelCtbSet.isEmpty()) {
            return asnCTBList;
        }
        AsnMarineCTBList delCTBLst = new AsnMarineCTBList();
        int listLen = asnCTBList.size();
        for (int i = 0; i < listLen; ++i) {
            AsnMarineCTB asnCTB = (AsnMarineCTB)asnCTBList.get(i);
            if (cannotDelCtbSet.contains(new String(asnCTB.name))) continue;
            delCTBLst.add((Object)asnCTB);
        }
        return delCTBLst;
    }
}

