/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.ctbmgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnCreateMarineCTBReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnCreateMarineCTBRsp;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineCTB;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineCTBList;
import com.huawei.nglct.nemgr.marine.e2e.stationviewmgr.TEMarineStnViewNoticeMgr;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCTBPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEMarineCreateCTBHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private static final int OFFSET_POS = 40;
    private static int TECMDCODE_CREATE_MARINE_CTB = 2179319;

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm, TETaskInfo info) {
        AsnCreateMarineCTBReq cReq = (AsnCreateMarineCTBReq)req;
        AsnCreateMarineCTBRsp cRsp = (AsnCreateMarineCTBRsp)rsp;
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("ctbmgr").append(File.separator).append("ctbmgr_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)0, (StringBuffer)filePath);
        ArrayList<TEMarineLogInfo> marineLogInfoList = new ArrayList<TEMarineLogInfo>();
        TEMarineLogInfo marineLogInfo = new TEMarineLogInfo();
        marineLogInfo.setCmdID(TECMDCODE_CREATE_MARINE_CTB);
        marineLogInfo.setOperateName(res.getString("slm_create_ctb"));
        marineLogInfo.setOperateDesc(this.getDetailStr(cReq, res));
        marineLogInfo.setOperateObject(new String(cReq.ctbData.name));
        String ipAddress = TopoUtility.ipToString((long)info.getMsgHead().senderProcIP);
        int userID = cReq.userID.intValue();
        int ctbStnID = cReq.ctbData.stnID.intValue();
        String ctbName = new String(cReq.ctbData.name);
        TEMarineCTBPO ctbPO = new TEMarineCTBPO();
        ctbPO.setName(ctbName);
        ctbPO.setMemo(new String(cReq.ctbData.memo));
        ctbPO.setStationID(ctbStnID);
        TEMarineStationPO stationPO = null;
        TEMarineStationPO tmpPO = null;
        TEDaoOperationResult dbOperResult = null;
        int tmpRtn = 0;
        try {
            dbOperResult = TECommonDaoService.findAll(TEMarineStationPO.class);
            List data = dbOperResult.getData();
            tmpRtn = this.checkCTBByName(data, ctbName);
            this.updatePosOfNewCTB(cReq, data);
            ctbPO.setPosX(cReq.ctbData.posX.intValue());
            ctbPO.setPosY(cReq.ctbData.posY.intValue());
            if (0 != tmpRtn) {
                cRsp.result.isSuccess = false;
                cRsp.result.setRetCode(1090615086);
                marineLogInfo.setErrCode(1090615086);
                marineLogInfo.setResult(2);
                marineLogInfoList.add(marineLogInfo);
                TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
                return 2;
            }
            for (Object obj : data) {
                tmpPO = (TEMarineStationPO)obj;
                int stnID = tmpPO.StationID;
                if (ctbStnID != stnID) continue;
                stationPO = tmpPO;
            }
        }
        catch (Exception exception) {
            normalLogger.error(exception.toString());
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        if (null == stationPO) {
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        stationPO.CTBList.add(ctbPO);
        try {
            dbOperResult = TECommonDaoService.update(stationPO);
        }
        catch (Exception exception) {
            normalLogger.error(exception.toString());
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        if (null == dbOperResult) {
            normalLogger.error("The dbResult is null!");
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        int retCode = dbOperResult.getResult();
        if (0 == retCode) {
            cRsp.result.isSuccess = true;
            cRsp.result.setRetCode(retCode);
            marineLogInfo.setErrCode(0);
            marineLogInfo.setResult(0);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            AsnMarineCTBList ctbList = new AsnMarineCTBList();
            ctbList.add((Object)cReq.ctbData);
            TEMarineStnViewNoticeMgr.sendCTBCreateNoticeToClient(ctbList);
        } else {
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(retCode);
            marineLogInfo.setErrCode(retCode);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
        }
        return 0;
    }

    private void updatePosOfNewCTB(AsnCreateMarineCTBReq cReq, List<Object> dataList) {
        if (null == dataList || 0 == dataList.size()) {
            return;
        }
        TEMarineStationPO tmpPO = null;
        int stnID = cReq.ctbData.stnID.intValue();
        for (Object obj : dataList) {
            tmpPO = (TEMarineStationPO)obj;
            if (stnID != tmpPO.StationID) continue;
            this.updateCTBPos(cReq.ctbData, tmpPO.CTBList);
            break;
        }
    }

    private void updateCTBPos(AsnMarineCTB ctbReqData, Set<TEMarineCTBPO> CTBList) {
        if (null == CTBList || 0 == CTBList.size()) {
            return;
        }
        boolean hasSame = false;
        for (TEMarineCTBPO ctbPOData : CTBList) {
            if (ctbPOData.PosX != ctbReqData.posX.intValue() || ctbPOData.PosY != ctbReqData.posY.intValue()) continue;
            ctbReqData.posX = BigInteger.valueOf(40 + ctbReqData.posX.intValue());
            hasSame = true;
            break;
        }
        if (hasSame) {
            this.updateCTBPos(ctbReqData, CTBList);
        }
    }

    private int checkCTBByName(List<Object> dataList, String ctbName) {
        if (null == ctbName || 0 == ctbName.length()) {
            return 2;
        }
        if (null == dataList || 0 == dataList.size()) {
            return 0;
        }
        TEMarineStationPO tmpPO = null;
        for (Object obj : dataList) {
            tmpPO = (TEMarineStationPO)obj;
            if (!this.haveCTBData(tmpPO.CTBList, ctbName)) continue;
            return 1090615086;
        }
        return 0;
    }

    private boolean haveCTBData(Set<TEMarineCTBPO> ctbPOSet, String ctbName) {
        for (TEMarineCTBPO ctbPO : ctbPOSet) {
            if (!ctbName.equals(ctbPO.Name)) continue;
            return true;
        }
        return false;
    }

    public String getDetailStr(AsnCreateMarineCTBReq req, TEResourceUtil res) {
        StringBuffer bf = new StringBuffer("");
        AsnMarineCTB ctb = req.ctbData;
        bf.append(res.getString("ctb_name_str")).append(':');
        bf.append(new String(ctb.name)).append(',');
        bf.append(res.getString("ctb_memo_str")).append(':');
        bf.append(new String(ctb.memo)).append(';');
        return bf.toString();
    }
}

