/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockDevice;
import com.huawei.nglct.nemgr.marine.clockptp.TEQuerySyncAttriBean;
import com.huawei.nglct.nemgr.marine.e2e.clock.TEE2EGetClockDeviceUtil;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EAppendProcessor;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EPTPSpecialFor1800;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EQueryInnerClockSource;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import org.slf4j.Logger;

public final class TEE2EQuerySyncAttribute {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEE2EQuerySyncAttribute() {
    }

    public static TEErrInfoReturn queryClockSyncAttribute(int neID, TEE2EClockDevice device, boolean isSaveDB) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        TENEMgrInterface bean = TEE2EQuerySyncAttribute.getQuerySyncAttriBean(neID);
        Datainterface inputData = TEE2EQuerySyncAttribute.constructQuerySyncAttriInput(neID);
        SubFunc subFunc = TEE2EGetClockDeviceUtil.createSubFunc(neID, 2106668);
        Datainterface outputData = bean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        if (null == outputData) {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            String neName = ne.getNEName();
            return TEE2EGetClockDeviceUtil.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, 1090646019);
        }
        int retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            TEE2EQuerySyncAttribute.logBeanOperError(neID, retCode);
            TEE2EGetClockDeviceUtil.printRowError(outputData);
            errRet.setResult(1);
            errRet.addErrInfo(TEE2EGetClockDeviceUtil.constructErrInfoReturn(neID, outputData).getErrList());
        }
        if (null == outputData.getBussinessParams()) {
            TEE2EQuerySyncAttribute.logNullBussinessParamsError();
            return errRet;
        }
        if (0 == outputData.getBussinessParams().getRowParamsCount()) {
            TEE2EQuerySyncAttribute.logNullRowParamsError();
            return errRet;
        }
        RowParams rowParams = outputData.getBussinessParams().getRowParams(0);
        TEE2EQuerySyncAttribute.parseAttributeFromRowParams(neID, device, rowParams);
        TEE2EAppendProcessor.appendProcessor(neID, subFunc, inputData, outputData, isSaveDB);
        return errRet;
    }

    private static Datainterface constructQuerySyncAttriInput(int neID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = new RowParams();
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(neID));
        rowparams.addParam(param);
        if (TEE2EPTPSpecialFor1800.isOSN1800(neID)) {
            param = new Param("slotid", String.valueOf(TEE2EPTPSpecialFor1800.getFirstClockBoard(neID)));
            rowparams.addParam(param);
        }
        return inputData;
    }

    private static TENEMgrInterface getQuerySyncAttriBean(int neID) {
        return new TEQuerySyncAttriBean(){

            public boolean isNeedOperationlog() {
                return false;
            }
        };
    }

    public static void parseAttributeFromRowParams(int neID, TEE2EClockDevice device, RowParams rowParams) {
        if (0 != rowParams.getRowErrorsCount()) {
            return;
        }
        TEE2EQueryInnerClockSource.queryInnerClockSource(neID, device);
        int workmode = TEE2EGetClockDeviceUtil.getIntParam(rowParams, "workmode", -1);
        int grandNeID = -1;
        String grandPhyNEIDStr = TEE2EGetClockDeviceUtil.getStringParam(rowParams, "gid2", "-1");
        TENE grandNE = TENEListMgr.getInstance().getPhyNE(TEE2EQuerySyncAttribute.getDecNum(grandPhyNEIDStr));
        if (null != grandNE) {
            grandNeID = grandNE.getNEID();
        }
        int slotid = TEE2EGetClockDeviceUtil.getIntParam(rowParams, "slotid", -1);
        int gportid = TEE2EGetClockDeviceUtil.getIntParam(rowParams, "gportid", -1);
        int staticBMC = TEE2EGetClockDeviceUtil.getIntParam(rowParams, "staticBMC", 0);
        device.setNeID(neID);
        device.setPtpClockType(workmode);
        device.setGrandMaster(new int[]{grandNeID, slotid, gportid});
        device.setStaticBMC(staticBMC);
        device.setClockSyncState(-1);
        device.setTimeSyncState(-1);
        device.setPoOperMask(-1);
        device.setPoSearchMode(1);
        device.setClockDevType(1);
    }

    private static int getDecNum(String grandPhyNEIDStr) {
        try {
            return Integer.parseInt(grandPhyNEIDStr, 16);
        }
        catch (Exception e) {
            e2eLogger.error("parse grandPhyNEIDStr fail!", (Throwable)e);
            return -1;
        }
    }

    private static void logBeanOperError(int neID, int retCode) {
        String tipStr = "query clock sync attribute fail! ";
        tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
        e2eLogger.error(tipStr);
    }

    private static void logNullRowParamsError() {
        e2eLogger.error("no rowparams in outputData.");
    }

    private static void logNullBussinessParamsError() {
        e2eLogger.error("no bussinessparams in outputData.");
    }
}

