/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockDevice;
import com.huawei.nglct.nemgr.marine.clockptp.TEQuerySubnetBean;
import com.huawei.nglct.nemgr.marine.e2e.clock.TEE2EGetClockDeviceUtil;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EAppendProcessor;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import org.slf4j.Logger;

public final class TEE2EQuerySubnet {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEE2EQuerySubnet() {
    }

    public static TEErrInfoReturn querySubnet(int neID, TEE2EClockDevice device, boolean isSaveDB) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        TENEMgrInterface bean = TEE2EQuerySubnet.getQueryBean(neID);
        Datainterface inputData = TEE2EQuerySubnet.constructQueryInput(neID);
        int sfid = TEE2EQuerySubnet.getSfid();
        SubFunc subFunc = TEE2EGetClockDeviceUtil.createSubFunc(neID, sfid);
        Datainterface outputData = bean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        if (null == outputData) {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            String neName = ne.getNEName();
            return TEE2EGetClockDeviceUtil.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, 1090646019);
        }
        int retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            TEE2EQuerySubnet.logBeanOperError(neID, retCode);
            TEE2EGetClockDeviceUtil.printRowError(outputData);
            errRet = TEE2EGetClockDeviceUtil.constructErrInfoReturn(neID, outputData);
        }
        if (null == outputData.getBussinessParams()) {
            TEE2EQuerySubnet.logNullBussinessParamsError();
            return errRet;
        }
        if (0 == outputData.getBussinessParams().getRowParamsCount()) {
            TEE2EQuerySubnet.logNullRowParamsError();
            return errRet;
        }
        RowParams rowParams = outputData.getBussinessParams().getRowParams(0);
        TEE2EQuerySubnet.parseAttributeFromRowParams(neID, device, rowParams);
        TEE2EAppendProcessor.appendProcessor(neID, subFunc, inputData, outputData, isSaveDB);
        return errRet;
    }

    private static int getSfid() {
        return 2106674;
    }

    private static Datainterface constructQueryInput(int neID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = new RowParams();
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(neID));
        rowparams.addParam(param);
        return inputData;
    }

    private static TENEMgrInterface getQueryBean(int neID) {
        return new TEQuerySubnetBean(){

            public boolean isNeedOperationlog() {
                return false;
            }
        };
    }

    public static void parseAttributeFromRowParams(int neID, TEE2EClockDevice device, RowParams rowParams) {
        if (0 != rowParams.getRowErrorsCount()) {
            return;
        }
        int ptpdomain = TEE2EGetClockDeviceUtil.getIntParam(rowParams, "ptpdomain", -1);
        device.setNeID(neID);
        device.setClockDomain(ptpdomain);
    }

    private static void logBeanOperError(int neID, int retCode) {
        String tipStr = "query clock subnet fail! ";
        tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
        e2eLogger.error(tipStr);
    }

    private static void logNullRowParamsError() {
        e2eLogger.error("no rowparams in outputData.");
    }

    private static void logNullBussinessParamsError() {
        e2eLogger.error("no bussinessparams in outputData.");
    }
}

