/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockPort;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EUniResID;
import com.huawei.nglct.nemgr.marine.clockptp.TEQueryReceivesourceBean;
import com.huawei.nglct.nemgr.marine.e2e.clock.TEE2EGetClockDeviceUtil;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TESlotPortKey;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.nglct.util.fdn.FDNUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;

public class TEE2EQueryReceivesource {
    private static final int DEFAULT_SUBSLOTID = 255;
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();
    private int linkStatus = -1;

    public int getLinkStatus() {
        return this.linkStatus;
    }

    public void setLinkStatus(int linkStatus) {
        this.linkStatus = linkStatus;
    }

    public TEErrInfoReturn queryReceivesource(int neID, List<TEE2EClockPort> clockPortList) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        TENEMgrInterface bean = TEE2EQueryReceivesource.getQueryBean(neID);
        Datainterface inputData = TEE2EQueryReceivesource.constructQueryInput(neID, clockPortList);
        int sfid = TEE2EQueryReceivesource.getSfid();
        SubFunc subFunc = TEE2EGetClockDeviceUtil.createSubFunc(neID, sfid);
        Datainterface outputData = bean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        if (null == outputData) {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            String neName = ne.getNEName();
            return TEE2EGetClockDeviceUtil.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, 1090646019);
        }
        int retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            TEE2EQueryReceivesource.logBeanOperError(neID, retCode);
            TEE2EGetClockDeviceUtil.printRowError(outputData);
            errRet = TEE2EGetClockDeviceUtil.constructErrInfoReturn(neID, outputData);
        }
        if (null == outputData.getBussinessParams()) {
            TEE2EQueryReceivesource.logNullBussinessParamsError();
            return errRet;
        }
        if (0 == outputData.getBussinessParams().getRowParamsCount()) {
            TEE2EQueryReceivesource.logNullRowParamsError();
            return errRet;
        }
        ArrayList rowParamList = outputData.getBussinessParams().getRowParamList();
        this.parseAttributeFromRowParams(neID, rowParamList, clockPortList);
        return errRet;
    }

    private static int getSfid() {
        return 2106673;
    }

    private static Datainterface constructQueryInput(int neID, List<TEE2EClockPort> clockPortList) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = null;
        for (TEE2EClockPort clockPort : clockPortList) {
            TEE2EUniResID portIndex = clockPort.getPortIndex();
            int slotID = FDNUtil.getSlotID((String)portIndex.getStrFDN());
            int portID = FDNUtil.getPortID((String)portIndex.getStrFDN());
            rowparams = new RowParams();
            bussiness.addRowParams(rowparams);
            Param param = new Param("neid", String.valueOf(neID));
            rowparams.addParam(param);
            param = new Param("slotid", String.valueOf(slotID));
            rowparams.addParam(param);
            param = new Param("subslotid", String.valueOf(255));
            rowparams.addParam(param);
            param = new Param("port", String.valueOf(portID));
            rowparams.addParam(param);
        }
        return inputData;
    }

    private static TENEMgrInterface getQueryBean(int neID) {
        return new TEQueryReceivesourceBean(){

            public boolean isNeedOperationlog() {
                return false;
            }
        };
    }

    private void parseAttributeFromRowParams(int neID, List<RowParams> rowParamList, List<TEE2EClockPort> clockPortList) {
        if (null == rowParamList || rowParamList.isEmpty() || null == clockPortList || clockPortList.isEmpty()) {
            return;
        }
        TESlotPortKey key = null;
        HashMap<TESlotPortKey, TEE2EClockPort> clockPortMap = new HashMap<TESlotPortKey, TEE2EClockPort>();
        for (TEE2EClockPort clockPort : clockPortList) {
            TEE2EUniResID portIndex = clockPort.getPortIndex();
            int slotID = FDNUtil.getSlotID((String)portIndex.getStrFDN());
            int portID = TEConfigurationDataMgr.getPortRelativeID((int)FDNUtil.getPortID((String)portIndex.getStrFDN()));
            key = new TESlotPortKey();
            key.setSlotID(slotID);
            key.setPortID(portID);
            clockPortMap.put(key, clockPort);
        }
        for (RowParams rowParam : rowParamList) {
            int tempPortID;
            int tempSlotID = TEE2EGetClockDeviceUtil.getIntParam(rowParam, "slotid", -1);
            TESlotPortKey tempKey = new TESlotPortKey(tempSlotID, tempPortID = TEE2EGetClockDeviceUtil.getIntParam(rowParam, "port", -1));
            TEE2EClockPort tempPort = (TEE2EClockPort)clockPortMap.get(tempKey);
            if (null == tempPort) continue;
            tempPort.setState(TEE2EGetClockDeviceUtil.getIntParam(rowParam, "linkstatus", -1));
        }
    }

    private static void logBeanOperError(int neID, int retCode) {
        String tipStr = "query clock receive source fail! ";
        tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
        e2eLogger.error(tipStr);
    }

    private static void logNullRowParamsError() {
        e2eLogger.error("no rowparams in outputData.");
    }

    private static void logNullBussinessParamsError() {
        e2eLogger.error("no bussinessparams in outputData.");
    }
}

