/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockDevice;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockSource;
import com.huawei.nglct.nemgr.marine.clockptp.TEQueryPortStatusBean;
import com.huawei.nglct.nemgr.marine.e2e.clock.TEE2EGetClockDeviceUtil;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EAppendProcessor;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EBuildClockSource;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;

public final class TEE2EQueryPortClockSource {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEE2EQueryPortClockSource() {
    }

    public static TEErrInfoReturn queryPortClockSource(int neID, TEE2EClockDevice device, boolean isSaveDB) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        TENEMgrInterface bean = TEE2EQueryPortClockSource.getQueryBean(neID);
        Datainterface inputData = TEE2EQueryPortClockSource.constructQueryInput(neID, device);
        int sfid = TEE2EQueryPortClockSource.getSfid();
        SubFunc subFunc = TEE2EGetClockDeviceUtil.createSubFunc(neID, sfid);
        Datainterface outputData = bean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        if (null == outputData) {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            String neName = ne.getNEName();
            return TEE2EGetClockDeviceUtil.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, 1090646019);
        }
        int retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            TEE2EQueryPortClockSource.logBeanOperError(neID, retCode);
            TEE2EGetClockDeviceUtil.printRowError(outputData);
            errRet = TEE2EGetClockDeviceUtil.constructErrInfoReturn(neID, outputData);
        }
        if (null == outputData.getBussinessParams()) {
            TEE2EQueryPortClockSource.logNullBussinessParamsError();
            return errRet;
        }
        RowParams[] rowParamsArr = outputData.getBussinessParams().getRowParams();
        TEE2EQueryPortClockSource.parseAttributeFromRowParams(neID, device, rowParamsArr);
        TEE2EAppendProcessor.appendProcessor(neID, subFunc, inputData, outputData, isSaveDB);
        return errRet;
    }

    private static int getSfid() {
        return 2106669;
    }

    private static Datainterface constructQueryInput(int neID, TEE2EClockDevice device) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = new RowParams();
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(neID));
        rowparams.addParam(param);
        param = new Param("isFromNE", "0");
        rowparams.addParam(param);
        param = new Param("workmode", String.valueOf(device.getPtpClockType()));
        rowparams.addParam(param);
        return inputData;
    }

    private static TENEMgrInterface getQueryBean(int neID) {
        return new TEQueryPortStatusBean(){

            public boolean isNeedOperationlog() {
                return false;
            }
        };
    }

    public static void parseAttributeFromRowParams(int neID, TEE2EClockDevice device, RowParams[] rowParamsArr) {
        RowParams rowParams2 = null;
        TEE2EClockSource clock = null;
        TEE2EQueryPortClockSource.clearPortClock(device);
        for (RowParams rowParams2 : rowParamsArr) {
            if (0 != rowParams2.getRowErrorsCount()) continue;
            int slotID = TEE2EGetClockDeviceUtil.getIntParam(rowParams2, "slotid", -1);
            int portID = TEE2EGetClockDeviceUtil.getIntParam(rowParams2, "port", -1);
            clock = TEE2EBuildClockSource.buildClockSource(neID, slotID, portID, 2);
            device.getClockSourceList().add(clock);
        }
    }

    private static void clearPortClock(TEE2EClockDevice device) {
        List clockSourceList = device.getClockSourceList();
        Iterator iter = clockSourceList.iterator();
        TEE2EClockSource clock = null;
        while (iter.hasNext()) {
            clock = (TEE2EClockSource)iter.next();
            if (2 != clock.getType()) continue;
            iter.remove();
        }
    }

    private static void logBeanOperError(int neID, int retCode) {
        String tipStr = "query clock subnet fail! ";
        tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
        e2eLogger.error(tipStr);
    }

    private static void logNullRowParamsError() {
        e2eLogger.error("no rowparams in outputData.");
    }

    private static void logNullBussinessParamsError() {
        e2eLogger.error("no bussinessparams in outputData.");
    }
}

