/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEQueryPortForDataMgr;
import com.huawei.nglct.nemgr.marine.clockptp.TENEClockWriteLogBean;
import com.huawei.nglct.nemgr.marine.clockptp.TEQueryBMCBean;
import com.huawei.nglct.nemgr.marine.e2e.clock.TEE2EGetClockDeviceUtil;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EAppendProcessor;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EBMCData;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EPTPSpecialFor1800;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.Hashtable;
import java.util.Map;
import org.slf4j.Logger;

public class TEE2EQueryOuterBMC {
    private static final int DEFAULT_SUBSLOTID = 0;
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();
    private Map<Integer, TEE2EBMCData> bmcDataMap = new Hashtable<Integer, TEE2EBMCData>();

    public TEErrInfoReturn queryBMC(int neID, int slotID, int portID, boolean isSaveDB) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        TENEMgrInterface bean = TEE2EQueryOuterBMC.getQueryBean(neID);
        Datainterface inputData = TEE2EQueryOuterBMC.constructQueryInput(neID, slotID, portID);
        int sfid = TEE2EQueryOuterBMC.getSfid();
        SubFunc subFunc = TEE2EGetClockDeviceUtil.createSubFunc(neID, sfid);
        Datainterface outputData = bean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        if (null == outputData) {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            String neName = ne.getNEName();
            return TEE2EGetClockDeviceUtil.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, 1090646019);
        }
        int retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            TEE2EQueryOuterBMC.logBeanOperError(neID, retCode);
            TEE2EGetClockDeviceUtil.printRowError(outputData);
            errRet = TEE2EGetClockDeviceUtil.constructErrInfoReturn(neID, outputData);
        }
        if (null == outputData.getBussinessParams()) {
            TEE2EQueryOuterBMC.logNullBussinessParamsError();
            return errRet;
        }
        if (0 == outputData.getBussinessParams().getRowParamsCount()) {
            TEE2EQueryOuterBMC.logNullRowParamsError();
            return errRet;
        }
        RowParams[] rowParamsArr = outputData.getBussinessParams().getRowParams();
        TEE2EQueryOuterBMC.parseAttributeFromRowParams(neID, rowParamsArr, this.bmcDataMap);
        TEE2EAppendProcessor.appendProcessor(neID, subFunc, inputData, outputData, isSaveDB);
        return errRet;
    }

    private static int getSfid() {
        return 2106675;
    }

    private static Datainterface constructQueryInput(int neID, int slotID, int portID) {
        if (TEE2EPTPSpecialFor1800.isOSN1800(neID)) {
            return TEE2EQueryOuterBMC.constructQueryInput4Osn1800(neID);
        }
        return TEE2EQueryOuterBMC.constructQueryInput4Ngwdm(neID);
    }

    private static Datainterface constructQueryInput4Osn1800(int neID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = new RowParams();
        TEE2EQueryOuterBMC.addParam(rowparams, "neid", neID);
        TEE2EQueryOuterBMC.addParam(rowparams, "slotid", TEE2EPTPSpecialFor1800.getFirstClockBoard(neID));
        TEE2EQueryOuterBMC.addParam(rowparams, "subslotid", 0);
        TEE2EQueryOuterBMC.addParam(rowparams, "port", 2);
        bussiness.addRowParams(rowparams);
        rowparams = new RowParams();
        TEE2EQueryOuterBMC.addParam(rowparams, "neid", neID);
        TEE2EQueryOuterBMC.addParam(rowparams, "slotid", TEE2EPTPSpecialFor1800.getFirstClockBoard(neID));
        TEE2EQueryOuterBMC.addParam(rowparams, "subslotid", 0);
        TEE2EQueryOuterBMC.addParam(rowparams, "port", 4);
        bussiness.addRowParams(rowparams);
        return inputData;
    }

    private static void addParam(RowParams rowParams, String paramName, int paramValue) {
        Param param = new Param(paramName, String.valueOf(paramValue));
        rowParams.addParam(param);
    }

    private static Datainterface constructQueryInput4Ngwdm(int neID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = new RowParams();
        TEE2EQueryOuterBMC.addParam(rowparams, "neid", neID);
        bussiness.addRowParams(rowparams);
        return inputData;
    }

    private static TENEMgrInterface getQueryBean(int neID) {
        TENEClockWriteLogBean bean = null;
        bean = TEE2EPTPSpecialFor1800.isOSN1800(neID) ? new TENEClockWriteLogBean(){

            public boolean isNeedOperationlog() {
                return false;
            }
        } : new TEQueryBMCBean(){

            public boolean isNeedOperationlog() {
                return false;
            }
        };
        return bean;
    }

    public static void parseAttributeFromRowParams(int neID, RowParams[] rowParamsArr, Map<Integer, TEE2EBMCData> bmcDataMap) {
        RowParams rowParams2 = null;
        TEE2EBMCData bmcData = null;
        for (RowParams rowParams2 : rowParamsArr) {
            if (0 != rowParams2.getRowErrorsCount()) {
                return;
            }
            String obj = rowParams2.getParam("port").getValue();
            if (null == obj || obj.isEmpty()) continue;
            int portID = Integer.parseInt(obj);
            bmcData = new TEE2EBMCData();
            bmcData.setTimelevel(TEE2EGetClockDeviceUtil.getIntParam(rowParams2, "timelevel", -1));
            bmcData.setTimeprecision(TEE2EGetClockDeviceUtil.getIntParam(rowParams2, "timeprecision", -1));
            bmcData.setClocktype(TEE2EGetClockDeviceUtil.getIntParam(rowParams2, "clocktype", -1));
            bmcData.setClockpri1(TEE2EGetClockDeviceUtil.getIntParam(rowParams2, "clockpri1", -1));
            bmcData.setClockpri2(TEE2EGetClockDeviceUtil.getIntParam(rowParams2, "clockpri2", -1));
            bmcData.setClockoffset(TEE2EGetClockDeviceUtil.getIntParam(rowParams2, "clockoffset", -1));
            bmcDataMap.put(TEQueryPortForDataMgr.getAbstractPortID((int)neID, (int)portID), bmcData);
        }
    }

    public Map<Integer, TEE2EBMCData> getBmcDataMap() {
        return this.bmcDataMap;
    }

    private static void logBeanOperError(int neID, int retCode) {
        String tipStr = "query clock bmc fail! ";
        tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
        e2eLogger.error(tipStr);
    }

    private static void logNullRowParamsError() {
        e2eLogger.error("no rowparams in outputData.");
    }

    private static void logNullBussinessParamsError() {
        e2eLogger.error("no bussinessparams in outputData.");
    }
}

