/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.marine.clockptp.TEQueryBMCBean;
import com.huawei.nglct.nemgr.marine.e2e.clock.TEE2EGetClockDeviceUtil;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EAppendProcessor;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EBMCData;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EPTPSpecialFor1800;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import org.slf4j.Logger;

public class TEE2EQueryBMC {
    private static final int DEFAULT_SUBSLOTID = 255;
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();
    private TEE2EBMCData bmcData = new TEE2EBMCData();

    public TEErrInfoReturn queryBMC(int neID, int slotID, int portID, boolean isSaveDB) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        TENEMgrInterface bean = TEE2EQueryBMC.getQueryBean(neID);
        Datainterface inputData = TEE2EQueryBMC.constructQueryInput(neID, slotID, portID);
        int sfid = TEE2EQueryBMC.getSfid();
        SubFunc subFunc = TEE2EGetClockDeviceUtil.createSubFunc(neID, sfid);
        Datainterface outputData = bean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        if (null == outputData) {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            String neName = ne.getNEName();
            return TEE2EGetClockDeviceUtil.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, 1090646019);
        }
        int retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            TEE2EQueryBMC.logBeanOperError(neID, retCode);
            TEE2EGetClockDeviceUtil.printRowError(outputData);
            errRet = TEE2EGetClockDeviceUtil.constructErrInfoReturn(neID, outputData);
        }
        if (null == outputData.getBussinessParams()) {
            TEE2EQueryBMC.logNullBussinessParamsError();
            return errRet;
        }
        if (0 == outputData.getBussinessParams().getRowParamsCount()) {
            TEE2EQueryBMC.logNullRowParamsError();
            return errRet;
        }
        RowParams rowParams = outputData.getBussinessParams().getRowParams(0);
        TEE2EQueryBMC.parseAttributeFromRowParams(neID, rowParams, this.bmcData);
        TEE2EAppendProcessor.appendProcessor(neID, subFunc, inputData, outputData, isSaveDB);
        return errRet;
    }

    private static int getSfid() {
        return 2106675;
    }

    private static Datainterface constructQueryInput(int neID, int slotID, int portID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = new RowParams();
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(neID));
        rowparams.addParam(param);
        param = new Param("slotid", String.valueOf(TEE2EQueryBMC.getSlotID(neID)));
        rowparams.addParam(param);
        param = new Param("subslotid", String.valueOf(255));
        rowparams.addParam(param);
        param = new Param("port", String.valueOf(TEE2EQueryBMC.getPortID(neID)));
        rowparams.addParam(param);
        return inputData;
    }

    private static int getPortID(int neID) {
        int portID = -1;
        if (TEE2EPTPSpecialFor1800.isOSN1800(neID)) {
            portID = 65535;
        }
        return portID;
    }

    private static int getSlotID(int neID) {
        int slotID = -1;
        if (TEE2EPTPSpecialFor1800.isOSN1800(neID)) {
            slotID = TEE2EPTPSpecialFor1800.getFirstClockBoard(neID);
        }
        return slotID;
    }

    private static TENEMgrInterface getQueryBean(int neID) {
        return new TEQueryBMCBean(){

            public boolean isNeedOperationlog() {
                return false;
            }
        };
    }

    public static void parseAttributeFromRowParams(int neID, RowParams rowParams, TEE2EBMCData bmcData) {
        if (0 != rowParams.getRowErrorsCount()) {
            return;
        }
        bmcData.setTimelevel(TEE2EGetClockDeviceUtil.getIntParam(rowParams, "timelevel", -1));
        bmcData.setTimeprecision(TEE2EGetClockDeviceUtil.getIntParam(rowParams, "timeprecision", -1));
        bmcData.setClocktype(TEE2EGetClockDeviceUtil.getIntParam(rowParams, "clocktype", -1));
        bmcData.setClockpri1(TEE2EGetClockDeviceUtil.getIntParam(rowParams, "clockpri1", -1));
        bmcData.setClockpri2(TEE2EGetClockDeviceUtil.getIntParam(rowParams, "clockpri2", -1));
        bmcData.setClockoffset(TEE2EGetClockDeviceUtil.getIntParam(rowParams, "clockoffset", -1));
    }

    public int getTimelevel() {
        return this.bmcData.getTimelevel();
    }

    public int getTimeprecision() {
        return this.bmcData.getTimeprecision();
    }

    public int getClocktype() {
        return this.bmcData.getClocktype();
    }

    public int getClockpri1() {
        return this.bmcData.getClockpri1();
    }

    public int getClockpri2() {
        return this.bmcData.getClockpri2();
    }

    public int getClockoffset() {
        return this.bmcData.getClockoffset();
    }

    public TEE2EBMCData getBmcData() {
        return this.bmcData;
    }

    private static void logBeanOperError(int neID, int retCode) {
        String tipStr = "query clock bmc fail! ";
        tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
        e2eLogger.error(tipStr);
    }

    private static void logNullRowParamsError() {
        e2eLogger.error("no rowparams in outputData.");
    }

    private static void logNullBussinessParamsError() {
        e2eLogger.error("no bussinessparams in outputData.");
    }
}

