/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock;

import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockPort;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockSource;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EPortClockSourceInfo;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EUniResID;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.fdn.FDNBuilder;
import com.huawei.nglct.util.fdn.FDNTypeEnum;
import com.huawei.nglct.util.fdn.FDNUtil;

public class TEE2EBuildClockSource {
    private static final int INVALID_VALUE = -1;
    private static final int DEFAULT_POINPORTID = 0;
    private static final int DEFAULT_POUPSTREAMPORTID = 0;

    private TEE2EBuildClockSource() {
    }

    public static TEE2EClockSource buildClockSource(int neID, int slotID, int portID, int clockType) {
        TEE2EClockSource clock = new TEE2EClockSource();
        String clockID = TEE2EBuildClockSource.buildClockID(neID, slotID, portID, clockType);
        clock.setClockID(clockID);
        clock.setType(clockType);
        clock.setbIsCurrTrace(0);
        if (2 == clockType) {
            TEE2EUniResID inPortID = TEE2EBuildClockSource.constructUniResID(neID, slotID, portID);
            TEE2EUniResID upStreamPortID = TEE2EBuildClockSource.constructUniResID(-1, -1, -1);
            TEE2EPortClockSourceInfo portClock = new TEE2EPortClockSourceInfo();
            portClock.setInPort(inPortID);
            portClock.setType(1);
            portClock.setPoUpstreamPort(upStreamPortID);
            portClock.setPoClockSource("");
            portClock.setPoInPortId(0);
            portClock.setPoUpstreamClockSource("");
            portClock.setPoUpstreamPortId(0);
            portClock.setInPortName(TEE2EBuildClockSource.getPortName(neID, slotID, portID));
            portClock.setPoUpstreamName("");
            clock.setPoPortClockSource(portClock);
        }
        return clock;
    }

    private static String buildClockID(int neID, int slotID, int portID, int clockType) {
        String clockID = "";
        if (1 == clockType) {
            clockID = "";
        } else if (2 == clockType) {
            clockID = TEE2EBuildClockSource.getPortClockID(neID, slotID, portID);
        } else if (3 == clockType) {
            clockID = TEE2EBuildClockSource.getOuterClockID(neID, slotID, portID);
        }
        return clockID;
    }

    public static TEE2EClockPort buildClockPortList(int neID, int slotID, int portID, int portworkmode, int portstatus) {
        TEE2EClockPort clockPort = new TEE2EClockPort();
        clockPort.setPortIndex(TEE2EBuildClockSource.constructUniResID(neID, slotID, portID));
        clockPort.setPortClockType(portworkmode);
        clockPort.setMode(portstatus);
        clockPort.setState(-1);
        clockPort.setPortName(TEE2EBuildClockSource.getPortName(neID, slotID, portID));
        clockPort.setPoPortCompensator("");
        return clockPort;
    }

    public static String getPortName(int neID, int slotID, int portID) {
        String portName = "";
        if (-1 != portID) {
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
            portName = TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, boardType, portID);
            String shelfName = TEBoardUtil.getSubrackNameFromSlot((int)neID, (int)slotID);
            String boardName = TEBoardUtil.getCPTypeName((int)boardType);
            int relativeSlotID = TEBoardUtil.bigSlotToSmall((int)slotID);
            portName = shelfName + "-" + relativeSlotID + "-" + boardName + "-" + portName;
        }
        return portName;
    }

    private static String getPortClockID(int neID, int slotID, int portID) {
        int shelfID = TEBoardUtil.getSubrackIDFromSlot((int)neID, (int)slotID);
        int relativeSlotID = TEBoardUtil.getSlotIDFromSlot((int)neID, (int)slotID);
        return String.valueOf(shelfID * 1000000 + relativeSlotID * 1000 + portID);
    }

    private static String getOuterClockID(int neID, int slotID, int portID) {
        int shelfID = TEBoardUtil.getSubrackIDFromSlot((int)neID, (int)slotID);
        int relativeSlotID = TEBoardUtil.getSlotIDFromSlot((int)neID, (int)slotID);
        return String.valueOf(1000000000 + shelfID * 1000000 + relativeSlotID * 1000 + portID);
    }

    public static TEE2EUniResID constructUniResID(int neID, int slotID, int portID) {
        int shelfID;
        FDNBuilder builder = new FDNBuilder();
        String portName = "";
        String fdn = FDNUtil.buildFDNValue((String[])new String[]{String.valueOf(3), "", String.valueOf(portID), portName});
        builder.append(FDNTypeEnum.PORT, fdn);
        if (-1 != neID && -1 != (shelfID = TEBoardUtil.getSubrackIDFromSlot((int)neID, (int)slotID))) {
            builder.append(FDNTypeEnum.FRAME, shelfID);
        }
        int ralativeSlotID = TEBoardUtil.bigSlotToSmall((int)slotID);
        builder.append(FDNTypeEnum.SLOT, ralativeSlotID);
        builder.append(FDNTypeEnum.NE, neID);
        TEE2EUniResID inPortID = new TEE2EUniResID();
        inPortID.setStrFDN(builder.getValue());
        inPortID.setStrMOC("PP");
        inPortID.setNeID(neID);
        inPortID.setPoSerialNum("");
        return inPortID;
    }
}

