/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.clock.message;

import com.huawei.network.qasn.m_q_nml_clock_model.QAsnClockDevice;
import com.huawei.network.qasn.m_q_nml_clock_model.QAsnClockNE;
import com.huawei.network.qasn.m_q_nml_clock_op.QAsnClockDevAddRpt;
import com.huawei.network.qasn.m_q_nml_clock_op.QAsnClockDevChangeRpt;
import com.huawei.network.qasn.m_q_nml_clock_op.QAsnClockDevDelRpt;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.reliableevent.TEReliableEventMgr;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockDevice;
import com.huawei.nglct.nemgr.e2e.task.clock.util.TEE2EClockDataConverter;
import com.huawei.nglct.nemgr.marine.e2e.clock.TEE2EGetClockDeviceFromNE;
import com.huawei.nglct.nemgr.marine.e2e.clock.message.TEE2EClockDevAddMsg;
import com.huawei.nglct.nemgr.marine.e2e.clock.message.TEE2EClockDevChangeMsg;
import com.huawei.nglct.nemgr.marine.e2e.clock.message.TEE2EClockDevDelMsg;
import com.huawei.nglct.nemgr.marine.e2e.clock.message.TEE2EClockMessage;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public final class TEE2EClockNoticeMgr {
    private static final Logger e2elogger = TELogFactory.getE2ELogger();
    public static final int QEVENT_CLOCKDEVADD = 65589;
    public static final int QEVENT_CLOCKDEVCHANGE = 65590;
    public static final int QEVENT_CLOCKDEVDEL = 65591;

    private TEE2EClockNoticeMgr() {
    }

    public static void sendClockDevAddNtf(TEE2EClockMessage message) {
        if (null == message) {
            e2elogger.info("Send clock dev add notify fail! the message is null!");
            return;
        }
        int neID = -1;
        int eventID = message.getEventID();
        FStruct asnMsg = message.getContent();
        TEReliableEventMgr.getInstance().send(eventID, neID, asnMsg);
        e2elogger.info(((Object)message).toString());
    }

    public static void sendClockDevChangeNtf(TEE2EClockMessage message) {
        if (null == message) {
            e2elogger.info("Send clock dev change notify fail! the message is null!");
            return;
        }
        int neID = -1;
        int eventID = message.getEventID();
        FStruct asnMsg = message.getContent();
        TEReliableEventMgr.getInstance().send(eventID, neID, asnMsg);
        e2elogger.info(((Object)message).toString());
    }

    public static void sendClockDevDelNtf(TEE2EClockMessage message) {
        if (null == message) {
            e2elogger.info("Send clock dev del notify fail! the message is null!");
            return;
        }
        int neID = -1;
        int eventID = message.getEventID();
        FStruct asnMsg = message.getContent();
        TEReliableEventMgr.getInstance().send(eventID, neID, asnMsg);
        e2elogger.info(((Object)message).toString());
    }

    public static TEE2EClockMessage buildDevAddMessage(int neID, int poOperMask) {
        List<QAsnClockDevice> asnDeviceList = TEE2EClockNoticeMgr.queryAsnClockDev(neID, poOperMask);
        if (asnDeviceList.isEmpty()) {
            return null;
        }
        TEE2EClockMessage msg = TEE2EClockNoticeMgr.buildDevAddMessage(asnDeviceList);
        return msg;
    }

    public static TEE2EClockMessage buildDevChangeMessage(int neID, int poOperMask) {
        List<QAsnClockDevice> asnDeviceList = TEE2EClockNoticeMgr.queryAsnClockDev(neID, poOperMask);
        if (asnDeviceList.isEmpty()) {
            return null;
        }
        TEE2EClockMessage msg = TEE2EClockNoticeMgr.buildDevChangeMessage(asnDeviceList);
        return msg;
    }

    public static TEE2EClockMessage buildDevDelMessage(int neID, int poOperMask) {
        List<QAsnClockDevice> asnDeviceList = TEE2EClockNoticeMgr.queryAsnClockDev(neID, poOperMask);
        if (asnDeviceList.isEmpty()) {
            return null;
        }
        TEE2EClockMessage msg = TEE2EClockNoticeMgr.buildDevDelMessage(neID);
        return msg;
    }

    private static List<QAsnClockDevice> queryAsnClockDev(int neID, int poOperMask) {
        ArrayList<TEE2EClockDevice> rspDeviceList = new ArrayList<TEE2EClockDevice>();
        TEE2EGetClockDeviceFromNE.getClockDevice(neID, rspDeviceList);
        if (rspDeviceList.isEmpty()) {
            return new ArrayList<QAsnClockDevice>();
        }
        for (TEE2EClockDevice dataDevice : rspDeviceList) {
            if (0 == dataDevice.getNeID()) continue;
            dataDevice.setPoOperMask(poOperMask);
        }
        List asnDeviceList = TEE2EClockDataConverter.data2AsnClockDevice(rspDeviceList);
        return asnDeviceList;
    }

    private static TEE2EClockMessage buildDevAddMessage(List<QAsnClockDevice> asnDeviceList) {
        if (asnDeviceList.isEmpty()) {
            return null;
        }
        QAsnClockDevAddRpt content = new QAsnClockDevAddRpt();
        for (QAsnClockDevice asnClockDevice : asnDeviceList) {
            QAsnClockNE clockNE = new QAsnClockNE();
            clockNE.neID = asnClockDevice.neID;
            clockNE.clockDevice = asnClockDevice;
            clockNE.type = 1;
            content.clockNEList.add((Object)clockNE);
        }
        TEE2EClockDevAddMsg msg = new TEE2EClockDevAddMsg((FStruct)content);
        return msg;
    }

    private static TEE2EClockMessage buildDevChangeMessage(List<QAsnClockDevice> asnDeviceList) {
        if (asnDeviceList.isEmpty()) {
            return null;
        }
        QAsnClockDevChangeRpt content = new QAsnClockDevChangeRpt();
        for (QAsnClockDevice asnClockDevice : asnDeviceList) {
            QAsnClockNE clockNE = new QAsnClockNE();
            clockNE.neID = asnClockDevice.neID;
            clockNE.clockDevice = asnClockDevice;
            clockNE.type = 1;
            content.clockNEList.add((Object)clockNE);
        }
        TEE2EClockDevChangeMsg msg = new TEE2EClockDevChangeMsg((FStruct)content);
        return msg;
    }

    private static TEE2EClockMessage buildDevDelMessage(int neID) {
        QAsnClockNE clockNE = new QAsnClockNE();
        clockNE.neID = neID;
        clockNE.type = 1;
        QAsnClockDevDelRpt content = new QAsnClockDevDelRpt();
        content.clockNEList.add((Object)clockNE);
        TEE2EClockDevDelMsg msg = new TEE2EClockDevDelMsg((FStruct)content);
        return msg;
    }
}

