/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.clock;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockDevice;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockSource;
import com.huawei.nglct.nemgr.marine.e2e.clock.TEE2EClockConverterOTN;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EBMCData;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EPTPSpecialFor1800;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EQueryBMC;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EQueryClockPortList;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EQueryOuterBMC;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EQueryOuterClockSource;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EQueryReceivesource;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EQuerySubnet;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EQuerySyncAttribute;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.nglct.util.string.TEStringUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public final class TEE2EGetClockDeviceFromNE {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEE2EGetClockDeviceFromNE() {
    }

    public static TEErrInfoReturn getClockDevice(int neID, List<TEE2EClockDevice> rspDeviceList) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        TEE2EClockDevice device = new TEE2EClockDevice();
        e2eLogger.info("clock: get basic info begin");
        TEErrInfoReturn tempErrRet = TEE2EQuerySyncAttribute.queryClockSyncAttribute(neID, device, true);
        errRet.addErrInfo(tempErrRet.getErrList());
        if (2 == tempErrRet.getResult()) {
            errRet.setResult(2);
            return errRet;
        }
        errRet.setResult(1);
        e2eLogger.info("clock: get basic info end");
        e2eLogger.info("clock: get subnet begin");
        tempErrRet = TEE2EQuerySubnet.querySubnet(neID, device, true);
        if (0 != tempErrRet.getResult()) {
            errRet.setResult(1);
            errRet.addErrInfo(tempErrRet.getErrList());
        }
        e2eLogger.info("clock: get subnet end");
        e2eLogger.info("clock: query outer clock begin");
        tempErrRet = TEE2EQueryOuterClockSource.queryOuterClockSource(neID, device, true);
        if (0 != tempErrRet.getResult()) {
            errRet.setResult(1);
            errRet.addErrInfo(tempErrRet.getErrList());
        }
        e2eLogger.info("clock: query outer clock end");
        e2eLogger.info("clock: query clock port begin");
        tempErrRet = TEE2EQueryClockPortList.queryClockPortList(neID, device, true);
        if (0 != tempErrRet.getResult()) {
            errRet.setResult(1);
            errRet.addErrInfo(tempErrRet.getErrList());
        }
        e2eLogger.info("clock: query clock port end");
        e2eLogger.info("clock: query bmc begin");
        TEE2EGetClockDeviceFromNE.queryBMC(neID, errRet, device);
        e2eLogger.info("clock: query bmc end");
        e2eLogger.info("clock: query outer bmc begin");
        TEE2EGetClockDeviceFromNE.queryOuterBMC(neID, errRet, device);
        e2eLogger.info("clock: query outer bmc end");
        rspDeviceList.add(device);
        TEE2EGetClockDeviceFromNE.setGrandMasterID(neID, device);
        return errRet;
    }

    public static void queryBMC(int neID, TEErrInfoReturn errRet, TEE2EClockDevice device) {
        TEE2EQueryBMC bmcBean = new TEE2EQueryBMC();
        TEErrInfoReturn tempErrRet = bmcBean.queryBMC(neID, -1, -1, true);
        if (0 != tempErrRet.getResult()) {
            errRet.setResult(1);
            errRet.addErrInfo(tempErrRet.getErrList());
        } else {
            TEE2EGetClockDeviceFromNE.updateBMC(device, bmcBean.getBmcData());
        }
        TEE2EGetClockDeviceFromNE.getReceiveSource(neID, tempErrRet, device);
    }

    public static void updateBMC(TEE2EClockDevice device, TEE2EBMCData bmcData) {
        List clockSourceList = device.getClockSourceList();
        for (TEE2EClockSource clockSource : clockSourceList) {
            int clockType = clockSource.getType();
            if (1 != clockType && 2 != clockType) continue;
            clockSource.setClockAccuracy(bmcData.getTimeprecision());
            clockSource.setClockClass(bmcData.getTimelevel());
            clockSource.setClockPriority1(bmcData.getClockpri1());
            clockSource.setClockPriority2(bmcData.getClockpri2());
            clockSource.setClockTimeSource(bmcData.getClocktype());
        }
    }

    public static void getReceiveSource(int neID, TEErrInfoReturn errRet, TEE2EClockDevice device) {
        List clockPortList = device.getClockPortList();
        TEE2EQueryReceivesource bean = new TEE2EQueryReceivesource();
        bean.queryReceivesource(neID, clockPortList);
    }

    private static void queryOuterBMC(int neID, TEErrInfoReturn errRet, TEE2EClockDevice device) {
        TEE2EQueryOuterBMC bmcBean = new TEE2EQueryOuterBMC();
        TEErrInfoReturn tempErrRet = bmcBean.queryBMC(neID, -1, -1, true);
        if (0 != tempErrRet.getResult()) {
            errRet.setResult(1);
            errRet.addErrInfo(tempErrRet.getErrList());
        } else {
            TEE2EGetClockDeviceFromNE.updateOuterBMC(neID, device, bmcBean.getBmcDataMap());
        }
    }

    public static void updateOuterBMC(int neID, TEE2EClockDevice device, Map<Integer, TEE2EBMCData> bmcDataMap) {
        List clockSourceList = device.getClockSourceList();
        for (TEE2EClockSource clockSource : clockSourceList) {
            TEE2EBMCData bmcData;
            int clockType = clockSource.getType();
            if (3 != clockType || null == (bmcData = bmcDataMap.get(TEE2EClockConverterOTN.getPortIDFromClockID(neID, Long.parseLong(clockSource.getClockID()))))) continue;
            clockSource.setClockAccuracy(bmcData.getTimeprecision());
            clockSource.setClockClass(bmcData.getTimelevel());
            clockSource.setClockPriority1(bmcData.getClockpri1());
            clockSource.setClockPriority2(bmcData.getClockpri2());
            clockSource.setClockTimeSource(bmcData.getClocktype());
        }
    }

    public static void setGrandMasterID(int neID, TEE2EClockDevice device) {
        boolean isInnerClock = false;
        int[] grandMaster = device.getGrandMaster();
        if (TEE2EPTPSpecialFor1800.isOSN1800(neID)) {
            if (0 == grandMaster[2] && neID == device.getGrandMaster()[0]) {
                isInnerClock = true;
            }
        } else if (0 == grandMaster[1] && 0 == grandMaster[2] && neID == device.getGrandMaster()[0]) {
            isInnerClock = true;
        }
        List clockSourceList = device.getClockSourceList();
        for (TEE2EClockSource clockSource : clockSourceList) {
            int clockType = clockSource.getType();
            if (isInnerClock && clockType == 1) {
                clockSource.setbIsCurrTrace(1);
                break;
            }
            if (!TEStringUtils.isNumber((String)clockSource.getClockID())) continue;
            long clockID = Long.parseLong(clockSource.getClockID());
            int slotID = TEE2EClockConverterOTN.getSlotIDFromClockID(clockID);
            int portID = TEConfigurationDataMgr.getPortRelativeID((int)TEE2EClockConverterOTN.getPortIDFromClockID(neID, clockID));
            if (grandMaster[1] != slotID || grandMaster[2] != portID) continue;
            clockSource.setbIsCurrTrace(1);
            break;
        }
    }
}

