/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.clock;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockDevice;
import com.huawei.nglct.nemgr.marine.e2e.clock.TEE2EClockConverterOTN;
import com.huawei.nglct.nemgr.marine.e2e.clock.TEE2EGetClockDeviceUtil;
import com.huawei.nglct.po.embeddednemgrmo.otn.ptpclock.TEPTPClockPropertyMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.List;
import org.slf4j.Logger;

public final class TEE2EClockDeviceDBMgr {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEE2EClockDeviceDBMgr() {
    }

    public static TEPTPClockPropertyMOPO getClockDeviceFromDB(int neID, TEErrInfoReturn errRet) {
        TEPTPClockPropertyMOPO moDevice = null;
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TEE2EClockDeviceDBMgr.logNullNEError(neID);
                TEE2EClockDeviceDBMgr.setOperFail(neID, errRet, 1090596385);
                return moDevice;
            }
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID}, TEPTPClockPropertyMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID}, TEPTPClockPropertyMOPO.class);
        }
        catch (Exception e) {
            TEE2EClockDeviceDBMgr.logExceptionOnGet(neID, e);
            TEE2EClockDeviceDBMgr.setOperFail(neID, errRet, 1092743443);
            return moDevice;
        }
        if (null == dbResult) {
            TEE2EClockDeviceDBMgr.logNullErrorOnGet(neID);
            TEE2EClockDeviceDBMgr.setOperFail(neID, errRet, 1092743443);
            return moDevice;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                moDevice = (TEPTPClockPropertyMOPO)data.get(0);
            }
        } else {
            TEE2EClockDeviceDBMgr.logRetCodeErrorOnGet(neID, retCode);
            TEE2EClockDeviceDBMgr.setOperFail(neID, errRet, retCode);
        }
        return moDevice;
    }

    public static void updateClockDeviceToDB(int neID, TEE2EClockDevice dataDevice, TEErrInfoReturn errRet) {
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            TEPTPClockPropertyMOPO moDevice = TEE2EClockConverterOTN.data2MO(neID, dataDevice);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID}, (Object)moDevice) : TECommonDaoService.update_NonLock((int[])new int[]{neID}, (Object)moDevice);
        }
        catch (Exception e) {
            TEE2EClockDeviceDBMgr.logExceptionErrorOnUpdate(neID, e);
            TEE2EClockDeviceDBMgr.setOperFail(neID, errRet, 1092743443);
            return;
        }
        if (null == dbResult) {
            TEE2EClockDeviceDBMgr.logNullErrorOnUpdate(neID);
            TEE2EClockDeviceDBMgr.setOperFail(neID, errRet, 1092743443);
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEE2EClockDeviceDBMgr.logRetCodeErrorOnUpdate(neID, retCode);
            TEE2EClockDeviceDBMgr.setOperFail(neID, errRet, retCode);
        }
    }

    public static void createClockDeviceToDB(int neID, TEE2EClockDevice dataDevice, TEErrInfoReturn errRet) {
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            TEPTPClockPropertyMOPO moDevice = TEE2EClockConverterOTN.data2MO(neID, dataDevice);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID}, (Object)moDevice) : TECommonDaoService.create_NonLock((int[])new int[]{neID}, (Object)moDevice);
        }
        catch (Exception e) {
            TEE2EClockDeviceDBMgr.logExceptionErrorOnCreate(neID, e);
            TEE2EClockDeviceDBMgr.setOperFail(neID, errRet, 1092743443);
            return;
        }
        if (null == dbResult) {
            TEE2EClockDeviceDBMgr.logNullErrorOnCreate(neID);
            TEE2EClockDeviceDBMgr.setOperFail(neID, errRet, 1092743443);
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEE2EClockDeviceDBMgr.logRetCodeErrorOnCreate(neID, retCode);
            TEE2EClockDeviceDBMgr.setOperFail(neID, errRet, retCode);
        }
    }

    public static void delClockDeviceToDB(int neID, TEPTPClockPropertyMOPO moDevice, TEErrInfoReturn errRet) {
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID}, (Object)moDevice) : TECommonDaoService.delete_NonLock((int[])new int[]{neID}, (Object)moDevice);
        }
        catch (Exception e) {
            TEE2EClockDeviceDBMgr.logExceptionErrorOnDel(neID, e);
            TEE2EClockDeviceDBMgr.setOperFail(neID, errRet, 1092743443);
            return;
        }
        if (null == dbResult) {
            TEE2EClockDeviceDBMgr.logNullErrorOnDel(neID);
            TEE2EClockDeviceDBMgr.setOperFail(neID, errRet, 1092743443);
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEE2EClockDeviceDBMgr.logRetCodeErrorOnDel(neID, retCode);
            TEE2EClockDeviceDBMgr.setOperFail(neID, errRet, retCode);
        }
    }

    private static void setOperFail(int neID, TEErrInfoReturn rspErrRet, int retCode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = ne.getNEName();
        rspErrRet.setResult(1090605056);
        rspErrRet.addErrInfo(TEE2EGetClockDeviceUtil.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, retCode).getErrList());
    }

    private static void logNullNEError(int neID) {
        e2eLogger.error("ne is null! neID->" + neID);
    }

    private static void logRetCodeErrorOnGet(int neID, int retCode) {
        String tipStr = String.format("get clock to db device fail! neID:%d, retCode:%d", neID, retCode);
        e2eLogger.error(tipStr);
    }

    private static void logNullErrorOnGet(int neID) {
        e2eLogger.error("get clock device from db fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionOnGet(int neID, Exception e) {
        e2eLogger.error("get clock device from db fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnUpdate(int neID, int retCode) {
        String tipStr = String.format("update clock to db device fail! neID:%d, retCode:%d", neID, retCode);
        e2eLogger.error(tipStr);
    }

    private static void logNullErrorOnUpdate(int neID) {
        e2eLogger.error("update clock to db device fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionErrorOnUpdate(int neID, Exception e) {
        e2eLogger.error("update clock to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logNullErrorOnCreate(int neID) {
        e2eLogger.error("create clock to db device fail! neID->" + neID);
    }

    private static void logExceptionErrorOnCreate(int neID, Exception e) {
        e2eLogger.error("create clock to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnCreate(int neID, int retCode) {
        String tipStr = String.format("create clock to db device fail! neID:%d, retCode:%d", neID, retCode);
        e2eLogger.error(tipStr);
    }

    private static void logNullErrorOnDel(int neID) {
        e2eLogger.error("delete clock to db device fail! neID->" + neID);
    }

    private static void logExceptionErrorOnDel(int neID, Exception e) {
        e2eLogger.error("delete clock to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnDel(int neID, int retCode) {
        String tipStr = String.format("delete clock to db device fail! neID:%d, retCode:%d", neID, retCode);
        e2eLogger.error(tipStr);
    }
}

