/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.clock;

import com.huawei.nglct.nelist.model.TEQueryPortForDataMgr;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockDevice;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockPort;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockSource;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EPortClockSourceInfo;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EUniResID;
import com.huawei.nglct.nemgr.marine.e2e.clock.ptpclock.TEE2EBuildClockSource;
import com.huawei.nglct.po.embeddednemgrmo.otn.ptpclock.TEPTPClockPropertyMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.ptpclock.TEPTPClockSourceAttribMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.ptpclock.TEPTPExportClockAttribMOPO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class TEE2EClockConverterOTN {
    private TEE2EClockConverterOTN() {
    }

    public static TEE2EClockDevice mo2Data(int neID, TEPTPClockPropertyMOPO moDevice) {
        TEE2EClockDevice dataDevice = new TEE2EClockDevice();
        dataDevice.setNeID(neID);
        dataDevice.setPtpClockType((int)moDevice.getPTPClockWorkMode());
        dataDevice.setClockDomain((int)moDevice.getPTPDomain());
        dataDevice.setClockSourceList(TEE2EClockConverterOTN.mo2DataClockSource(neID, moDevice));
        dataDevice.setClockPortList(TEE2EClockConverterOTN.mo2DataClockPort(neID, moDevice));
        dataDevice.setClockSyncState(-1);
        dataDevice.setTimeSyncState(-1);
        dataDevice.setPoOperMask(-1);
        dataDevice.setPoSearchMode(1);
        dataDevice.setClockDevType(1);
        return dataDevice;
    }

    public static TEPTPClockPropertyMOPO data2MO(int neID, TEE2EClockDevice dataDevice) {
        TEPTPClockPropertyMOPO moDevice = new TEPTPClockPropertyMOPO();
        TEE2EClockSource innerClockSource = TEE2EClockConverterOTN.getInnerClock(dataDevice);
        if (null != innerClockSource) {
            moDevice.setPTPQuality((short)innerClockSource.getClockClass());
            moDevice.setPTPPrecision((short)innerClockSource.getClockAccuracy());
            moDevice.setPTPSrcPriority1((short)innerClockSource.getClockPriority1());
            moDevice.setPTPSrcPriority2((short)innerClockSource.getClockPriority2());
            moDevice.setPTPLocalSrcType((short)innerClockSource.getClockTimeSource());
            moDevice.setPTPOffset((int)((short)innerClockSource.getClockTimeSource()));
        } else {
            moDevice.setPTPQuality((short)-1);
            moDevice.setPTPPrecision((short)-1);
            moDevice.setPTPSrcPriority1((short)-1);
            moDevice.setPTPSrcPriority2((short)-1);
            moDevice.setPTPLocalSrcType((short)-1);
        }
        moDevice.setPTPEnable((short)dataDevice.getPtpClockType());
        moDevice.setPTPClockWorkMode((short)dataDevice.getPtpClockType());
        moDevice.setPTPClockSrcID(-1L);
        moDevice.setPTPClockID("");
        moDevice.setPTPDomain((short)dataDevice.getClockDomain());
        moDevice.setPtpInfoMode((short)-1);
        moDevice.setPtpTimeEnable((short)-1);
        moDevice.setPtpFreqEnable((short)-1);
        moDevice.setPTPClockSlaveOnly((short)-1);
        moDevice.setStaticBMC((short)-1);
        moDevice.setPTPClockSourceList(TEE2EClockConverterOTN.data2MO(dataDevice, dataDevice.getClockSourceList()));
        return moDevice;
    }

    private static Set<TEPTPClockSourceAttribMOPO> data2MO(TEE2EClockDevice dataDevice, List<TEE2EClockSource> clockSourceList) {
        HashSet<TEPTPClockSourceAttribMOPO> clockSourceMOSet = new HashSet<TEPTPClockSourceAttribMOPO>();
        List clockPortList = dataDevice.getClockPortList();
        TEPTPClockSourceAttribMOPO sourceMO = null;
        for (TEE2EClockSource dataSource : clockSourceList) {
            if (dataSource.getType() != 2) continue;
            sourceMO = TEE2EClockConverterOTN.data2MO(dataSource);
            for (TEE2EClockPort clockPort : clockPortList) {
                if (!clockPort.getPortIndex().getStrFDN().equals(dataSource.getPoPortClockSource().getInPort().getStrFDN())) continue;
                sourceMO.setPTPPortRealState((short)clockPort.getState());
            }
            clockSourceMOSet.add(sourceMO);
        }
        return clockSourceMOSet;
    }

    private static TEPTPClockSourceAttribMOPO data2MO(TEE2EClockSource dataSource) {
        TEPTPClockSourceAttribMOPO sourceMO = new TEPTPClockSourceAttribMOPO();
        sourceMO.setClockID(Long.parseLong(dataSource.getClockID()));
        sourceMO.setFarClockID(dataSource.getPoPortClockSource().getInPort().getStrFDN());
        return sourceMO;
    }

    private static TEE2EClockSource getInnerClock(TEE2EClockDevice dataDevice) {
        List clockSourceList = dataDevice.getClockSourceList();
        for (TEE2EClockSource source : clockSourceList) {
            if (1 != source.getType()) continue;
            return source;
        }
        return null;
    }

    private static List<TEE2EClockSource> mo2DataClockSource(int neID, TEPTPClockPropertyMOPO moDevice) {
        ArrayList<TEE2EClockSource> dataClockSource = new ArrayList<TEE2EClockSource>();
        Set moOuterClockSet = moDevice.getPTPExportClockAttribList();
        dataClockSource.addAll(TEE2EClockConverterOTN.buildInnerClockSource(neID, moDevice));
        dataClockSource.addAll(TEE2EClockConverterOTN.buildPortClockSource(neID, moDevice));
        dataClockSource.addAll(TEE2EClockConverterOTN.buildOuterClockSource(neID, moOuterClockSet));
        return dataClockSource;
    }

    private static List<TEE2EClockPort> mo2DataClockPort(int neID, TEPTPClockPropertyMOPO moDevice) {
        ArrayList<TEE2EClockPort> dataClockPortList = new ArrayList<TEE2EClockPort>();
        Set moInnerClockSet = moDevice.getPTPClockSourceList();
        for (TEPTPClockSourceAttribMOPO moClock : moInnerClockSet) {
            dataClockPortList.add(TEE2EClockConverterOTN.buildPtpPort(neID, moClock));
        }
        return dataClockPortList;
    }

    private static TEE2EClockPort buildPtpPort(int neID, TEPTPClockSourceAttribMOPO moClock) {
        long moClockID = moClock.getClockID();
        int slotID = TEE2EClockConverterOTN.getSlotIDFromClockID(moClockID);
        int portID = TEE2EClockConverterOTN.getPortIDFromClockID(neID, moClockID);
        short portworkmode = moClock.getPTPPortRealState();
        short portstatus = moClock.getPTPPortRealState();
        TEE2EClockPort dataPort = TEE2EBuildClockSource.buildClockPortList(neID, slotID, portID, portworkmode, portstatus);
        return dataPort;
    }

    private static List<TEE2EClockSource> buildInnerClockSource(int neID, TEPTPClockPropertyMOPO moDevice) {
        ArrayList<TEE2EClockSource> dataClockList = new ArrayList<TEE2EClockSource>();
        TEE2EClockSource clock = TEE2EClockConverterOTN.createClockWithLocalInfo(neID, moDevice);
        clock.setType(1);
        dataClockList.add(clock);
        return dataClockList;
    }

    private static List<TEE2EClockSource> buildPortClockSource(int neID, TEPTPClockPropertyMOPO moDevice) {
        Set moPortClockSet = moDevice.getPTPClockSourceList();
        ArrayList<TEE2EClockSource> dataClockList = new ArrayList<TEE2EClockSource>();
        for (TEPTPClockSourceAttribMOPO moPortClock : moPortClockSet) {
            dataClockList.add(TEE2EClockConverterOTN.mo2Data(neID, moDevice, moPortClock));
        }
        return dataClockList;
    }

    private static List<TEE2EClockSource> buildOuterClockSource(int neID, Set<TEPTPExportClockAttribMOPO> moOuterClockSet) {
        ArrayList<TEE2EClockSource> dataClockList = new ArrayList<TEE2EClockSource>();
        for (TEPTPExportClockAttribMOPO moOuterClock : moOuterClockSet) {
            dataClockList.add(TEE2EClockConverterOTN.mo2Data(neID, moOuterClock));
        }
        return dataClockList;
    }

    private static TEE2EClockSource mo2Data(int neID, TEPTPClockPropertyMOPO moDevice, TEPTPClockSourceAttribMOPO moInnerClock) {
        TEE2EClockSource clock = TEE2EClockConverterOTN.createClockWithLocalInfo(neID, moDevice);
        clock.setType(2);
        long moClockID = moInnerClock.getClockID();
        int slotID = TEE2EClockConverterOTN.getSlotIDFromClockID(moClockID);
        int portID = TEE2EClockConverterOTN.getPortIDFromClockID(neID, moClockID);
        clock.setClockID(String.valueOf(moClockID));
        TEE2EPortClockSourceInfo portClock = new TEE2EPortClockSourceInfo();
        clock.setPoPortClockSource(portClock);
        TEE2EUniResID inPortID = TEE2EBuildClockSource.constructUniResID(neID, slotID, portID);
        TEE2EUniResID upStreamPortID = TEE2EBuildClockSource.constructUniResID(neID, slotID, portID);
        portClock.setInPort(inPortID);
        portClock.setType(1);
        portClock.setPoUpstreamPort(upStreamPortID);
        portClock.setPoClockSource("");
        portClock.setPoUpstreamClockSource("");
        portClock.setInPortName(TEE2EBuildClockSource.getPortName(neID, slotID, portID));
        portClock.setPoUpstreamName("");
        return clock;
    }

    private static TEE2EClockSource createClockWithLocalInfo(int neID, TEPTPClockPropertyMOPO moDevice) {
        TEE2EClockSource clock = new TEE2EClockSource();
        clock.setClockID("00F10001");
        clock.setClockAccuracy((int)moDevice.getPTPPrecision());
        clock.setClockClass((int)moDevice.getPTPQuality());
        clock.setClockPriority1((int)moDevice.getPTPSrcPriority1());
        clock.setClockPriority2((int)moDevice.getPTPSrcPriority2());
        clock.setClockTimeSource((int)moDevice.getPTPLocalSrcType());
        clock.setbIsCurrTrace(0);
        return clock;
    }

    public static int getSlotIDFromClockID(long moClockID) {
        int shelfID = (int)moClockID / 1000000;
        int relativeSlotID = (int)(moClockID % 1000000L / 1000L);
        return 65536 * shelfID + relativeSlotID;
    }

    public static int getPortIDFromClockID(int neID, long moClockID) {
        int portID = (int)(moClockID % 1000L);
        return TEQueryPortForDataMgr.getAbstractPortID((int)neID, (int)portID);
    }

    private static TEE2EClockSource mo2Data(int neID, TEPTPExportClockAttribMOPO moOuterClock) {
        TEE2EClockSource dataClock = new TEE2EClockSource();
        short clockID = moOuterClock.getExportID();
        if (1 == clockID) {
            dataClock.setClockID("00F00001");
        } else if (2 == clockID) {
            dataClock.setClockID("00F00002");
        }
        dataClock.setClockAccuracy((int)moOuterClock.getExportPrecision());
        dataClock.setClockClass((int)moOuterClock.getExportQuality());
        dataClock.setClockPriority1((int)moOuterClock.getExportPriority1());
        dataClock.setClockPriority2((int)moOuterClock.getExportPriority2());
        dataClock.setClockTimeSource((int)moOuterClock.getExportClockType());
        dataClock.setbIsCurrTrace(0);
        dataClock.setType(3);
        return dataClock;
    }
}

