/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.cablemgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnIntList;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineCable;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineCableList;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineRepeater;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineRepeaterList;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnModifyMarineCableReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnModifyMarineCableRsp;
import com.huawei.nglct.nemgr.marine.e2e.cablemgr.TEMarineCableMgrTask;
import com.huawei.nglct.nemgr.marine.e2e.cablemgr.TEMarineCableNoticeMgr;
import com.huawei.nglct.nemgr.marine.e2e.repeatermgr.TEMarineRepeaterNoticeMgr;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCablePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineRepeaterPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public class TEMarineModifyCableHandler {
    private static final int NOCHANGE_RPT_ACTION = 0;
    private static final int ADD_RPT_ACTION = 1;
    private static final int DEL_RPT_ACTION = 2;
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private static int TECMDCODE_MODIFY_MARINE_CABLE = 2179336;
    private static int TE_ERR_MARINE_CABLE_NOT_EXIST = 1090615307;

    public int handleRequest(AsnModifyMarineCableReq req, AsnModifyMarineCableRsp rsp, TaskMgr tm, TETaskInfo info) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("cablemgr").append(File.separator).append("cablemgr_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)0, (StringBuffer)filePath);
        ArrayList<TEMarineLogInfo> marineLogInfoList = new ArrayList<TEMarineLogInfo>();
        String ipAddress = TopoUtility.ipToString((long)info.getMsgHead().senderProcIP);
        int userID = req.userID.intValue();
        normalLogger.info(TEAsn1Util.getAsn1String((Object)req));
        AsnMarineCableList cableList = req.marineCableList;
        if (cableList.isEmpty()) {
            rsp.result.isSuccess = true;
            rsp.result.setRetCode(0);
            TEMarineLogInfo marineLogInfo = new TEMarineLogInfo();
            marineLogInfo.setCmdID(TECMDCODE_MODIFY_MARINE_CABLE);
            marineLogInfo.setOperateName(res.getString("slm_modify_cable"));
            marineLogInfo.setOperateDesc(this.getDetailStr(req, res));
            marineLogInfo.setOperateObject(res.getString("slm_modify_cable"));
            marineLogInfo.setErrCode(0);
            marineLogInfo.setResult(0);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 0;
        }
        int len = cableList.size();
        for (int i = 0; i < len; ++i) {
            TEMarineLogInfo marineLogInfo = new TEMarineLogInfo();
            marineLogInfo.setCmdID(TECMDCODE_MODIFY_MARINE_CABLE);
            marineLogInfo.setOperateName(res.getString("slm_modify_cable"));
            marineLogInfo.setOperateObject(res.getString("slm_modify_cable"));
            AsnMarineCable asnCable = (AsnMarineCable)cableList.get(i);
            int rptNumTmp = asnCable.rptNum.intValue();
            TEMarineCablePO cablePO = TEMarineCableMgrTask.asnCable2POCable(asnCable);
            cablePO.setRptNum(rptNumTmp);
            HashSet<TEMarineRepeaterPO> rptList = new HashSet<TEMarineRepeaterPO>();
            ArrayList<TEMarineCablePO> cablePOList = new ArrayList<TEMarineCablePO>();
            cablePOList.add(cablePO);
            int changeType = this.updateRptList(cablePOList, rptList);
            if (!cableList.isEmpty()) {
                cablePO.setRPTList(((TEMarineCablePO)cablePOList.get(0)).getRPTList());
            }
            cablePO.setRptNum(cablePO.getRPTList().size());
            asnCable.rptNum = BigInteger.valueOf(cablePO.getRptNum());
            if (!this.isCableExist(cablePO)) {
                normalLogger.error("cable is not exist!");
                rsp.result.isSuccess = false;
                rsp.result.setRetCode(TE_ERR_MARINE_CABLE_NOT_EXIST);
                marineLogInfo.setOperateDesc(this.getDetailStr(asnCable, res));
                marineLogInfo.setErrCode(TE_ERR_MARINE_CABLE_NOT_EXIST);
                marineLogInfo.setResult(TE_ERR_MARINE_CABLE_NOT_EXIST);
                marineLogInfoList.add(marineLogInfo);
                TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
                return 0;
            }
            TEDaoOperationResult dbResult = null;
            try {
                dbResult = TECommonDaoService.update((Object)cablePO);
            }
            catch (Exception e) {
                normalLogger.error("DB oper error!", (Throwable)e);
                rsp.result.isSuccess = false;
                rsp.result.setRetCode(1092743443);
                marineLogInfo.setOperateDesc(this.getDetailStr(asnCable, res));
                marineLogInfo.setErrCode(1092743443);
                marineLogInfo.setResult(2);
                marineLogInfoList.add(marineLogInfo);
                TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
                return 2;
            }
            if (null == dbResult) {
                normalLogger.error("The dbResult is null!");
                rsp.result.isSuccess = false;
                rsp.result.setRetCode(1092743443);
                marineLogInfo.setOperateDesc(this.getDetailStr(asnCable, res));
                marineLogInfo.setErrCode(1092743443);
                marineLogInfo.setResult(2);
                marineLogInfoList.add(marineLogInfo);
                TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
                return 2;
            }
            int retCode = dbResult.getResult();
            if (0 == retCode) {
                TEMarineCableNoticeMgr.sendModifyCableNtfToC(asnCable);
                if (changeType == 1) {
                    this.sendAddRepeaterDataToC(cablePO.getCableID(), rptList);
                } else if (changeType == 2) {
                    this.sendDelRepeaterDataToC(cablePO.getCableID(), rptList);
                }
                rsp.result.isSuccess = true;
                rsp.result.setRetCode(retCode);
                marineLogInfo.setOperateDesc(this.getDetailStr(asnCable, res));
                marineLogInfo.setErrCode(0);
                marineLogInfo.setResult(0);
                marineLogInfoList.add(marineLogInfo);
                continue;
            }
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(retCode);
            marineLogInfo.setOperateDesc(this.getDetailStr(asnCable, res));
            marineLogInfo.setErrCode(retCode);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
        }
        TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
        normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    private boolean isCableExist(TEMarineCablePO cablePO) {
        if (null == cablePO) {
            return false;
        }
        TEDaoOperationResult dbResult = null;
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair aPair = new TEDaoNameValuePair("CableID", String.valueOf(cablePO.getCableID()));
        criteria.add(aPair);
        try {
            dbResult = TECommonDaoService.findByID(TEMarineCablePO.class, criteria);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Marine----Find the cable by id in DataBase fail!", (Throwable)e);
            return false;
        }
        if (null == dbResult) {
            return false;
        }
        int result = dbResult.getResult();
        if (0 == result) {
            List objList = dbResult.getData();
            for (Object obj : objList) {
                TEMarineCablePO aCable = (TEMarineCablePO)obj;
                if (aCable.getCableID() != cablePO.getCableID()) continue;
                return true;
            }
        }
        return false;
    }

    private int updateRptList(List<TEMarineCablePO> cablePOList, Set<TEMarineRepeaterPO> rptList) {
        if (null == cablePOList || cablePOList.isEmpty()) {
            return 0;
        }
        int changeType = 0;
        TEDaoOperationResult dbResult = null;
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair aPair = new TEDaoNameValuePair("CableID", String.valueOf(cablePOList.get(0).getCableID()));
        criteria.add(aPair);
        try {
            dbResult = TECommonDaoService.findByID(TEMarineCablePO.class, criteria);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Marine----Find Repeater by id in DataBase fail!", (Throwable)e);
            return 0;
        }
        if (null == dbResult) {
            return 0;
        }
        List objList = dbResult.getData();
        TEMarineCablePO tmpCablePO = new TEMarineCablePO();
        Set rptPOSet = null;
        Iterator i$ = objList.iterator();
        if (i$.hasNext()) {
            Object obj = i$.next();
            tmpCablePO = (TEMarineCablePO)obj;
        }
        if (cablePOList.get(0).getRptNum() > tmpCablePO.getRptNum()) {
            TEMarineCableMgrTask.addRptData(tmpCablePO, rptList, cablePOList.get(0).getRptNum() - tmpCablePO.getRptNum());
            changeType = 1;
        } else if (cablePOList.get(0).getRptNum() < tmpCablePO.getRptNum()) {
            TEMarineCableMgrTask.delRptData(tmpCablePO, rptList, tmpCablePO.getRptNum() - cablePOList.get(0).getRptNum());
            changeType = 2;
        } else {
            rptPOSet = tmpCablePO.getRPTList();
            cablePOList.get(0).setRPTList(rptPOSet);
            changeType = 0;
        }
        cablePOList.clear();
        cablePOList.add(tmpCablePO);
        return changeType;
    }

    private void sendAddRepeaterDataToC(int cableID, Set<TEMarineRepeaterPO> rptList) {
        if (null == rptList || rptList.isEmpty()) {
            return;
        }
        AsnMarineRepeaterList rptDataList = new AsnMarineRepeaterList();
        for (TEMarineRepeaterPO rptPO : rptList) {
            AsnMarineRepeater rptData = new AsnMarineRepeater();
            rptData.rptId = BigInteger.valueOf(rptPO.RptID);
            rptData.name = rptPO.Name.getBytes();
            rptData.remark = rptPO.Remark.getBytes();
            rptDataList.add((Object)rptData);
        }
        TEMarineRepeaterNoticeMgr.sendRepeaterCreateNoticeToClient(cableID, rptDataList);
    }

    private void sendDelRepeaterDataToC(int cableID, Set<TEMarineRepeaterPO> rptList) {
        if (null == rptList || rptList.isEmpty()) {
            return;
        }
        AsnIntList rptIDList = new AsnIntList();
        for (TEMarineRepeaterPO rptPO : rptList) {
            rptIDList.add(rptPO.getID());
        }
        TEMarineRepeaterNoticeMgr.sendDelRepeaterNtfToC(cableID, rptIDList);
    }

    public String getDetailStr(AsnModifyMarineCableReq req, TEResourceUtil res) {
        StringBuffer bf = new StringBuffer("");
        AsnMarineCableList cableList = req.marineCableList;
        AsnMarineCable cable = null;
        int len = cableList.size();
        for (int i = 0; i < len; ++i) {
            cable = (AsnMarineCable)cableList.get(i);
            bf.append(res.getString("source_str")).append(':');
            String srcStationName = new String(cable.srcStationName);
            if (!srcStationName.trim().equals("")) {
                bf.append(srcStationName).append('-');
            }
            bf.append(new String(cable.srcNodeName)).append(',');
            bf.append(res.getString("sink_str")).append(':');
            String sinkStationName = new String(cable.sinkStationName);
            if (!sinkStationName.trim().equals("")) {
                bf.append(sinkStationName).append('-');
            }
            bf.append(new String(cable.sinkNodeName)).append(',');
            bf.append(res.getString("name_str")).append(':');
            bf.append(new String(cable.cableName)).append(',');
            bf.append(res.getString("cablelenlable")).append(':');
            bf.append(cable.cableLen).append(',');
            bf.append(res.getString("cableresistancelabel")).append(':');
            bf.append((double)cable.cableResistance.intValue() / 10.0).append(',');
            bf.append(res.getString("cable20resistancelabel")).append(':');
            bf.append((double)cable.cable20Resistance.intValue() / 10.0).append(',');
            bf.append(res.getString("cablecurtemplabel")).append(':');
            bf.append(cable.curtemperature.intValue()).append(',');
            bf.append(res.getString("rpt_num_str")).append(':');
            bf.append(cable.rptNum).append(',');
            bf.append(res.getString("memo_str")).append(':');
            bf.append(new String(cable.cableMemo)).append(',');
            bf.append(res.getString("fault_type")).append(':');
            bf.append(res.getString("fault_type_" + cable.faultType)).append(';');
        }
        return bf.toString();
    }

    public String getDetailStr(AsnMarineCable cable, TEResourceUtil res) {
        StringBuffer bf = new StringBuffer("");
        bf.append(res.getString("source_str")).append(':');
        String srcStationName = new String(cable.srcStationName);
        if (!srcStationName.trim().equals("")) {
            bf.append(srcStationName).append('-');
        }
        bf.append(new String(cable.srcNodeName)).append(',');
        bf.append(res.getString("sink_str")).append(':');
        String sinkStationName = new String(cable.sinkStationName);
        if (!sinkStationName.trim().equals("")) {
            bf.append(sinkStationName).append('-');
        }
        bf.append(new String(cable.sinkNodeName)).append(',');
        bf.append(res.getString("name_str")).append(':');
        bf.append(new String(cable.cableName)).append(',');
        bf.append(res.getString("cablelenlable")).append(':');
        bf.append(cable.cableLen).append(',');
        bf.append(res.getString("cableresistancelabel")).append(':');
        bf.append((double)cable.cableResistance.intValue() / 10.0).append(',');
        bf.append(res.getString("cable20resistancelabel")).append(':');
        bf.append((double)cable.cable20Resistance.intValue() / 10.0).append(',');
        bf.append(res.getString("cablecurtemplabel")).append(':');
        bf.append(cable.curtemperature.intValue()).append(',');
        bf.append(res.getString("rpt_num_str")).append(':');
        bf.append(cable.rptNum).append(',');
        bf.append(res.getString("memo_str")).append(':');
        bf.append(new String(cable.cableMemo)).append(',');
        bf.append(res.getString("fault_type")).append(':');
        bf.append(res.getString("fault_type_" + cable.faultType)).append(';');
        return bf.toString();
    }
}

