/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.cablemgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnGetMarineCableReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnGetMarineCableRsp;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineCable;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineCableList;
import com.huawei.nglct.nemgr.marine.e2e.cablemgr.TEMarineCableMgrTask;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCablePO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEMarineGetCableHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private static int TECMDCODE_GET_MARINE_CABLE = 2179334;

    public int handleRequest(AsnGetMarineCableReq req, AsnGetMarineCableRsp rsp, TaskMgr tm, TETaskInfo info) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("cablemgr").append(File.separator).append("cablemgr_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)0, (StringBuffer)filePath);
        ArrayList<TEMarineLogInfo> marineLogInfoList = new ArrayList<TEMarineLogInfo>();
        TEMarineLogInfo marineLogInfo = new TEMarineLogInfo();
        marineLogInfo.setCmdID(TECMDCODE_GET_MARINE_CABLE);
        marineLogInfo.setOperateName(res.getString("slm_query_cable"));
        marineLogInfo.setOperateDesc(res.getString("slm_query_cable"));
        marineLogInfo.setOperateObject(res.getString("slm_query_cable"));
        String ipAddress = TopoUtility.ipToString((long)info.getMsgHead().senderProcIP);
        int userID = req.userID.intValue();
        normalLogger.info(TEAsn1Util.getAsn1String((Object)req));
        TEDaoOperationResult dbResult = null;
        try {
            int cableID = req.cableID.intValue();
            if (0 == cableID) {
                dbResult = TECommonDaoService.findAll(TEMarineCablePO.class);
            } else {
                ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
                TEDaoNameValuePair aPair = new TEDaoNameValuePair("CableID", String.valueOf(cableID));
                criteria.add(aPair);
                dbResult = TECommonDaoService.findByID(TEMarineCablePO.class, criteria);
            }
        }
        catch (Exception e) {
            normalLogger.error("DB oper error!", (Throwable)e);
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        if (null == dbResult) {
            normalLogger.error("The dbResult is null!");
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(1092743443);
            marineLogInfo.setErrCode(1092743443);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
            return 2;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            AsnMarineCableList asnStationList = rsp.marineCableList;
            AsnMarineCable asnCable = null;
            TEMarineCablePO cablePO = null;
            List data = dbResult.getData();
            for (Object obj : data) {
                cablePO = (TEMarineCablePO)obj;
                asnCable = TEMarineCableMgrTask.poCable2AsnCable(cablePO);
                asnStationList.add((Object)asnCable);
            }
            rsp.result.isSuccess = true;
            rsp.result.setRetCode(retCode);
            marineLogInfo.setErrCode(0);
            marineLogInfo.setResult(0);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
        } else {
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(retCode);
            marineLogInfo.setErrCode(retCode);
            marineLogInfo.setResult(2);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID, ipAddress, marineLogInfoList);
        }
        normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }
}

